/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.integration.crafttweaker.recipe.manager;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.CraftTweakerConstants;
import com.blamejared.crafttweaker.api.action.base.IAction;
import com.blamejared.crafttweaker.api.action.recipe.ActionAddRecipe;
import com.blamejared.crafttweaker.api.action.recipe.ActionRemoveRecipe;
import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.ingredient.IIngredient;
import com.blamejared.crafttweaker.api.recipe.handler.IRecipeHandler;
import com.blamejared.crafttweaker.api.recipe.handler.IReplacementRule;
import com.blamejared.crafttweaker.api.recipe.handler.helper.ReplacementHandlerHelper;
import com.blamejared.crafttweaker.api.recipe.manager.base.IRecipeManager;
import com.blamejared.crafttweaker.api.util.StringUtil;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.function.Function;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import org.openzen.zencode.java.ZenCodeType;
import vazkii.botania.api.brew.Brew;
import vazkii.botania.api.recipe.IBrewRecipe;
import vazkii.botania.common.crafting.ModRecipeTypes;
import vazkii.botania.common.crafting.RecipeBrew;
import vazkii.botania.common.integration.crafttweaker.natives.ExpandBrew;

@Document(value="mods/Botania/recipe/manager/BrewRecipeManager")
@ZenRegister
@IRecipeHandler.For(value=IBrewRecipe.class)
@ZenCodeType.Name(value="mods.botania.recipe.manager.BrewRecipeManager")
public class BrewRecipeManager
implements IRecipeManager<IBrewRecipe>,
IRecipeHandler<IBrewRecipe> {
    @ZenCodeType.Method
    public void addRecipe(String name, Brew output, IIngredient ... inputs) {
        name = this.fixRecipeName(name);
        ResourceLocation resourceLocation = CraftTweakerConstants.rl((String)name);
        CraftTweakerAPI.apply((IAction)new ActionAddRecipe((IRecipeManager)this, (Recipe)new RecipeBrew(resourceLocation, output, (Ingredient[])Arrays.stream(inputs).map(IIngredient::asVanillaIngredient).toArray(Ingredient[]::new))));
    }

    @ZenCodeType.Method
    public void remove(Brew output) {
        CraftTweakerAPI.apply((IAction)new ActionRemoveRecipe((IRecipeManager)this, recipe -> recipe.getBrew() == output));
    }

    public RecipeType<IBrewRecipe> getRecipeType() {
        return ModRecipeTypes.BREW_TYPE;
    }

    public String dumpToCommandString(IRecipeManager manager, IBrewRecipe recipe) {
        StringJoiner s = new StringJoiner(", ", manager.getCommandString() + ".addRecipe(", ");");
        s.add(StringUtil.quoteAndEscape((ResourceLocation)recipe.m_6423_()));
        s.add(ExpandBrew.getCommandString(recipe.getBrew()));
        recipe.m_7527_().stream().map(IIngredient::fromIngredient).map(IIngredient::getCommandString).forEach(s::add);
        return s.toString();
    }

    public Optional<Function<ResourceLocation, IBrewRecipe>> replaceIngredients(IRecipeManager manager, IBrewRecipe recipe, List<IReplacementRule> rules) {
        return ReplacementHandlerHelper.replaceNonNullIngredientList((NonNullList)recipe.m_7527_(), Ingredient.class, (Recipe)recipe, rules, ingr -> id -> new RecipeBrew((ResourceLocation)id, recipe.getBrew(), (Ingredient[])ingr.toArray((Object[])new Ingredient[0])));
    }
}

