/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.tile.mana;

import com.mojang.blaze3d.vertex.PoseStack;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import vazkii.botania.api.block.IWandHUD;
import vazkii.botania.api.block.IWandable;
import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.common.block.tile.ModTiles;
import vazkii.botania.common.block.tile.TileMod;
import vazkii.botania.common.block.tile.mana.TileSpreader;

public class TileTurntable
extends TileMod
implements IWandable {
    private static final String TAG_SPEED = "speed";
    private static final String TAG_BACKWARDS = "backwards";
    private int speed = 1;
    private boolean backwards = false;

    public TileTurntable(BlockPos pos, BlockState state) {
        super(ModTiles.TURNTABLE, pos, state);
    }

    public static void commonTick(Level level, BlockPos worldPosition, BlockState state, TileTurntable self) {
        BlockEntity tile;
        if (!level.m_46753_(worldPosition) && (tile = level.m_7702_(worldPosition.m_7494_())) instanceof TileSpreader) {
            TileSpreader spreader = (TileSpreader)tile;
            spreader.rotationX = spreader.rotationX + (float)(self.speed * (self.backwards ? -1 : 1));
            if (spreader.rotationX >= 360.0f) {
                spreader.rotationX -= 360.0f;
            }
            if (!level.f_46443_) {
                spreader.checkForReceiver();
            }
        }
    }

    @Override
    public void writePacketNBT(CompoundTag cmp) {
        cmp.m_128405_(TAG_SPEED, this.speed);
        cmp.m_128379_(TAG_BACKWARDS, this.backwards);
    }

    @Override
    public void readPacketNBT(CompoundTag cmp) {
        this.speed = cmp.m_128451_(TAG_SPEED);
        this.backwards = cmp.m_128471_(TAG_BACKWARDS);
    }

    @Override
    public boolean onUsedByWand(@Nullable Player player, ItemStack wand, Direction side) {
        if (player != null && player.m_6144_() || player == null && side == Direction.DOWN) {
            this.backwards = !this.backwards;
        } else {
            this.speed = this.speed == 6 ? 1 : this.speed + 1;
        }
        VanillaPacketDispatcher.dispatchTEToNearbyPlayers(this);
        return true;
    }

    public static class WandHud
    implements IWandHUD {
        private final TileTurntable turntable;

        public WandHud(TileTurntable turntable) {
            this.turntable = turntable;
        }

        @Override
        public void renderHUD(PoseStack ms, Minecraft mc) {
            int color = -1442814464;
            char motion = this.turntable.backwards ? (char)'<' : '>';
            String speed = "" + ChatFormatting.BOLD;
            for (int i = 0; i < this.turntable.speed; ++i) {
                speed = speed + motion;
            }
            int x = mc.m_91268_().m_85445_() / 2 - mc.f_91062_.m_92895_(speed) / 2;
            int y = mc.m_91268_().m_85446_() / 2 - 15;
            mc.f_91062_.m_92750_(ms, speed, (float)x, (float)y, color);
        }
    }
}

