/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.integration.jei;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import javax.annotation.Nonnull;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.Vec2;
import vazkii.botania.api.recipe.ITerraPlateRecipe;
import vazkii.botania.client.gui.HUDHandler;
import vazkii.botania.client.integration.jei.PetalApothecaryRecipeCategory;
import vazkii.botania.client.integration.jei.TerraPlateDrawable;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.lib.ResourceLocationHelper;

public class TerraPlateRecipeCategory
implements IRecipeCategory<ITerraPlateRecipe> {
    public static final ResourceLocation UID = ResourceLocationHelper.prefix("terra_plate");
    private final Component localizedName;
    private final IDrawable background;
    private final IDrawable overlay;
    private final IDrawable icon;
    private final IDrawable terraPlate;

    public TerraPlateRecipeCategory(IGuiHelper guiHelper) {
        ResourceLocation location = ResourceLocationHelper.prefix("textures/gui/terrasteel_jei_overlay.png");
        this.background = guiHelper.createBlankDrawable(114, 131);
        this.overlay = guiHelper.createDrawable(location, 42, 29, 64, 64);
        this.icon = guiHelper.createDrawableIngredient(VanillaTypes.ITEM, (Object)new ItemStack((ItemLike)ModBlocks.terraPlate));
        this.localizedName = new TranslatableComponent("botania.nei.terraPlate");
        IDrawable livingrock = guiHelper.createDrawableIngredient(VanillaTypes.ITEM, (Object)new ItemStack((ItemLike)ModBlocks.livingrock));
        this.terraPlate = new TerraPlateDrawable(livingrock, livingrock, guiHelper.createDrawableIngredient(VanillaTypes.ITEM, (Object)new ItemStack((ItemLike)Blocks.f_50060_)));
    }

    @Nonnull
    public ResourceLocation getUid() {
        return UID;
    }

    @Nonnull
    public Class<? extends ITerraPlateRecipe> getRecipeClass() {
        return ITerraPlateRecipe.class;
    }

    @Nonnull
    public Component getTitle() {
        return this.localizedName;
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    @Nonnull
    public IDrawable getIcon() {
        return this.icon;
    }

    public void draw(@Nonnull ITerraPlateRecipe recipe, @Nonnull IRecipeSlotsView view, @Nonnull PoseStack ms, double mouseX, double mouseY) {
        RenderSystem.m_69478_();
        this.overlay.draw(ms, 25, 14);
        HUDHandler.renderManaBar(ms, 6, 126, 255, 0.75f, recipe.getMana(), 100000);
        this.terraPlate.draw(ms, 35, 92);
        RenderSystem.m_69461_();
    }

    public void setRecipe(@Nonnull IRecipeLayoutBuilder builder, @Nonnull ITerraPlateRecipe recipe, @Nonnull IFocusGroup focusGroup) {
        builder.addSlot(RecipeIngredientRole.OUTPUT, 48, 37).addItemStack(recipe.m_8043_());
        double angleBetweenEach = 360.0 / (double)recipe.m_7527_().size();
        Vec2 point = new Vec2(48.0f, 5.0f);
        Vec2 center = new Vec2(48.0f, 37.0f);
        for (Ingredient ingr : recipe.m_7527_()) {
            builder.addSlot(RecipeIngredientRole.INPUT, (int)point.f_82470_, (int)point.f_82471_).addIngredients(ingr);
            point = PetalApothecaryRecipeCategory.rotatePointAbout(point, center, angleBetweenEach);
        }
        builder.addSlot(RecipeIngredientRole.CATALYST, 48, 92).addItemStack(new ItemStack((ItemLike)ModBlocks.terraPlate));
    }
}

