/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.api.subtile;

import com.mojang.blaze3d.vertex.PoseStack;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.BotaniaAPIClient;
import vazkii.botania.api.block.IWandHUD;
import vazkii.botania.api.internal.IManaNetwork;
import vazkii.botania.api.mana.IManaPool;
import vazkii.botania.api.subtile.TileEntityBindableSpecialFlower;

public abstract class TileEntityFunctionalFlower
extends TileEntityBindableSpecialFlower<IManaPool> {
    private static final ResourceLocation POOL_ID = new ResourceLocation("botania", "mana_pool");
    public static final int LINK_RANGE = 10;
    private static final String TAG_MANA = "mana";
    private int mana;
    public int redstoneSignal = 0;

    public TileEntityFunctionalFlower(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state, IManaPool.class);
    }

    public boolean acceptsRedstone() {
        return false;
    }

    @Override
    public void tickFlower() {
        super.tickFlower();
        this.drawManaFromPool();
        this.redstoneSignal = 0;
        if (this.acceptsRedstone()) {
            for (Direction dir : Direction.values()) {
                int redstoneSide = this.m_58904_().m_46681_(this.m_58899_().m_142300_(dir), dir);
                this.redstoneSignal = Math.max(this.redstoneSignal, redstoneSide);
            }
        }
        if (this.m_58904_().f_46443_) {
            double particleChance = 1.0 - (double)this.mana / (double)this.getMaxMana() / 3.5;
            int color = this.getColor();
            float red = (float)(color >> 16 & 0xFF) / 255.0f;
            float green = (float)(color >> 8 & 0xFF) / 255.0f;
            float blue = (float)(color & 0xFF) / 255.0f;
            if (Math.random() > particleChance) {
                BotaniaAPI.instance().sparkleFX(this.m_58904_(), (double)this.m_58899_().m_123341_() + 0.3 + Math.random() * 0.5, (double)this.m_58899_().m_123342_() + 0.5 + Math.random() * 0.5, (double)this.m_58899_().m_123343_() + 0.3 + Math.random() * 0.5, red, green, blue, (float)Math.random(), 5);
            }
        }
    }

    @Override
    public int getBindingRadius() {
        return 10;
    }

    @Override
    @Nullable
    public BlockPos findClosestTarget() {
        IManaNetwork network = BotaniaAPI.instance().getManaNetworkInstance();
        IManaPool closestPool = network.getClosestPool(this.m_58899_(), this.m_58904_(), this.getBindingRadius());
        return closestPool == null ? null : closestPool.getManaReceiverPos();
    }

    public void drawManaFromPool() {
        IManaPool pool = (IManaPool)this.findBoundTile();
        if (pool != null) {
            int manaInPool = pool.getCurrentMana();
            int manaMissing = this.getMaxMana() - this.mana;
            int manaToRemove = Math.min(manaMissing, manaInPool);
            pool.receiveMana(-manaToRemove);
            this.addMana(manaToRemove);
        }
    }

    public int getMana() {
        return this.mana;
    }

    public void addMana(int mana) {
        this.mana = Mth.m_14045_((int)(this.mana + mana), (int)0, (int)this.getMaxMana());
        this.m_6596_();
    }

    public abstract int getMaxMana();

    public abstract int getColor();

    @Override
    public void readFromPacketNBT(CompoundTag cmp) {
        super.readFromPacketNBT(cmp);
        this.mana = cmp.m_128451_(TAG_MANA);
    }

    @Override
    public void writeToPacketNBT(CompoundTag cmp) {
        super.writeToPacketNBT(cmp);
        cmp.m_128405_(TAG_MANA, this.mana);
    }

    public ItemStack getHudIcon() {
        return Registry.f_122827_.m_6612_(POOL_ID).map(ItemStack::new).orElse(ItemStack.f_41583_);
    }

    public static class FunctionalWandHud<T extends TileEntityFunctionalFlower>
    implements IWandHUD {
        protected final T flower;

        public FunctionalWandHud(T flower) {
            this.flower = flower;
        }

        @Override
        public void renderHUD(PoseStack ms, Minecraft mc) {
            String name = I18n.m_118938_((String)this.flower.m_58900_().m_60734_().m_7705_(), (Object[])new Object[0]);
            int color = ((TileEntityFunctionalFlower)this.flower).getColor();
            BotaniaAPIClient.instance().drawComplexManaHUD(ms, color, ((TileEntityFunctionalFlower)this.flower).getMana(), ((TileEntityFunctionalFlower)this.flower).getMaxMana(), name, ((TileEntityFunctionalFlower)this.flower).getHudIcon(), ((TileEntityBindableSpecialFlower)this.flower).isValidBinding());
        }
    }
}

