/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.biomemakeover.util.registry.boat;

import com.google.common.collect.Lists;
import dev.architectury.registry.client.level.entity.EntityModelLayerRegistry;
import java.util.List;
import net.minecraft.client.model.BoatModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import party.lemons.biomemakeover.BiomeMakeover;
import party.lemons.biomemakeover.init.BMBlocks;
import party.lemons.biomemakeover.util.registry.WoodTypeInfo;
import party.lemons.biomemakeover.util.registry.boat.BoatType;
import party.lemons.biomemakeover.util.registry.boat.VanillaBoatType;

public class BoatTypes {
    public static List<BoatType> TYPES = Lists.newArrayList();
    public static final BoatType BLIGHTED_BALSA = new BoatType(BiomeMakeover.ID("blighted_balsa"), () -> (ItemLike)BMBlocks.BLIGHTED_BALSA_WOOD_INFO.getItem(WoodTypeInfo.Type.BOAT).get());
    public static final BoatType WILLOW = new BoatType(BiomeMakeover.ID("willow"), () -> (ItemLike)BMBlocks.WILLOW_WOOD_INFO.getItem(WoodTypeInfo.Type.BOAT).get());
    public static final BoatType SWAMP_CYPRESS = new BoatType(BiomeMakeover.ID("swamp_cypress"), () -> (ItemLike)BMBlocks.SWAMP_CYPRESS_WOOD_INFO.getItem(WoodTypeInfo.Type.BOAT).get());
    public static final BoatType ANCIENT_OAK = new BoatType(BiomeMakeover.ID("ancient_oak"), () -> (ItemLike)BMBlocks.ANCIENT_OAK_WOOD_INFO.getItem(WoodTypeInfo.Type.BOAT).get());
    public static final BoatType ACACIA = new VanillaBoatType(BiomeMakeover.ID("acacia"), Boat.Type.ACACIA, Items.f_42745_);
    public static final BoatType BIRCH = new VanillaBoatType(BiomeMakeover.ID("birch"), Boat.Type.BIRCH, Items.f_42743_);
    public static final BoatType DARK_OAK = new VanillaBoatType(BiomeMakeover.ID("dark_oak"), Boat.Type.DARK_OAK, Items.f_42746_);
    public static final BoatType JUNGLE = new VanillaBoatType(BiomeMakeover.ID("jungle"), Boat.Type.JUNGLE, Items.f_42744_);
    public static final BoatType OAK = new VanillaBoatType(BiomeMakeover.ID("oak"), Boat.Type.OAK, Items.f_42453_);
    public static final BoatType SPRUCE = new VanillaBoatType(BiomeMakeover.ID("spruce"), Boat.Type.SPRUCE, Items.f_42742_);

    public static BoatType getVanillaType(Boat.Type boatType) {
        for (BoatType t : TYPES) {
            if (!(t instanceof VanillaBoatType) || ((VanillaBoatType)t).getVanillaType() != boatType) continue;
            return t;
        }
        return null;
    }

    public static void registerModelLayers() {
        for (BoatType type : TYPES) {
            EntityModelLayerRegistry.register((ModelLayerLocation)new ModelLayerLocation(new ResourceLocation("biomemakeover", type.getModelLocation()), "main"), BoatModel::m_170463_);
        }
    }
}

