/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.biomemakeover.util.effect;

import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import party.lemons.biomemakeover.BiomeMakeoverClient;
import party.lemons.biomemakeover.block.blockentity.AltarBlockEntity;
import party.lemons.biomemakeover.util.RandomUtil;

public enum BiomeMakeoverEffect {
    PLAY_CURSE_SOUND(BiomeMakeoverEffect::playCurseSound),
    BLOCK_ENDER_PARTICLES(BiomeMakeoverEffect::createEnderParticles);

    private final Event event;

    private static void createEnderParticles(Level level, BlockPos pos) {
        Random random = RandomUtil.RANDOM;
        for (int i = 0; i < 5; ++i) {
            int xOffset = random.nextInt(2) * 2 - 1;
            int zOffset = random.nextInt(2) * 2 - 1;
            double x = (double)pos.m_123341_() + 0.5 + 0.25 * (double)xOffset;
            double y = (float)pos.m_123342_() + random.nextFloat();
            double z = (double)pos.m_123343_() + 0.5 + 0.25 * (double)zOffset;
            double vX = random.nextFloat() * (float)xOffset;
            double vY = ((double)random.nextFloat() - 0.5) * 0.125;
            double vZ = random.nextFloat() * (float)zOffset;
            level.m_7106_((ParticleOptions)ParticleTypes.f_123760_, x, y, z, vX, vY, vZ);
        }
    }

    private static void playCurseSound(Level world, BlockPos pos) {
        BlockEntity be = world.m_7702_(pos);
        if (be instanceof AltarBlockEntity) {
            AltarBlockEntity altar = (AltarBlockEntity)be;
            if (world.m_5776_()) {
                BiomeMakeoverClient.curseSound(altar);
            }
        }
    }

    private BiomeMakeoverEffect(Event event) {
        this.event = event;
    }

    public void execute(Level world, BlockPos pos) {
        this.event.execute(world, pos);
    }

    public static interface Event {
        public void execute(Level var1, BlockPos var2);
    }
}

