/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.biomemakeover.level.generate.foliage;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.TreeFeature;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacerType;
import party.lemons.biomemakeover.init.BMWorldGen;
import party.lemons.biomemakeover.util.RandomUtil;

public class WillowTrunkPlacer
extends TrunkPlacer {
    private static final Direction[] dirs = new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.EAST, Direction.WEST};
    public static final Codec<WillowTrunkPlacer> CODEC = RecordCodecBuilder.create(instance -> WillowTrunkPlacer.m_70305_((RecordCodecBuilder.Instance)instance).apply((Applicative)instance, WillowTrunkPlacer::new));

    public WillowTrunkPlacer(int base, int first, int second) {
        super(base, first, second);
    }

    protected TrunkPlacerType<?> m_7362_() {
        return BMWorldGen.Swamp.WILLOW_TRUNK;
    }

    public List<FoliagePlacer.FoliageAttachment> m_142625_(LevelSimulatedReader level, BiConsumer<BlockPos, BlockState> biConsumer, Random random, int trunkHeight, BlockPos pos, TreeConfiguration cfg) {
        WillowTrunkPlacer.m_161880_((LevelSimulatedReader)level, biConsumer, (Random)random, (BlockPos)pos.m_7495_(), (TreeConfiguration)cfg);
        ArrayList nodes = Lists.newArrayList();
        for (int i = 0; i < trunkHeight; ++i) {
            WillowTrunkPlacer.m_161893_((LevelSimulatedReader)level, biConsumer, (Random)random, (BlockPos)pos.m_6630_(i), (TreeConfiguration)cfg);
        }
        nodes.add(new FoliagePlacer.FoliageAttachment(pos.m_6630_(trunkHeight), 1, false));
        BlockPos start = pos.m_6630_(RandomUtil.randomRange(trunkHeight / 2, Math.min(trunkHeight, trunkHeight / 2 + 2)));
        for (Direction dir : dirs) {
            int length = 1 + random.nextInt(4);
            BlockPos.MutableBlockPos lP = new BlockPos.MutableBlockPos(start.m_142300_(dir).m_123341_(), start.m_123342_(), start.m_142300_(dir).m_123343_());
            for (int i = 0; i < length; ++i) {
                BlockState st = (BlockState)cfg.f_68185_.m_7112_(random, (BlockPos)lP).m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)dir.m_122434_());
                WillowTrunkPlacer.placeBlock(st, level, biConsumer, (BlockPos)lP, Function.identity());
                if (i != length - 1) {
                    nodes.add(new FoliagePlacer.FoliageAttachment((BlockPos)lP, -1, false));
                    lP.m_122173_(dir);
                    if (random.nextBoolean()) {
                        lP.m_122173_(random.nextBoolean() ? dir.m_122427_() : dir.m_122428_());
                    }
                    if (random.nextInt(2) != 0) continue;
                    lP.m_122173_(Direction.UP);
                    continue;
                }
                nodes.add(new FoliagePlacer.FoliageAttachment((BlockPos)lP, 0, false));
            }
        }
        return nodes;
    }

    protected static boolean placeBlock(BlockState state, LevelSimulatedReader levelSimulatedReader, BiConsumer<BlockPos, BlockState> biConsumer, BlockPos blockPos, Function<BlockState, BlockState> function) {
        if (TreeFeature.m_67272_((LevelSimulatedReader)levelSimulatedReader, (BlockPos)blockPos)) {
            biConsumer.accept(blockPos, function.apply(state));
            return true;
        }
        return false;
    }
}

