/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.biomemakeover.level.feature.mansion.room;

import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureManager;
import party.lemons.biomemakeover.level.feature.mansion.MansionFeature;
import party.lemons.biomemakeover.level.feature.mansion.MansionLayout;
import party.lemons.biomemakeover.level.feature.mansion.RoomType;
import party.lemons.biomemakeover.level.feature.mansion.room.MansionRoom;
import party.lemons.biomemakeover.level.feature.mansion.room.NonRoofedMansionRoom;
import party.lemons.biomemakeover.util.Grid;

public class RoofMansionRoom
extends NonRoofedMansionRoom {
    public RoofMansionRoom(BlockPos position) {
        super(position, RoomType.ROOF);
    }

    @Override
    public int getSortValue() {
        return -4 + this.getLayout().doorCount();
    }

    @Override
    public void addWalls(Random random, BlockPos wallPos, StructureManager manager, Grid<MansionRoom> roomGrid, StructurePiecesBuilder children) {
        if (this.isRoofConnected(Direction.NORTH, roomGrid)) {
            children.m_142679_((StructurePiece)new MansionFeature.Piece(manager, this.getRoofSplit(random).toString(), wallPos.m_142300_(Direction.NORTH).m_142082_(-2, 0, 0), Rotation.NONE, this.getPosition().m_123342_() == 0, true));
        }
        if (this.isRoofConnected(Direction.WEST, roomGrid)) {
            children.m_142679_((StructurePiece)new MansionFeature.Piece(manager, this.getRoofSplit(random).toString(), wallPos.m_142300_(Direction.WEST).m_142082_(0, 0, -2), Rotation.CLOCKWISE_90, this.getPosition().m_123342_() == 0, true));
        }
    }

    private ResourceLocation getRoofSplit(Random random) {
        return MansionFeature.ROOF_SPLIT.get(random.nextInt(MansionFeature.ROOF_SPLIT.size()));
    }

    @Override
    public BlockPos getOffsetForRotation(BlockPos offsetPos, Rotation rotation) {
        switch (this.layout.doorCount()) {
            case 1: {
                if (((Boolean)this.layout.get(Direction.SOUTH)).booleanValue()) {
                    return offsetPos.m_142082_(12, 0, 10);
                }
                if (((Boolean)this.layout.get(Direction.NORTH)).booleanValue()) {
                    return offsetPos.m_142082_(-2, 0, 0);
                }
                if (((Boolean)this.layout.get(Direction.EAST)).booleanValue()) {
                    return offsetPos.m_142082_(10, 0, -2);
                }
                if (((Boolean)this.layout.get(Direction.WEST)).booleanValue()) {
                    return offsetPos.m_142082_(0, 0, 12);
                }
            }
            case 2: {
                if (((Boolean)this.layout.get(Direction.SOUTH)).booleanValue() && ((Boolean)this.layout.get(Direction.NORTH)).booleanValue()) {
                    return offsetPos.m_142082_(-2, 0, 0);
                }
                if (((Boolean)this.layout.get(Direction.SOUTH)).booleanValue() && ((Boolean)this.layout.get(Direction.EAST)).booleanValue()) {
                    return offsetPos.m_142082_(-2, 0, -2);
                }
                if (((Boolean)this.layout.get(Direction.SOUTH)).booleanValue() && ((Boolean)this.layout.get(Direction.WEST)).booleanValue()) {
                    return offsetPos.m_142082_(12, 0, -2);
                }
                if (((Boolean)this.layout.get(Direction.EAST)).booleanValue() && ((Boolean)this.layout.get(Direction.WEST)).booleanValue()) {
                    return offsetPos.m_142082_(0, 0, 12);
                }
                if (((Boolean)this.layout.get(Direction.NORTH)).booleanValue() && ((Boolean)this.layout.get(Direction.EAST)).booleanValue()) {
                    return offsetPos.m_142082_(-2, 0, 12);
                }
                if (((Boolean)this.layout.get(Direction.NORTH)).booleanValue() && ((Boolean)this.layout.get(Direction.WEST)).booleanValue()) {
                    return offsetPos.m_142082_(12, 0, 12);
                }
            }
            case 3: {
                if (((Boolean)this.layout.get(Direction.NORTH)).booleanValue() && ((Boolean)this.layout.get(Direction.SOUTH)).booleanValue() && ((Boolean)this.layout.get(Direction.WEST)).booleanValue()) {
                    return offsetPos.m_142082_(12, 0, 10);
                }
                if (((Boolean)this.layout.get(Direction.NORTH)).booleanValue() && ((Boolean)this.layout.get(Direction.SOUTH)).booleanValue() && ((Boolean)this.layout.get(Direction.EAST)).booleanValue()) {
                    return offsetPos.m_142082_(-2, 0, 0);
                }
                if (((Boolean)this.layout.get(Direction.NORTH)).booleanValue() && ((Boolean)this.layout.get(Direction.EAST)).booleanValue() && ((Boolean)this.layout.get(Direction.WEST)).booleanValue()) {
                    return offsetPos.m_142082_(0, 0, 12);
                }
                if (((Boolean)this.layout.get(Direction.SOUTH)).booleanValue() && ((Boolean)this.layout.get(Direction.EAST)).booleanValue() && ((Boolean)this.layout.get(Direction.WEST)).booleanValue()) {
                    return offsetPos.m_142082_(10, 0, -2);
                }
            }
            case 4: {
                return offsetPos.m_142082_(0, 0, 0);
            }
            case 0: {
                return offsetPos.m_142082_(-2, 0, -2);
            }
        }
        return offsetPos;
    }

    @Override
    public ResourceLocation getTemplate(Random random) {
        List<ResourceLocation> ids = switch (this.layout.doorCount()) {
            case 0 -> MansionFeature.ROOF_0;
            case 1 -> MansionFeature.ROOF_1;
            case 2 -> {
                if (((Boolean)this.layout.get(Direction.NORTH)).booleanValue() && ((Boolean)this.layout.get(Direction.SOUTH)).booleanValue() || ((Boolean)this.layout.get(Direction.EAST)).booleanValue() && ((Boolean)this.layout.get(Direction.WEST)).booleanValue()) {
                    yield MansionFeature.ROOF_2_STRAIGHT;
                }
                yield MansionFeature.ROOF_2;
            }
            case 3 -> MansionFeature.ROOF_3;
            case 4 -> MansionFeature.ROOF_4;
            default -> MansionFeature.INNER_WALL;
        };
        return ids.get(random.nextInt(ids.size()));
    }

    @Override
    public Rotation getRotation(Random random) {
        switch (this.layout.doorCount()) {
            case 1: {
                if (((Boolean)this.layout.get(Direction.SOUTH)).booleanValue()) {
                    return Rotation.CLOCKWISE_180;
                }
                if (((Boolean)this.layout.get(Direction.NORTH)).booleanValue()) {
                    return Rotation.NONE;
                }
                if (((Boolean)this.layout.get(Direction.EAST)).booleanValue()) {
                    return Rotation.CLOCKWISE_90;
                }
                if (((Boolean)this.layout.get(Direction.WEST)).booleanValue()) {
                    return Rotation.COUNTERCLOCKWISE_90;
                }
            }
            case 2: {
                if (((Boolean)this.layout.get(Direction.SOUTH)).booleanValue() && ((Boolean)this.layout.get(Direction.NORTH)).booleanValue()) {
                    return Rotation.NONE;
                }
                if (((Boolean)this.layout.get(Direction.SOUTH)).booleanValue() && ((Boolean)this.layout.get(Direction.EAST)).booleanValue()) {
                    return Rotation.NONE;
                }
                if (((Boolean)this.layout.get(Direction.SOUTH)).booleanValue() && ((Boolean)this.layout.get(Direction.WEST)).booleanValue()) {
                    return Rotation.CLOCKWISE_90;
                }
                if (((Boolean)this.layout.get(Direction.EAST)).booleanValue() && ((Boolean)this.layout.get(Direction.WEST)).booleanValue()) {
                    return Rotation.COUNTERCLOCKWISE_90;
                }
                if (((Boolean)this.layout.get(Direction.NORTH)).booleanValue() && ((Boolean)this.layout.get(Direction.EAST)).booleanValue()) {
                    return Rotation.COUNTERCLOCKWISE_90;
                }
                if (((Boolean)this.layout.get(Direction.NORTH)).booleanValue() && ((Boolean)this.layout.get(Direction.WEST)).booleanValue()) {
                    return Rotation.CLOCKWISE_180;
                }
            }
            case 3: {
                if (((Boolean)this.layout.get(Direction.NORTH)).booleanValue() && ((Boolean)this.layout.get(Direction.SOUTH)).booleanValue() && ((Boolean)this.layout.get(Direction.WEST)).booleanValue()) {
                    return Rotation.CLOCKWISE_180;
                }
                if (((Boolean)this.layout.get(Direction.NORTH)).booleanValue() && ((Boolean)this.layout.get(Direction.SOUTH)).booleanValue() && ((Boolean)this.layout.get(Direction.EAST)).booleanValue()) {
                    return Rotation.NONE;
                }
                if (((Boolean)this.layout.get(Direction.NORTH)).booleanValue() && ((Boolean)this.layout.get(Direction.EAST)).booleanValue() && ((Boolean)this.layout.get(Direction.WEST)).booleanValue()) {
                    return Rotation.COUNTERCLOCKWISE_90;
                }
                if (((Boolean)this.layout.get(Direction.SOUTH)).booleanValue() && ((Boolean)this.layout.get(Direction.EAST)).booleanValue() && ((Boolean)this.layout.get(Direction.WEST)).booleanValue()) {
                    return Rotation.CLOCKWISE_90;
                }
            }
            case 4: {
                return Rotation.NONE;
            }
            case 0: {
                return Rotation.NONE;
            }
        }
        return null;
    }

    @Override
    public void setLayout(MansionLayout layout, Random random) {
        Grid<MansionRoom> lo = layout.getLayout();
        for (int i = 0; i < 4; ++i) {
            Direction dir = Direction.m_122407_((int)i);
            MansionRoom neighbour = lo.get(this.getPosition().m_142300_(dir));
            if (neighbour == null || neighbour.getRoomType() != RoomType.ROOF && !neighbour.getRoomType().hasWalls()) continue;
            this.getLayout().put(dir, true);
        }
    }

    public boolean isRoofConnected(Direction direction, Grid<MansionRoom> roomGrid) {
        return (Boolean)this.layout.get(direction) != false && roomGrid.get(this.getPosition().m_142300_(direction)).getRoomType() == RoomType.ROOF;
    }
}

