/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.biomemakeover.level;

import dev.architectury.event.events.common.TickEvent;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.BlockSource;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.core.dispenser.OptionalDispenseItemBehavior;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import party.lemons.biomemakeover.block.SmallLilyPadBlock;
import party.lemons.biomemakeover.entity.StoneGolemEntity;
import party.lemons.biomemakeover.init.BMBlocks;
import party.lemons.biomemakeover.level.TumbleweedSpawner;
import party.lemons.biomemakeover.level.WindSystem;

public final class BMWorldEvents {
    public static void init() {
        TickEvent.SERVER_POST.register(s -> WindSystem.update());
        TickEvent.SERVER_LEVEL_POST.register(s -> TumbleweedSpawner.update(s.m_6018_()));
        DispenserBlock.m_52672_((ItemLike)Items.f_42717_, (DispenseItemBehavior)new OptionalDispenseItemBehavior(){

            protected ItemStack m_7498_(BlockSource block, ItemStack itemStack) {
                BlockPos blockPos = block.m_7961_().m_142300_((Direction)block.m_6414_().m_61143_((Property)DispenserBlock.f_52659_));
                List list = block.m_7727_().m_6443_(StoneGolemEntity.class, new AABB(blockPos), golem -> !golem.m_21055_(Items.f_42717_) && golem.isPlayerCreated() && golem.m_6084_());
                if (!list.isEmpty()) {
                    ((StoneGolemEntity)list.get(0)).m_8061_(EquipmentSlot.MAINHAND, itemStack.m_41777_());
                    itemStack.m_41774_(1);
                    this.m_123573_(true);
                    return itemStack;
                }
                return super.m_7498_(block, itemStack);
            }
        });
    }

    public static void handleSwampBoneMeal(Level level, BlockPos pos, Random random) {
        block0: for (int i = 0; i < 128; ++i) {
            BlockPos placePos = pos;
            BlockState placeState = Blocks.f_50037_.m_49966_();
            boolean requireWater = true;
            for (int j = 0; j < i / 16; ++j) {
                if (level.m_8055_(placePos = placePos.m_142082_(random.nextInt(3) - 1, (random.nextInt(3) - 1) * random.nextInt(3) / 2, random.nextInt(3) - 1)).m_60838_((BlockGetter)level, placePos)) continue block0;
            }
            if (level.m_8055_(placePos.m_7494_()).m_60795_() && random.nextInt(4) == 0) {
                if (random.nextInt(5) > 0) {
                    placeState = random.nextInt(3) == 0 ? BMBlocks.CATTAIL.get().m_49966_() : BMBlocks.REED.get().m_49966_();
                } else {
                    placePos = placePos.m_7494_();
                    requireWater = false;
                    placeState = random.nextBoolean() ? (BlockState)BMBlocks.SMALL_LILY_PAD.get().m_49966_().m_61124_((Property)SmallLilyPadBlock.PADS, (Comparable)Integer.valueOf(random.nextInt(4))) : (random.nextInt(4) == 0 ? BMBlocks.WATER_LILY.get().m_49966_() : Blocks.f_50196_.m_49966_());
                }
            }
            if (!placeState.m_60710_((LevelReader)level, placePos)) continue;
            BlockState currentState = level.m_8055_(placePos);
            if (!requireWater && currentState.m_60795_() || requireWater && currentState.m_60713_(Blocks.f_49990_) && level.m_6425_(placePos).m_76170_()) {
                BMWorldEvents.placeBlock(placePos, placeState, level);
                continue;
            }
            if (!currentState.m_60713_(Blocks.f_50037_) || random.nextInt(10) != 0) continue;
            ((BonemealableBlock)Blocks.f_50037_).m_7719_((ServerLevel)level, random, placePos, currentState);
        }
    }

    private static void placeBlock(BlockPos pos, BlockState state, Level level) {
        if (state.m_60734_() instanceof DoublePlantBlock) {
            if (!level.m_46859_(pos.m_7494_())) {
                return;
            }
            DoublePlantBlock.m_153173_((LevelAccessor)level, (BlockState)state, (BlockPos)pos, (int)2);
        } else {
            level.m_7731_(pos, state, 2);
        }
    }

    private BMWorldEvents() {
    }
}

