/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.biomemakeover.item;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Multimap;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;

public class BMArmorItem
extends ArmorItem {
    final LinkedListMultimap<ResourceLocation, AttributeHolder> suppliedAttributes;
    private Multimap<Attribute, AttributeModifier> attributes;
    private final int protection;
    private final float toughness;

    public BMArmorItem(ArmorMaterial material, LinkedListMultimap<ResourceLocation, AttributeHolder> attributes, int protection, float toughness, EquipmentSlot slot, Item.Properties properties) {
        super(material, slot, properties);
        this.suppliedAttributes = attributes;
        this.protection = protection;
        this.toughness = toughness;
    }

    public Multimap<Attribute, AttributeModifier> m_7167_(EquipmentSlot equipmentSlot) {
        if (this.attributes == null) {
            this.initAttributes();
        }
        return equipmentSlot == this.f_40377_ ? this.attributes : ImmutableMultimap.of();
    }

    private void initAttributes() {
        this.attributes = LinkedListMultimap.create();
        this.suppliedAttributes.forEach((l, holder) -> this.attributes.put((Object)holder.supplier.get(), (Object)holder.modifier));
    }

    public float m_40405_() {
        return this.toughness;
    }

    public int m_40404_() {
        return this.protection;
    }

    private record AttributeHolder(Supplier<Attribute> supplier, AttributeModifier modifier) {
    }

    public static class Builder {
        private static final UUID DUMMY_UUID = UUID.randomUUID();
        private static final UUID[] MODIFIERS = new UUID[]{UUID.fromString("845DB27C-C624-495F-8C9F-6020A9A58B6B"), UUID.fromString("D8499B04-0E66-4726-AB29-64469D734E0D"), UUID.fromString("9F3D476D-C118-4544-8365-64846904B48E"), UUID.fromString("2AD3F246-FEE1-4E67-B886-69FD380BB150")};
        private final LinkedListMultimap<ResourceLocation, AttributeHolder> suppliedAttributes = LinkedListMultimap.create();
        private final ArmorMaterial material;
        private int protection;
        private boolean overrideProtection = false;
        private float toughness;
        private float knockbackResistance;

        public static Builder create(ArmorMaterial material) {
            return new Builder(material);
        }

        public Builder protection(int amount) {
            this.protection = amount;
            this.overrideProtection = true;
            return this;
        }

        public Builder toughness(float amount) {
            this.toughness = amount;
            return this;
        }

        public Builder knockbackResistance(float amount) {
            this.knockbackResistance = amount;
            return this;
        }

        public Builder attribute(String name, RegistrySupplier<Attribute> attribute, double value, AttributeModifier.Operation operation) {
            this.suppliedAttributes.put((Object)attribute.getId(), (Object)new AttributeHolder((Supplier<Attribute>)attribute, new AttributeModifier(DUMMY_UUID, name, value, operation)));
            return this;
        }

        public Builder attribute(String name, Attribute attribute, double value, AttributeModifier.Operation operation) {
            this.suppliedAttributes.put((Object)Registry.f_122866_.m_7981_((Object)attribute), (Object)new AttributeHolder(() -> attribute, new AttributeModifier(DUMMY_UUID, name, value, operation)));
            return this;
        }

        public Supplier<Item> build(EquipmentSlot slot, Item.Properties properties) {
            if (!this.overrideProtection) {
                this.protection = this.material.m_7365_(slot);
            }
            this.suppliedAttributes.removeAll((Object)Registry.f_122866_.m_7981_((Object)Attributes.f_22284_));
            this.suppliedAttributes.removeAll((Object)Registry.f_122866_.m_7981_((Object)Attributes.f_22285_));
            this.suppliedAttributes.removeAll((Object)Registry.f_122866_.m_7981_((Object)Attributes.f_22278_));
            this.suppliedAttributes.put((Object)Registry.f_122866_.m_7981_((Object)Attributes.f_22284_), (Object)new AttributeHolder(() -> Attributes.f_22284_, new AttributeModifier(DUMMY_UUID, "Armor modifier", (double)this.protection, AttributeModifier.Operation.ADDITION)));
            this.suppliedAttributes.put((Object)Registry.f_122866_.m_7981_((Object)Attributes.f_22285_), (Object)new AttributeHolder(() -> Attributes.f_22285_, new AttributeModifier(DUMMY_UUID, "Armor toughness", (double)this.toughness, AttributeModifier.Operation.ADDITION)));
            if (this.knockbackResistance != 0.0f) {
                this.suppliedAttributes.put((Object)Registry.f_122866_.m_7981_((Object)Attributes.f_22278_), (Object)new AttributeHolder(() -> Attributes.f_22278_, new AttributeModifier(DUMMY_UUID, "Armor knockback resistance", (double)this.knockbackResistance, AttributeModifier.Operation.ADDITION)));
            }
            LinkedListMultimap<ResourceLocation, AttributeHolder> builtAttributes = this.buildAttributes(slot);
            return () -> new BMArmorItem(this.material, builtAttributes, this.protection, this.toughness, slot, properties);
        }

        private LinkedListMultimap<ResourceLocation, AttributeHolder> buildAttributes(EquipmentSlot slot) {
            LinkedListMultimap atts = LinkedListMultimap.create();
            this.suppliedAttributes.forEach((location, attributeHolder) -> {
                AttributeModifier modifier = attributeHolder.modifier();
                atts.put(location, (Object)new AttributeHolder(attributeHolder.supplier(), new AttributeModifier(MODIFIERS[slot.m_20749_()], modifier.m_22214_(), modifier.m_22218_(), modifier.m_22217_())));
            });
            return atts;
        }

        private Builder(ArmorMaterial material) {
            this.material = material;
            this.toughness = material.m_6651_();
            this.knockbackResistance = material.m_6649_();
        }
    }
}

