/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.biomemakeover.init;

import dev.architectury.event.events.common.LifecycleEvent;
import dev.architectury.registry.client.level.entity.EntityModelLayerRegistry;
import dev.architectury.registry.client.level.entity.EntityRendererRegistry;
import dev.architectury.registry.level.biome.BiomeModifications;
import dev.architectury.registry.level.entity.EntityAttributeRegistry;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrySupplier;
import dev.architectury.utils.Env;
import dev.architectury.utils.EnvExecutor;
import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.SharedConstants;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.IllagerModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.renderer.entity.ThrownItemRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.RangedAttribute;
import net.minecraft.world.entity.ambient.Bat;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Pillager;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import net.minecraft.world.level.block.state.pattern.BlockPatternBuilder;
import net.minecraft.world.level.block.state.predicate.BlockMaterialPredicate;
import net.minecraft.world.level.block.state.predicate.BlockStatePredicate;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.material.Material;
import party.lemons.biomemakeover.BiomeMakeover;
import party.lemons.biomemakeover.block.blockentity.render.TapestryRenderer;
import party.lemons.biomemakeover.entity.BMBoatEntity;
import party.lemons.biomemakeover.entity.BlightBatEntity;
import party.lemons.biomemakeover.entity.CowboyEntity;
import party.lemons.biomemakeover.entity.DecayedEntity;
import party.lemons.biomemakeover.entity.DragonflyEntity;
import party.lemons.biomemakeover.entity.GhostEntity;
import party.lemons.biomemakeover.entity.GlowfishEntity;
import party.lemons.biomemakeover.entity.LightningBottleEntity;
import party.lemons.biomemakeover.entity.LightningBugEntity;
import party.lemons.biomemakeover.entity.MothEntity;
import party.lemons.biomemakeover.entity.MushroomVillagerEntity;
import party.lemons.biomemakeover.entity.OwlEntity;
import party.lemons.biomemakeover.entity.RootlingEntity;
import party.lemons.biomemakeover.entity.ScuttlerEntity;
import party.lemons.biomemakeover.entity.StoneGolemEntity;
import party.lemons.biomemakeover.entity.TadpoleEntity;
import party.lemons.biomemakeover.entity.ToadEntity;
import party.lemons.biomemakeover.entity.TumbleweedEntity;
import party.lemons.biomemakeover.entity.adjudicator.AdjudicatorEntity;
import party.lemons.biomemakeover.entity.adjudicator.AdjudicatorMimicEntity;
import party.lemons.biomemakeover.entity.render.AdjudicatorMimicRender;
import party.lemons.biomemakeover.entity.render.AdjudicatorModel;
import party.lemons.biomemakeover.entity.render.AdjudicatorRender;
import party.lemons.biomemakeover.entity.render.BMBoatRender;
import party.lemons.biomemakeover.entity.render.BlightBatRender;
import party.lemons.biomemakeover.entity.render.CowboyRender;
import party.lemons.biomemakeover.entity.render.DecayedModel;
import party.lemons.biomemakeover.entity.render.DecayedRender;
import party.lemons.biomemakeover.entity.render.DragonflyModel;
import party.lemons.biomemakeover.entity.render.DragonflyRender;
import party.lemons.biomemakeover.entity.render.GhostModel;
import party.lemons.biomemakeover.entity.render.GhostRender;
import party.lemons.biomemakeover.entity.render.GlowfishRender;
import party.lemons.biomemakeover.entity.render.LightningBugModel;
import party.lemons.biomemakeover.entity.render.LightningBugRender;
import party.lemons.biomemakeover.entity.render.MothModel;
import party.lemons.biomemakeover.entity.render.MothRender;
import party.lemons.biomemakeover.entity.render.MushroomTraderRender;
import party.lemons.biomemakeover.entity.render.OwlModel;
import party.lemons.biomemakeover.entity.render.OwlRender;
import party.lemons.biomemakeover.entity.render.RootlingModel;
import party.lemons.biomemakeover.entity.render.RootlingRender;
import party.lemons.biomemakeover.entity.render.ScuttlerModel;
import party.lemons.biomemakeover.entity.render.ScuttlerRender;
import party.lemons.biomemakeover.entity.render.StoneGolemModel;
import party.lemons.biomemakeover.entity.render.StoneGolemRender;
import party.lemons.biomemakeover.entity.render.TadpoleModel;
import party.lemons.biomemakeover.entity.render.TadpoleRender;
import party.lemons.biomemakeover.entity.render.ToadModel;
import party.lemons.biomemakeover.entity.render.ToadRender;
import party.lemons.biomemakeover.entity.render.TumbleweedRender;
import party.lemons.biomemakeover.entity.render.feature.CowboyHatModel;
import party.lemons.biomemakeover.entity.render.feature.WitchHatModel;
import party.lemons.biomemakeover.init.BMBlocks;
import party.lemons.biomemakeover.level.golem.GolemHandler;
import party.lemons.biomemakeover.mixin.SpawnPlacementsInvoker;
import party.lemons.biomemakeover.util.access.CarvedPumpkinAccess;
import party.lemons.biomemakeover.util.registry.boat.BoatTypes;

public class BMEntities {
    static boolean dfCache = SharedConstants.f_136182_;
    public static final DeferredRegister<EntityType<?>> ENTITIES;
    public static final DeferredRegister<Attribute> ATTRIBUTES;
    public static final RegistrySupplier<EntityType<TumbleweedEntity>> TUMBLEWEED;
    public static final RegistrySupplier<EntityType<BMBoatEntity>> BM_BOAT;
    public static final RegistrySupplier<EntityType<LightningBottleEntity>> LIGHTNING_BOTTLE;
    public static final RegistrySupplier<EntityType<GlowfishEntity>> GLOWFISH;
    public static final RegistrySupplier<EntityType<BlightBatEntity>> BLIGHTBAT;
    public static final RegistrySupplier<EntityType<MushroomVillagerEntity>> MUSHROOM_TRADER;
    public static final RegistrySupplier<EntityType<ScuttlerEntity>> SCUTTLER;
    public static final RegistrySupplier<EntityType<GhostEntity>> GHOST;
    public static final RegistrySupplier<EntityType<CowboyEntity>> COWBOY;
    public static final RegistrySupplier<EntityType<DecayedEntity>> DECAYED;
    public static final RegistrySupplier<EntityType<DragonflyEntity>> DRAGONFLY;
    public static final RegistrySupplier<EntityType<ToadEntity>> TOAD;
    public static final RegistrySupplier<EntityType<TadpoleEntity>> TADPOLE;
    public static final RegistrySupplier<EntityType<LightningBugEntity>> LIGHTNING_BUG;
    public static final RegistrySupplier<EntityType<LightningBugEntity>> LIGHTNING_BUG_ALTERNATE;
    public static final RegistrySupplier<EntityType<OwlEntity>> OWL;
    public static final RegistrySupplier<EntityType<MothEntity>> MOTH;
    public static final RegistrySupplier<EntityType<RootlingEntity>> ROOTLING;
    public static final RegistrySupplier<EntityType<AdjudicatorEntity>> ADJUDICATOR;
    public static final RegistrySupplier<EntityType<AdjudicatorMimicEntity>> ADJUDICATOR_MIMIC;
    public static final RegistrySupplier<EntityType<StoneGolemEntity>> STONE_GOLEM;
    public static final RegistrySupplier<Attribute> ATT_PROJECTILE_RESISTANCE;
    public static final TagKey<EntityType<?>> LIGHTNING_BUG_TAG;
    public static final TagKey<EntityType<?>> OWL_TARGETS;

    public static void init() {
        boolean dfCache = SharedConstants.f_136182_;
        SharedConstants.f_136182_ = false;
        ENTITIES.register();
        SharedConstants.f_136182_ = dfCache;
        ATTRIBUTES.register();
        LifecycleEvent.SETUP.register(() -> GolemHandler.addPattern(BlockPatternBuilder.m_61243_().m_61247_(new String[]{"~^~", "###", "~#~"}).m_61244_('^', BlockInWorld.m_61169_(((CarvedPumpkinAccess)Blocks.f_50143_).bm_isGolemHeadBlock())).m_61244_('#', BlockInWorld.m_61169_((Predicate)BlockStatePredicate.m_61287_((Block)BMBlocks.CLADDED_STONE.get()))).m_61244_('~', BlockInWorld.m_61169_((Predicate)BlockMaterialPredicate.m_61262_((Material)Material.f_76296_))).m_61249_(), BlockPatternBuilder.m_61243_().m_61247_(new String[]{"~ ~", "###", "~#~"}).m_61244_('#', BlockInWorld.m_61169_((Predicate)BlockStatePredicate.m_61287_((Block)BMBlocks.CLADDED_STONE.get()))).m_61244_('~', BlockInWorld.m_61169_((Predicate)BlockMaterialPredicate.m_61262_((Material)Material.f_76296_))).m_61249_(), new GolemHandler.SummonGolemResult((EntityType)STONE_GOLEM.get())));
        BMEntities.initAttributes();
    }

    public static void initSpawnsAndAttributes() {
        BMEntities.initSpawns();
    }

    public static void initAttributes() {
        EntityAttributeRegistry.register(() -> GLOWFISH.get(), GlowfishEntity::createAttributes);
        EntityAttributeRegistry.register(() -> BLIGHTBAT.get(), Bat::m_27455_);
        EntityAttributeRegistry.register(() -> MUSHROOM_TRADER.get(), Mob::m_21552_);
        EntityAttributeRegistry.register(() -> SCUTTLER.get(), ScuttlerEntity::createAttributes);
        EntityAttributeRegistry.register(() -> GHOST.get(), Monster::m_33035_);
        EntityAttributeRegistry.register(() -> COWBOY.get(), Pillager::m_33307_);
        EntityAttributeRegistry.register(() -> DECAYED.get(), DecayedEntity::createAttributes);
        EntityAttributeRegistry.register(() -> DRAGONFLY.get(), DragonflyEntity::createAttributes);
        EntityAttributeRegistry.register(() -> TOAD.get(), ToadEntity::createAttributes);
        EntityAttributeRegistry.register(() -> TADPOLE.get(), TadpoleEntity::createAttributes);
        EntityAttributeRegistry.register(() -> LIGHTNING_BUG.get(), LightningBugEntity::createAttributes);
        EntityAttributeRegistry.register(() -> LIGHTNING_BUG_ALTERNATE.get(), LightningBugEntity::createAttributes);
        EntityAttributeRegistry.register(() -> OWL.get(), OwlEntity::createAttributes);
        EntityAttributeRegistry.register(() -> MOTH.get(), MothEntity::createAttributes);
        EntityAttributeRegistry.register(() -> ROOTLING.get(), RootlingEntity::createAttributes);
        EntityAttributeRegistry.register(() -> ADJUDICATOR.get(), AdjudicatorEntity::createAttributes);
        EntityAttributeRegistry.register(() -> ADJUDICATOR_MIMIC.get(), AdjudicatorMimicEntity::createAttributes);
        EntityAttributeRegistry.register(() -> STONE_GOLEM.get(), StoneGolemEntity::createAttributes);
    }

    private static void initSpawns() {
        Predicate<BiomeModifications.BiomeContext> MUSHROOM_BIOMES = ctx -> ctx.getProperties().getCategory() == Biome.BiomeCategory.MUSHROOM;
        Predicate<BiomeModifications.BiomeContext> MESA_BIOMES = ctx -> ctx.getProperties().getCategory() == Biome.BiomeCategory.MESA;
        Predicate<BiomeModifications.BiomeContext> SWAMP_BIOMES = ctx -> ctx.getProperties().getCategory() == Biome.BiomeCategory.SWAMP;
        Predicate<BiomeModifications.BiomeContext> DARK_FOREST = ctx -> ctx.getKey().equals((Object)new ResourceLocation("dark_forest"));
        BMEntities.registerSpawn(MUSHROOM_BIOMES, (EntityType)GLOWFISH.get(), MobCategory.WATER_AMBIENT, 7, 2, 7);
        SpawnPlacementsInvoker.callRegister((EntityType)GLOWFISH.get(), SpawnPlacements.Type.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, WaterAnimal::m_186237_);
        BMEntities.registerSpawn(MUSHROOM_BIOMES, (EntityType)BLIGHTBAT.get(), MobCategory.AMBIENT, 5, 1, 1);
        SpawnPlacementsInvoker.callRegister((EntityType)BLIGHTBAT.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, BlightBatEntity::checkSpawnRules);
        BMEntities.registerSpawn(MUSHROOM_BIOMES, (EntityType)MUSHROOM_TRADER.get(), MobCategory.AMBIENT, 1, 1, 1);
        BMEntities.registerSpawn(MESA_BIOMES, (EntityType)SCUTTLER.get(), MobCategory.CREATURE, 4, 1, 2);
        SpawnPlacementsInvoker.callRegister((EntityType)SCUTTLER.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, ScuttlerEntity::checkSpawnRules);
        BMEntities.registerSpawn(SWAMP_BIOMES, (EntityType)DECAYED.get(), MobCategory.MONSTER, 60, 1, 1);
        SpawnPlacementsInvoker.callRegister((EntityType)DECAYED.get(), SpawnPlacements.Type.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, DecayedEntity::checkSpawnRules);
        BMEntities.registerSpawn(SWAMP_BIOMES, (EntityType)DRAGONFLY.get(), MobCategory.AMBIENT, 20, 3, 8);
        SpawnPlacementsInvoker.callRegister((EntityType)DRAGONFLY.get(), SpawnPlacements.Type.NO_RESTRICTIONS, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, DragonflyEntity::checkSpawnRules);
        BMEntities.registerSpawn(SWAMP_BIOMES, (EntityType)TOAD.get(), MobCategory.CREATURE, 20, 2, 4);
        SpawnPlacementsInvoker.callRegister((EntityType)TOAD.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Animal::m_27577_);
        BMEntities.registerSpawn(SWAMP_BIOMES, (EntityType)LIGHTNING_BUG.get(), MobCategory.AMBIENT, 20, 1, 1);
        SpawnPlacementsInvoker.callRegister((EntityType)LIGHTNING_BUG.get(), SpawnPlacements.Type.NO_RESTRICTIONS, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, LightningBugEntity::checkSpawnRules);
        BMEntities.registerSpawn(DARK_FOREST, (EntityType)OWL.get(), MobCategory.CREATURE, 20, 1, 4);
        SpawnPlacementsInvoker.callRegister((EntityType)OWL.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING, OwlEntity::checkSpawnRules);
        BMEntities.registerSpawn(DARK_FOREST, (EntityType)ROOTLING.get(), MobCategory.CREATURE, 40, 2, 6);
        SpawnPlacementsInvoker.callRegister((EntityType)ROOTLING.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, BMEntities::checkDFSpawnRules);
        BMEntities.registerSpawn(DARK_FOREST, (EntityType)MOTH.get(), MobCategory.MONSTER, 90, 2, 3);
        SpawnPlacementsInvoker.callRegister((EntityType)MOTH.get(), SpawnPlacements.Type.NO_RESTRICTIONS, Heightmap.Types.MOTION_BLOCKING, MothEntity::checkSpawnRules);
        BMEntities.registerSpawn(DARK_FOREST, EntityType.f_20452_, MobCategory.CREATURE, 4, 2, 2);
        BMEntities.registerSpawn(DARK_FOREST, EntityType.f_20517_, MobCategory.CREATURE, 4, 2, 3);
    }

    private static <T extends Mob> boolean checkDFSpawnRules(EntityType<T> tEntityType, ServerLevelAccessor level, MobSpawnType mobSpawnType, BlockPos pos, Random random) {
        return level.m_8055_(pos.m_7495_()).m_60713_(Blocks.f_50440_) && level.m_45524_(pos, 0) > 2;
    }

    public static void registerModels() {
        EnvExecutor.runInEnv((Env)Env.CLIENT, () -> () -> {
            EntityRendererRegistry.register(() -> TUMBLEWEED.get(), TumbleweedRender::new);
            EntityRendererRegistry.register(() -> BM_BOAT.get(), BMBoatRender::new);
            EntityRendererRegistry.register(() -> LIGHTNING_BOTTLE.get(), ThrownItemRenderer::new);
            EntityRendererRegistry.register(() -> GLOWFISH.get(), GlowfishRender::new);
            EntityRendererRegistry.register(() -> BLIGHTBAT.get(), BlightBatRender::new);
            EntityRendererRegistry.register(() -> MUSHROOM_TRADER.get(), MushroomTraderRender::new);
            EntityRendererRegistry.register(() -> SCUTTLER.get(), ScuttlerRender::new);
            EntityRendererRegistry.register(() -> GHOST.get(), GhostRender::new);
            EntityRendererRegistry.register(() -> COWBOY.get(), CowboyRender::new);
            EntityRendererRegistry.register(() -> DECAYED.get(), DecayedRender::new);
            EntityRendererRegistry.register(() -> DRAGONFLY.get(), DragonflyRender::new);
            EntityRendererRegistry.register(() -> TOAD.get(), ToadRender::new);
            EntityRendererRegistry.register(() -> TADPOLE.get(), TadpoleRender::new);
            EntityRendererRegistry.register(() -> LIGHTNING_BUG.get(), LightningBugRender::new);
            EntityRendererRegistry.register(() -> LIGHTNING_BUG_ALTERNATE.get(), LightningBugRender::new);
            EntityRendererRegistry.register(() -> OWL.get(), OwlRender::new);
            EntityRendererRegistry.register(() -> MOTH.get(), MothRender::new);
            EntityRendererRegistry.register(() -> ROOTLING.get(), RootlingRender::new);
            EntityRendererRegistry.register(() -> ADJUDICATOR.get(), AdjudicatorRender::new);
            EntityRendererRegistry.register(() -> ADJUDICATOR_MIMIC.get(), AdjudicatorMimicRender::new);
            EntityRendererRegistry.register(() -> STONE_GOLEM.get(), StoneGolemRender::new);
        });
    }

    public static void registerModelLayers() {
        BoatTypes.registerModelLayers();
        LayerDefinition HUMANOID_OVERLAY = LayerDefinition.m_171565_((MeshDefinition)HumanoidModel.m_170681_((CubeDeformation)new CubeDeformation(0.5f), (float)0.0f), (int)64, (int)64);
        LayerDefinition HUMANOID_OVERLAY2 = LayerDefinition.m_171565_((MeshDefinition)HumanoidModel.m_170681_((CubeDeformation)new CubeDeformation(0.5f), (float)0.0f), (int)64, (int)32);
        EntityModelLayerRegistry.register((ModelLayerLocation)TapestryRenderer.LAYER_LOCATION, TapestryRenderer::createBodyLayer);
        EntityModelLayerRegistry.register((ModelLayerLocation)CowboyHatModel.LAYER_LOCATION, CowboyHatModel::createBodyLayer);
        EntityModelLayerRegistry.register((ModelLayerLocation)WitchHatModel.LAYER_LOCATION, WitchHatModel::createBodyLayer);
        EntityModelLayerRegistry.register((ModelLayerLocation)BlightBatRender.BlightBatModel.LAYER_LOCATION, BlightBatRender.BlightBatModel::createBodyLayer);
        EntityModelLayerRegistry.register((ModelLayerLocation)ScuttlerModel.LAYER_LOCATION, ScuttlerModel::createBodyLayer);
        EntityModelLayerRegistry.register((ModelLayerLocation)GhostModel.LAYER_LOCATION, GhostModel::createBodyLayer);
        EntityModelLayerRegistry.register((ModelLayerLocation)CowboyRender.LAYER_LOCATION, IllagerModel::m_170689_);
        EntityModelLayerRegistry.register((ModelLayerLocation)DecayedModel.LAYER_LOCATION, () -> DecayedModel.m_170535_((CubeDeformation)CubeDeformation.f_171458_));
        EntityModelLayerRegistry.register((ModelLayerLocation)DecayedModel.LAYER_LOCATION_2, () -> HUMANOID_OVERLAY);
        EntityModelLayerRegistry.register((ModelLayerLocation)DecayedModel.LAYER_LOCATION_3, () -> HUMANOID_OVERLAY2);
        EntityModelLayerRegistry.register((ModelLayerLocation)DragonflyModel.LAYER_LOCATION, DragonflyModel::createBodyLayer);
        EntityModelLayerRegistry.register((ModelLayerLocation)ToadModel.LAYER_LOCATION, ToadModel::createBodyLayer);
        EntityModelLayerRegistry.register((ModelLayerLocation)TadpoleModel.LAYER_LOCATION, TadpoleModel::createBodyLayer);
        EntityModelLayerRegistry.register((ModelLayerLocation)LightningBugModel.LAYER_LOCATION, LightningBugModel::createBodyLayer);
        EntityModelLayerRegistry.register((ModelLayerLocation)LightningBugModel.LAYER_LOCATION_INNER, LightningBugModel.LightningBugInner::createBodyLayer);
        EntityModelLayerRegistry.register((ModelLayerLocation)LightningBugModel.LAYER_LOCATION_OUTER, LightningBugModel.LightningBugOuter::createBodyLayer);
        EntityModelLayerRegistry.register((ModelLayerLocation)OwlModel.LAYER_LOCATION, OwlModel::createBodyLayer);
        EntityModelLayerRegistry.register((ModelLayerLocation)MothModel.LAYER_LOCATION, MothModel::createBodyLayer);
        EntityModelLayerRegistry.register((ModelLayerLocation)RootlingModel.LAYER_LOCATION, RootlingModel::createBodyLayer);
        EntityModelLayerRegistry.register((ModelLayerLocation)AdjudicatorModel.LAYER_LOCATION, AdjudicatorModel::createBodyLayer);
        EntityModelLayerRegistry.register((ModelLayerLocation)StoneGolemModel.LAYER_LOCATION, StoneGolemModel::createBodyLayer);
    }

    private static void registerSpawn(Predicate<BiomeModifications.BiomeContext> biomes, EntityType<?> type, MobCategory category, int weight, int min, int max) {
        BiomeModifications.addProperties(biomes, (ctx, p) -> p.getSpawnProperties().addSpawn(category, new MobSpawnSettings.SpawnerData(type, weight, min, max)));
    }

    static {
        SharedConstants.f_136182_ = false;
        ENTITIES = DeferredRegister.create((String)"biomemakeover", (ResourceKey)Registry.f_122903_);
        ATTRIBUTES = DeferredRegister.create((String)"biomemakeover", (ResourceKey)Registry.f_122916_);
        TUMBLEWEED = ENTITIES.register(BiomeMakeover.ID("tumbleweed"), () -> EntityType.Builder.m_20704_(TumbleweedEntity::new, (MobCategory)MobCategory.MISC).m_20699_(0.7f, 0.7f).m_20702_(12).m_20712_("tumbleweed"));
        BM_BOAT = ENTITIES.register(BiomeMakeover.ID("bm_boat"), () -> EntityType.Builder.m_20704_(BMBoatEntity::new, (MobCategory)MobCategory.MISC).m_20699_(1.375f, 0.5625f).m_20702_(128).m_20717_(3).m_20712_("bm_boat"));
        LIGHTNING_BOTTLE = ENTITIES.register(BiomeMakeover.ID("lightning_bottle"), () -> EntityType.Builder.m_20704_(LightningBottleEntity::new, (MobCategory)MobCategory.MISC).m_20702_(10).m_20717_(4).m_20699_(0.25f, 0.25f).m_20712_("lightning_bottle"));
        GLOWFISH = ENTITIES.register(BiomeMakeover.ID("glowfish"), () -> EntityType.Builder.m_20704_(GlowfishEntity::new, (MobCategory)MobCategory.WATER_AMBIENT).m_20699_(0.7f, 0.4f).m_20702_(4).m_20712_("glowfish"));
        BLIGHTBAT = ENTITIES.register(BiomeMakeover.ID("blightbat"), () -> EntityType.Builder.m_20704_(BlightBatEntity::new, (MobCategory)MobCategory.AMBIENT).m_20699_(0.56f, 0.9f).m_20702_(5).m_20712_("blightbat"));
        MUSHROOM_TRADER = ENTITIES.register(BiomeMakeover.ID("mushroom_trader"), () -> EntityType.Builder.m_20704_(MushroomVillagerEntity::new, (MobCategory)MobCategory.AMBIENT).m_20699_(0.6f, 1.95f).m_20702_(12).m_20712_("mushroom_trader"));
        SCUTTLER = ENTITIES.register(BiomeMakeover.ID("scuttler"), () -> EntityType.Builder.m_20704_(ScuttlerEntity::new, (MobCategory)MobCategory.CREATURE).m_20699_(0.8f, 0.6f).m_20702_(12).m_20712_("scuttler"));
        GHOST = ENTITIES.register(BiomeMakeover.ID("ghost"), () -> EntityType.Builder.m_20704_(GhostEntity::new, (MobCategory)MobCategory.MONSTER).m_20699_(0.6f, 1.95f).m_20720_().m_20702_(12).m_20712_("ghost"));
        COWBOY = ENTITIES.register(BiomeMakeover.ID("cowboy"), () -> EntityType.Builder.m_20704_(CowboyEntity::new, (MobCategory)MobCategory.MONSTER).m_20699_(0.6f, 1.95f).m_20720_().m_20702_(12).m_20712_("cowboy"));
        DECAYED = ENTITIES.register(BiomeMakeover.ID("decayed"), () -> EntityType.Builder.m_20704_(DecayedEntity::new, (MobCategory)MobCategory.MONSTER).m_20699_(0.6f, 1.95f).m_20702_(8).m_20712_("decayed"));
        DRAGONFLY = ENTITIES.register(BiomeMakeover.ID("dragonfly"), () -> EntityType.Builder.m_20704_(DragonflyEntity::new, (MobCategory)MobCategory.AMBIENT).m_20699_(0.8f, 0.6f).m_20702_(12).m_20712_("dragonfly"));
        TOAD = ENTITIES.register(BiomeMakeover.ID("toad"), () -> EntityType.Builder.m_20704_(ToadEntity::new, (MobCategory)MobCategory.CREATURE).m_20699_(0.8f, 0.6f).m_20702_(12).m_20712_("toad"));
        TADPOLE = ENTITIES.register(BiomeMakeover.ID("tadpole"), () -> EntityType.Builder.m_20704_(TadpoleEntity::new, (MobCategory)MobCategory.WATER_CREATURE).m_20699_(0.5f, 0.3f).m_20702_(12).m_20712_("tadpole"));
        LIGHTNING_BUG = ENTITIES.register(BiomeMakeover.ID("lightning_bug"), () -> EntityType.Builder.m_20704_(LightningBugEntity::new, (MobCategory)MobCategory.AMBIENT).m_20699_(0.4f, 0.4f).m_20702_(12).m_20712_("lightning_bug"));
        LIGHTNING_BUG_ALTERNATE = ENTITIES.register(BiomeMakeover.ID("lightning_bug_alternate"), () -> EntityType.Builder.m_20704_((entityType, level) -> new LightningBugEntity(level, true), (MobCategory)MobCategory.AMBIENT).m_20699_(0.4f, 0.4f).m_20702_(12).m_20712_("lightning_bug_alternate"));
        OWL = ENTITIES.register(BiomeMakeover.ID("owl"), () -> EntityType.Builder.m_20704_(OwlEntity::new, (MobCategory)MobCategory.CREATURE).m_20699_(0.7f, 0.8f).m_20702_(12).m_20712_("owl"));
        MOTH = ENTITIES.register(BiomeMakeover.ID("moth"), () -> EntityType.Builder.m_20704_(MothEntity::new, (MobCategory)MobCategory.MONSTER).m_20699_(0.8f, 1.2f).m_20702_(12).m_20712_("moth"));
        ROOTLING = ENTITIES.register(BiomeMakeover.ID("rootling"), () -> EntityType.Builder.m_20704_(RootlingEntity::new, (MobCategory)MobCategory.CREATURE).m_20699_(0.6f, 1.1f).m_20702_(12).m_20712_("rootling"));
        ADJUDICATOR = ENTITIES.register(BiomeMakeover.ID("adjudicator"), () -> EntityType.Builder.m_20704_(AdjudicatorEntity::new, (MobCategory)MobCategory.MONSTER).m_20719_().m_20699_(0.6f, 1.95f).m_20702_(12).m_20698_().m_20712_("adjudicator"));
        ADJUDICATOR_MIMIC = ENTITIES.register(BiomeMakeover.ID("adjudicator_mimic"), () -> EntityType.Builder.m_20704_(AdjudicatorMimicEntity::new, (MobCategory)MobCategory.MONSTER).m_20719_().m_20699_(0.6f, 1.95f).m_20702_(12).m_20698_().m_20712_("adjudicator_mimic"));
        STONE_GOLEM = ENTITIES.register(BiomeMakeover.ID("stone_golem"), () -> EntityType.Builder.m_20704_(StoneGolemEntity::new, (MobCategory)MobCategory.MISC).m_20699_(1.6f, 2.5f).m_20702_(12).m_20712_("stone_golem"));
        SharedConstants.f_136182_ = dfCache;
        ATT_PROJECTILE_RESISTANCE = ATTRIBUTES.register(BiomeMakeover.ID("projectile_resistance"), () -> new RangedAttribute("attribute.name.biomemakeover.projectile_resistance", 0.0, 0.0, 30.0));
        LIGHTNING_BUG_TAG = TagKey.m_203882_((ResourceKey)Registry.f_122903_, (ResourceLocation)BiomeMakeover.ID("lightning_bugs"));
        OWL_TARGETS = TagKey.m_203882_((ResourceKey)Registry.f_122903_, (ResourceLocation)BiomeMakeover.ID("owl_targets"));
    }
}

