/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.biomemakeover.entity.render.feature;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Map;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HeadedModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import party.lemons.biomemakeover.entity.render.feature.CowboyHatModel;
import party.lemons.biomemakeover.entity.render.feature.WitchHatModel;
import party.lemons.biomemakeover.init.BMItems;
import party.lemons.biomemakeover.item.HatItem;

public class HatLayer<T extends LivingEntity, M extends EntityModel<T>>
extends RenderLayer<T, M> {
    public Map<Item, EntityModel<T>> MODELS = Maps.newHashMap();
    private final EntityModelSet modelSet;
    private final float yOffset;

    public HatLayer(RenderLayerParent<T, M> par, EntityModelSet modelSet) {
        this(par, modelSet, 0.0f);
    }

    public HatLayer(RenderLayerParent<T, M> par, EntityModelSet modelSet, float yOffset) {
        super(par);
        this.yOffset = yOffset;
        this.modelSet = modelSet;
    }

    public HatItem getHatItem(T entity) {
        ItemStack headSlot = entity.m_6844_(EquipmentSlot.HEAD);
        Item item = headSlot.m_41720_();
        if (item instanceof HatItem) {
            HatItem hat = (HatItem)item;
            if (!headSlot.m_41619_()) {
                return hat;
            }
        }
        return null;
    }

    public EntityModel<T> getHatModel(T entity) {
        HatItem hatItem = this.getHatItem(entity);
        if (hatItem != null) {
            if (this.MODELS.isEmpty()) {
                this.MODELS.put(BMItems.COWBOY_HAT.get(), new CowboyHatModel(this.modelSet.m_171103_(CowboyHatModel.LAYER_LOCATION)));
                this.MODELS.put(BMItems.WITCH_HAT.get(), new WitchHatModel(this.modelSet.m_171103_(WitchHatModel.LAYER_LOCATION)));
            }
            return this.MODELS.get((Object)hatItem);
        }
        return null;
    }

    public void render(PoseStack poseStack, MultiBufferSource multiBufferSource, int light, T entity, float limbAngle, float limbDistance, float tickDelta, float animationProgress, float headYaw, float headPitch) {
        EntityModel<T> hatModel = this.getHatModel(entity);
        ItemStack headSlot = entity.m_6844_(EquipmentSlot.HEAD);
        if (hatModel != null) {
            poseStack.m_85836_();
            this.setupHat(poseStack);
            VertexConsumer vertexConsumer = ItemRenderer.m_115184_((MultiBufferSource)multiBufferSource, (RenderType)RenderType.m_110431_((ResourceLocation)this.getTextureLocation(entity)), (boolean)false, (boolean)headSlot.m_41790_());
            hatModel.m_7695_(poseStack, vertexConsumer, light, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
            poseStack.m_85849_();
        }
    }

    public void setupHat(PoseStack poseStack) {
        ((HeadedModel)this.m_117386_()).m_5585_().m_104299_(poseStack);
        poseStack.m_85841_(1.25f, 1.25f, 1.25f);
        poseStack.m_85837_(0.0, (double)this.yOffset, 0.0);
    }

    protected ResourceLocation getTextureLocation(T entity) {
        HatItem hatItem = this.getHatItem(entity);
        if (hatItem != null) {
            return hatItem.getHatTexture();
        }
        return super.m_117347_(entity);
    }
}

