/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.biomemakeover.entity.adjudicator.phase;

import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.ai.goal.GoalSelector;
import net.minecraft.world.level.Level;
import party.lemons.biomemakeover.entity.adjudicator.AdjudicatorEntity;

public abstract class AdjudicatorPhase {
    protected final ResourceLocation phaseID;
    protected final GoalSelector goalSelector;
    protected final GoalSelector targetSelector;
    protected final Level level;
    protected final AdjudicatorEntity adjudicator;
    protected final Random random;

    public AdjudicatorPhase(ResourceLocation phaseID, AdjudicatorEntity adjudicator) {
        this.phaseID = phaseID;
        this.adjudicator = adjudicator;
        this.level = adjudicator.f_19853_;
        this.random = this.level.f_46441_;
        this.goalSelector = new GoalSelector(this.level.m_46658_());
        this.targetSelector = new GoalSelector(this.level.m_46658_());
        this.initAI();
        adjudicator.PHASES.put(phaseID, this);
    }

    protected abstract void initAI();

    public abstract boolean isPhaseOver();

    public void tick() {
    }

    public void onEnterPhase() {
    }

    public void onExitPhase() {
    }

    public void onHurt(DamageSource source, float amount) {
    }

    public BlockPos getStartPosition() {
        return this.adjudicator.findSuitableArenaPos();
    }

    public boolean showBossBar() {
        return true;
    }

    public boolean isInvulnerable() {
        return false;
    }

    public boolean isVisible() {
        return false;
    }

    public abstract CompoundTag toTag();

    public abstract void fromTag(CompoundTag var1);

    public GoalSelector getGoalSelector() {
        return this.goalSelector;
    }

    public GoalSelector getTargetSelector() {
        return this.targetSelector;
    }

    public ResourceLocation getPhaseID() {
        return this.phaseID;
    }

    public boolean isSelectable() {
        return true;
    }

    public AdjudicatorPhase getNextPhase() {
        return this.adjudicator.TELEPORT;
    }
}

