/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.biomemakeover.entity;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.BodyRotationControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.AbstractGolem;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.CrossbowAttackMob;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import party.lemons.biomemakeover.entity.PlayerCreatable;
import party.lemons.biomemakeover.entity.ai.BetterCrossbowAttackGoal;
import party.lemons.biomemakeover.entity.ai.EmptyMobNavigation;
import party.lemons.biomemakeover.entity.mutipart.EntityPart;
import party.lemons.biomemakeover.entity.mutipart.MultiPartEntity;
import party.lemons.biomemakeover.init.BMAdvancements;
import party.lemons.biomemakeover.init.BMBlocks;
import party.lemons.biomemakeover.init.BMEffects;
import party.lemons.biomemakeover.util.sound.StoneGolemTurnSoundInstance;

public class StoneGolemEntity
extends AbstractGolem
implements CrossbowAttackMob,
NeutralMob,
MultiPartEntity<EntityPart<StoneGolemEntity>>,
PlayerCreatable {
    private static final EntityDataAccessor<Boolean> CHARGING = SynchedEntityData.m_135353_(StoneGolemEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> PLAYER_CREATED = SynchedEntityData.m_135353_(StoneGolemEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final UniformInt ANGER_TIME_RANGE = TimeUtil.m_145020_((int)20, (int)39);
    private int angerTime;
    private int holdCooldown = 0;
    private UUID angryAt;
    private EntityPart<StoneGolemEntity> BODY = new EntityPart<StoneGolemEntity>(this, 1.6f, 2.0f, 0.0, 0.5, 0.0);
    private EntityPart<StoneGolemEntity> BASE = new EntityPart<StoneGolemEntity>(this, 0.875f, 0.5f, 0.0, 0.0, 0.0).collides();
    private List<EntityPart<StoneGolemEntity>> parts = Lists.newArrayList((Object[])new EntityPart[]{this.BODY, this.BASE});
    private Object turnSound = null;
    private AABB cullBox = EntityDimensions.m_20398_((float)1.6f, (float)2.5f).m_20384_(0.0, 0.0, 0.0);

    public StoneGolemEntity(EntityType<? extends AbstractGolem> entityType, Level level) {
        super(entityType, level);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, new BetterCrossbowAttackGoal<StoneGolemEntity>(this, 1.0, 24.0f));
        this.f_21345_.m_25352_(2, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 5.0f, 1.0f));
        this.f_21345_.m_25352_(3, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 5.0f));
        this.f_21345_.m_25352_(4, (Goal)new LookAtPlayerGoal((Mob)this, StoneGolemEntity.class, 10.0f));
        this.f_21345_.m_25352_(5, (Goal)new LookAtPlayerGoal((Mob)this, AbstractGolem.class, 5.0f));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, false));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, StoneGolemEntity.class, 10, true, false, living -> {
            if (living instanceof StoneGolemEntity) {
                StoneGolemEntity other = (StoneGolemEntity)living;
                return this.isPlayerCreated() != other.isPlayerCreated();
            }
            return false;
        }));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, 10, true, false, g -> !this.isPlayerCreated()));
        this.f_21346_.m_25352_(5, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, this::m_21674_));
        this.f_21346_.m_25352_(6, (Goal)new NearestAttackableTargetGoal((Mob)this, Mob.class, 5, false, false, livingEntity -> livingEntity instanceof Monster && !(livingEntity instanceof Creeper)));
        this.f_21346_.m_25352_(4, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, false));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(CHARGING, (Object)false);
        this.m_20088_().m_135372_(PLAYER_CREATED, (Object)false);
    }

    protected InteractionResult m_6071_(Player player, InteractionHand hand) {
        if (this.isPlayerCreated()) {
            ItemStack playerStack = player.m_21120_(hand);
            if (!playerStack.m_41619_() && playerStack.m_41720_() == BMBlocks.CLADDED_STONE.get().m_5456_()) {
                float currentHealth = this.m_21223_();
                this.m_5634_(15.0f);
                if (this.m_21223_() == currentHealth) {
                    return InteractionResult.m_19078_((boolean)this.f_19853_.m_5776_());
                }
                float g = 1.0f + (this.f_19796_.nextFloat() - this.f_19796_.nextFloat()) * 0.2f;
                this.m_5496_(SoundEvents.f_12009_, 1.0f, g);
                if (!player.m_7500_()) {
                    playerStack.m_41774_(1);
                }
                return InteractionResult.m_19078_((boolean)this.f_19853_.m_5776_());
            }
            if (this.isHolding() && this.holdCooldown <= 0) {
                if (!this.f_19853_.m_5776_()) {
                    player.m_150109_().m_150079_(this.m_6844_(EquipmentSlot.MAINHAND).m_41777_());
                    this.m_8061_(EquipmentSlot.MAINHAND, ItemStack.f_41583_);
                }
                return InteractionResult.SUCCESS;
            }
            if (!playerStack.m_41619_() && playerStack.m_41720_() == Items.f_42717_) {
                if (!this.f_19853_.m_5776_()) {
                    ItemStack newStack = playerStack.m_41777_();
                    newStack.m_41764_(1);
                    this.m_8061_(EquipmentSlot.MAINHAND, newStack);
                    playerStack.m_41774_(1);
                    ++this.holdCooldown;
                    BMAdvancements.ARM_GOLEM.trigger((ServerPlayer)player);
                }
                return InteractionResult.SUCCESS;
            }
        }
        return super.m_6071_(player, hand);
    }

    public void m_8119_() {
        super.m_8119_();
        this.holdCooldown = 0;
        if (this.f_20883_ != this.f_20884_ && this.f_19853_.m_5776_()) {
            this.playRotateSound();
        }
    }

    private boolean isHolding() {
        return !this.m_6844_(EquipmentSlot.MAINHAND).m_41619_();
    }

    protected void m_6851_(DifficultyInstance difficultyInstance) {
        this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42717_));
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor serverLevelAccessor, DifficultyInstance difficultyInstance, MobSpawnType mobSpawnType, @Nullable SpawnGroupData spawnGroupData, @Nullable CompoundTag compoundTag) {
        this.m_6851_(difficultyInstance);
        this.m_6850_(difficultyInstance);
        return super.m_6518_(serverLevelAccessor, difficultyInstance, mobSpawnType, spawnGroupData, compoundTag);
    }

    public boolean m_21674_(LivingEntity livingEntity) {
        if (EntitySelector.f_20406_.test(livingEntity) && !this.isPlayerCreated()) {
            return true;
        }
        return super.m_21674_(livingEntity);
    }

    public boolean m_6779_(LivingEntity target) {
        if (this.isPlayerCreated() ? target instanceof Player || target instanceof AbstractVillager : target instanceof Monster) {
            return false;
        }
        return super.m_6779_(target);
    }

    @Override
    public boolean isPlayerCreated() {
        return (Boolean)this.m_20088_().m_135370_(PLAYER_CREATED);
    }

    @Override
    public void setPlayerCreated(boolean playerCreated) {
        this.m_20088_().m_135381_(PLAYER_CREATED, (Object)playerCreated);
    }

    protected int m_7302_(int i) {
        return i;
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128379_("PlayerCreated", this.isPlayerCreated());
        this.m_21678_(tag);
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.setPlayerCreated(tag.m_128471_("PlayerCreated"));
        this.m_147285_(this.f_19853_, tag);
    }

    protected SoundEvent m_5592_() {
        return BMEffects.STONE_GOLEM_DEATH.get();
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource source) {
        return BMEffects.STONE_GOLEM_HURT.get();
    }

    protected PathNavigation m_6037_(Level level) {
        return new EmptyMobNavigation((Mob)this, level);
    }

    protected BodyRotationControl m_7560_() {
        return new StoneGolemBodyControl((Mob)this);
    }

    public int m_6784_() {
        return this.angerTime;
    }

    public void m_7870_(int i) {
        this.angerTime = i;
    }

    public boolean m_7337_(Entity entity) {
        return false;
    }

    public void m_5997_(double d, double e, double f) {
    }

    @Nullable
    public UUID m_6120_() {
        return this.angryAt;
    }

    public void m_6925_(@Nullable UUID uUID) {
        this.angryAt = uUID;
    }

    public void m_6825_() {
        this.m_7870_(ANGER_TIME_RANGE.m_142270_(this.f_19796_));
    }

    public void m_6136_(boolean bl) {
        this.m_20088_().m_135381_(CHARGING, (Object)bl);
    }

    public boolean isChargingCrossbow() {
        return (Boolean)this.m_20088_().m_135370_(CHARGING);
    }

    public void m_5811_(LivingEntity livingEntity, ItemStack itemStack, Projectile projectile, float f) {
        this.m_32322_((LivingEntity)this, livingEntity, projectile, f, 1.6f);
    }

    public void m_8107_() {
        super.m_8107_();
        this.updateParts();
    }

    public void m_147240_(double d, double e, double f) {
    }

    public int m_8085_() {
        return 20;
    }

    public int m_8132_() {
        return 2;
    }

    public boolean m_5886_(ProjectileWeaponItem projectileWeaponItem) {
        return projectileWeaponItem == Items.f_42717_;
    }

    public void m_5847_() {
    }

    public void m_6504_(LivingEntity livingEntity, float f) {
        this.m_32336_((LivingEntity)this, f);
    }

    public ItemStack m_6298_(ItemStack stack) {
        if (stack.m_41720_() instanceof ProjectileWeaponItem) {
            Predicate predicate = ((ProjectileWeaponItem)stack.m_41720_()).m_6442_();
            ItemStack itemStack = ProjectileWeaponItem.m_43010_((LivingEntity)this, (Predicate)predicate);
            return itemStack.m_41619_() ? new ItemStack((ItemLike)Items.f_42412_) : itemStack;
        }
        return ItemStack.f_41583_;
    }

    protected float m_6431_(Pose pose, EntityDimensions entityDimensions) {
        return 2.0f;
    }

    @Override
    public boolean damagePart(EntityPart<StoneGolemEntity> part, DamageSource source, float amount) {
        return this.m_6469_(source, amount);
    }

    @OnlyIn(value=Dist.CLIENT)
    public AbstractIllager.IllagerArmPose getState() {
        if (this.isChargingCrossbow()) {
            return AbstractIllager.IllagerArmPose.CROSSBOW_CHARGE;
        }
        if (this.m_21055_(Items.f_42717_)) {
            return AbstractIllager.IllagerArmPose.CROSSBOW_HOLD;
        }
        return this.m_5912_() ? AbstractIllager.IllagerArmPose.ATTACKING : AbstractIllager.IllagerArmPose.NEUTRAL;
    }

    @OnlyIn(value=Dist.CLIENT)
    private void playRotateSound() {
        boolean nulled;
        boolean bl = nulled = this.turnSound == null;
        if (nulled || ((StoneGolemTurnSoundInstance)((Object)this.turnSound)).m_7801_()) {
            if (!nulled) {
                Minecraft.m_91087_().m_91106_().m_120399_((SoundInstance)((StoneGolemTurnSoundInstance)((Object)this.turnSound)));
            }
            this.turnSound = new StoneGolemTurnSoundInstance(this);
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)((StoneGolemTurnSoundInstance)((Object)this.turnSound)));
        } else if (!nulled) {
            ((StoneGolemTurnSoundInstance)((Object)this.turnSound)).m_7788_();
        }
    }

    public IronGolem.Crackiness getCrack() {
        return IronGolem.Crackiness.m_28901_((float)(this.m_21223_() / this.m_21233_()));
    }

    public boolean m_6469_(DamageSource source, float amount) {
        IronGolem.Crackiness crack = this.getCrack();
        boolean bl = super.m_6469_(source, amount);
        if (bl && this.getCrack() != crack) {
            this.m_5496_(SoundEvents.f_12058_, 1.0f, 1.0f);
        }
        return bl;
    }

    public double m_6048_() {
        return 2.0;
    }

    public boolean m_5807_() {
        return false;
    }

    @Override
    public List<EntityPart<StoneGolemEntity>> getParts() {
        return this.parts;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 60.0);
    }

    public AABB m_6921_() {
        return this.cullBox.m_82383_(this.m_20182_());
    }

    private static class StoneGolemBodyControl
    extends BodyRotationControl {
        private final Mob entity;
        private int activeTicks;

        public StoneGolemBodyControl(Mob mob) {
            super(mob);
            this.entity = mob;
        }

        public void m_8121_() {
            ++this.activeTicks;
            this.rotateBody();
            this.rotateLook();
        }

        private void rotateLook() {
            this.entity.m_5618_(Mth.m_14094_((float)this.entity.m_146908_(), (float)this.entity.m_6080_(), (float)this.entity.m_8085_()));
        }

        private void rotateBody() {
            int i = this.activeTicks - 10;
            float f = Mth.m_14036_((float)((float)i / 10.0f), (float)0.0f, (float)1.0f);
            float g = (float)this.entity.m_8085_() * (1.0f - f);
            this.entity.m_5618_(Mth.m_14094_((float)this.entity.m_146908_(), (float)this.entity.m_6080_(), (float)g));
        }
    }
}

