/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.biomemakeover.crafting.witch;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.ai.behavior.ShufflingList;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import party.lemons.biomemakeover.crafting.witch.QuestCategory;
import party.lemons.biomemakeover.crafting.witch.QuestItem;
import party.lemons.biomemakeover.crafting.witch.QuestRarity;
import party.lemons.biomemakeover.crafting.witch.WitchQuest;
import party.lemons.biomemakeover.crafting.witch.WitchQuestList;
import party.lemons.biomemakeover.init.BMBlocks;
import party.lemons.biomemakeover.init.BMItems;
import party.lemons.biomemakeover.network.S2C_HandleWitchQuests;

public class WitchQuestHandler {
    private static final Map<QuestCategory, List<QuestItem>> QUEST_ITEMS = Maps.newHashMap();
    private static final ShufflingList<Integer> ITEM_COUNT_SELECTOR = new ShufflingList();

    public static void init() {
        WitchQuestHandler.addQuestItem(QuestCategory.MUSHROOM, QuestItem.of((ItemLike)BMItems.GLOWFISH.get(), 10.0f, 3));
        WitchQuestHandler.addQuestItem(QuestCategory.MUSHROOM, QuestItem.of((ItemLike)BMBlocks.GLOWSHROOM_STEM.get(), 10.0f, 3));
        WitchQuestHandler.addQuestItem(QuestCategory.MUSHROOM, QuestItem.of((ItemLike)BMBlocks.GREEN_GLOWSHROOM_BLOCK.get(), 10.0f, 3));
        WitchQuestHandler.addQuestItem(QuestCategory.MUSHROOM, QuestItem.of((ItemLike)BMBlocks.ORANGE_GLOWSHROOM_BLOCK.get(), 13.0f, 3));
        WitchQuestHandler.addQuestItem(QuestCategory.MUSHROOM, QuestItem.of((ItemLike)BMBlocks.PURPLE_GLOWSHROOM_BLOCK.get(), 10.0f, 3));
        WitchQuestHandler.addQuestItem(QuestCategory.MUSHROOM, QuestItem.of((ItemLike)BMBlocks.GREEN_GLOWSHROOM.get(), 5.0f, 1));
        WitchQuestHandler.addQuestItem(QuestCategory.MUSHROOM, QuestItem.of((ItemLike)BMBlocks.ORANGE_GLOWSHROOM.get(), 8.0f, 1));
        WitchQuestHandler.addQuestItem(QuestCategory.MUSHROOM, QuestItem.of((ItemLike)BMBlocks.PURPLE_GLOWSHROOM.get(), 5.0f, 1));
        WitchQuestHandler.addQuestItem(QuestCategory.MUSHROOM, QuestItem.of((ItemLike)BMBlocks.MYCELIUM_ROOTS.get(), 3.0f, 2));
        WitchQuestHandler.addQuestItem(QuestCategory.MUSHROOM, QuestItem.of((ItemLike)BMBlocks.MYCELIUM_SPROUTS.get(), 3.0f, 2));
        WitchQuestHandler.addQuestItem(QuestCategory.MUSHROOM, QuestItem.of((ItemLike)BMBlocks.TALL_BROWN_MUSHROOM.get(), 5.0f, 2));
        WitchQuestHandler.addQuestItem(QuestCategory.MUSHROOM, QuestItem.of((ItemLike)BMBlocks.TALL_RED_MUSHROOM.get(), 5.0f, 2));
        WitchQuestHandler.addQuestItem(QuestCategory.MUSHROOM, QuestItem.of((ItemLike)Blocks.f_50195_, 10.0f, 1));
        WitchQuestHandler.addQuestItem(QuestCategory.MUSHROOM, QuestItem.of((ItemLike)BMItems.BLIGHTBAT_WING.get(), 5.0f, 1));
        WitchQuestHandler.addQuestItem(QuestCategory.MESA, QuestItem.of((ItemLike)BMItems.SCUTTLER_TAIL.get(), 5.0f, 5));
        WitchQuestHandler.addQuestItem(QuestCategory.MESA, QuestItem.of((ItemLike)BMItems.ECTOPLASM.get(), 8.0f, 3));
        WitchQuestHandler.addQuestItem(QuestCategory.MESA, QuestItem.of((ItemLike)BMItems.PINK_PETALS.get(), 12.0f, 1));
        WitchQuestHandler.addQuestItem(QuestCategory.MESA, QuestItem.of((ItemLike)BMBlocks.SAGUARO_CACTUS.get(), 1.0f, 10));
        WitchQuestHandler.addQuestItem(QuestCategory.DARK_FOREST, QuestItem.of((ItemLike)BMItems.MOTH_SCALES.get(), 5.0f, 6));
        WitchQuestHandler.addQuestItem(QuestCategory.DARK_FOREST, QuestItem.of((ItemLike)BMItems.BULBUS_ROOT.get(), 5.0f, 5));
        WitchQuestHandler.addQuestItem(QuestCategory.DARK_FOREST, QuestItem.of((ItemLike)BMItems.ILLUNITE_SHARD.get(), 10.0f, 2));
        WitchQuestHandler.addQuestItem(QuestCategory.DARK_FOREST, QuestItem.of((ItemLike)BMBlocks.IVY.get(), 3.0f, 10));
        WitchQuestHandler.addQuestItem(QuestCategory.DARK_FOREST, QuestItem.of((ItemLike)BMBlocks.MOTH_BLOSSOM.get(), 10.0f, 2));
        WitchQuestHandler.addQuestItem(QuestCategory.FLOWER, QuestItem.of((ItemLike)Blocks.f_50111_, 1.0f, 4));
        WitchQuestHandler.addQuestItem(QuestCategory.FLOWER, QuestItem.of((ItemLike)Blocks.f_50112_, 1.0f, 4));
        WitchQuestHandler.addQuestItem(QuestCategory.FLOWER, QuestItem.of((ItemLike)Blocks.f_50113_, 1.0f, 4));
        WitchQuestHandler.addQuestItem(QuestCategory.FLOWER, QuestItem.of((ItemLike)Blocks.f_50114_, 1.0f, 4));
        WitchQuestHandler.addQuestItem(QuestCategory.FLOWER, QuestItem.of((ItemLike)Blocks.f_50115_, 1.0f, 4));
        WitchQuestHandler.addQuestItem(QuestCategory.FLOWER, QuestItem.of((ItemLike)Blocks.f_50117_, 1.0f, 4));
        WitchQuestHandler.addQuestItem(QuestCategory.FLOWER, QuestItem.of((ItemLike)Blocks.f_50116_, 1.0f, 4));
        WitchQuestHandler.addQuestItem(QuestCategory.FLOWER, QuestItem.of((ItemLike)Blocks.f_50119_, 1.0f, 4));
        WitchQuestHandler.addQuestItem(QuestCategory.FLOWER, QuestItem.of((ItemLike)Blocks.f_50118_, 1.0f, 4));
        WitchQuestHandler.addQuestItem(QuestCategory.FLOWER, QuestItem.of((ItemLike)Blocks.f_50120_, 1.0f, 4));
        WitchQuestHandler.addQuestItem(QuestCategory.FLOWER, QuestItem.of((ItemLike)Blocks.f_50121_, 1.0f, 4));
        WitchQuestHandler.addQuestItem(QuestCategory.FLOWER, QuestItem.of((ItemLike)Blocks.f_50071_, 1.0f, 4));
        WitchQuestHandler.addQuestItem(QuestCategory.FLOWER, QuestItem.of((ItemLike)Blocks.f_50355_, 2.0f, 4));
        WitchQuestHandler.addQuestItem(QuestCategory.FLOWER, QuestItem.of((ItemLike)Blocks.f_50356_, 1.0f, 4));
        WitchQuestHandler.addQuestItem(QuestCategory.FLOWER, QuestItem.of((ItemLike)Blocks.f_50357_, 1.0f, 4));
        WitchQuestHandler.addQuestItem(QuestCategory.FLOWER, QuestItem.of((ItemLike)Blocks.f_50358_, 1.0f, 4));
        WitchQuestHandler.addQuestItem(QuestCategory.SWAMP, QuestItem.of((ItemLike)BMBlocks.SMALL_LILY_PAD.get(), 1.25f, 4));
        WitchQuestHandler.addQuestItem(QuestCategory.SWAMP, QuestItem.of((ItemLike)BMBlocks.CATTAIL.get(), 1.25f, 4));
        WitchQuestHandler.addQuestItem(QuestCategory.SWAMP, QuestItem.of((ItemLike)BMBlocks.REED.get(), 0.75f, 4));
        WitchQuestHandler.addQuestItem(QuestCategory.SWAMP, QuestItem.of((ItemLike)BMBlocks.WILLOWING_BRANCHES.get(), 1.0f, 4));
        WitchQuestHandler.addQuestItem(QuestCategory.SWAMP, QuestItem.of((ItemLike)Blocks.f_50196_, 1.0f, 4));
        WitchQuestHandler.addQuestItem(QuestCategory.SWAMP, QuestItem.of((ItemLike)Items.f_42518_, 2.0f, 4));
        WitchQuestHandler.addQuestItem(QuestCategory.SWAMP, QuestItem.of((ItemLike)BMItems.MAGENTA_PETALS.get(), 3.0f, 4));
        WitchQuestHandler.addQuestItem(QuestCategory.SWAMP, QuestItem.of((ItemLike)BMItems.WART.get(), 5.0f, 4));
        WitchQuestHandler.addQuestItem(QuestCategory.OCEAN, QuestItem.of((ItemLike)Blocks.f_50575_, 0.8f, 5));
        WitchQuestHandler.addQuestItem(QuestCategory.OCEAN, QuestItem.of((ItemLike)Blocks.f_50037_, 0.8f, 5));
        WitchQuestHandler.addQuestItem(QuestCategory.OCEAN, QuestItem.of((ItemLike)Items.f_42527_, 1.0f, 2));
        WitchQuestHandler.addQuestItem(QuestCategory.OCEAN, QuestItem.of((ItemLike)Items.f_42526_, 1.0f, 2));
        WitchQuestHandler.addQuestItem(QuestCategory.OCEAN, QuestItem.of((ItemLike)Items.f_42532_, 2.0f, 4));
        WitchQuestHandler.addQuestItem(QuestCategory.OCEAN, QuestItem.of((ItemLike)Items.f_41868_, 4.0f, 4));
        WitchQuestHandler.addQuestItem(QuestCategory.OCEAN, QuestItem.of((ItemLike)Items.f_42528_, 5.0f, 2));
        WitchQuestHandler.addQuestItem(QuestCategory.OCEAN, QuestItem.of((ItemLike)Items.f_42529_, 5.0f, 2));
        WitchQuestHandler.addQuestItem(QuestCategory.JUNGLE, QuestItem.of((ItemLike)Items.f_42533_, 1.25f, 10));
        WitchQuestHandler.addQuestItem(QuestCategory.JUNGLE, QuestItem.of((ItemLike)Blocks.f_50191_, 1.0f, 4));
        WitchQuestHandler.addQuestItem(QuestCategory.JUNGLE, QuestItem.of((ItemLike)Blocks.f_50186_, 4.0f, 4));
        WitchQuestHandler.addQuestItem(QuestCategory.JUNGLE, QuestItem.of((ItemLike)Items.f_42546_, 6.0f, 2));
        WitchQuestHandler.addQuestItem(QuestCategory.JUNGLE, QuestItem.of((ItemLike)Items.f_42575_, 1.25f, 4));
        WitchQuestHandler.addQuestItem(QuestCategory.JUNGLE, QuestItem.of((ItemLike)Blocks.f_50571_, 0.5f, 10));
        WitchQuestHandler.addQuestItem(QuestCategory.NETHER, QuestItem.of((ItemLike)Blocks.f_50691_, 5.0f, 5));
        WitchQuestHandler.addQuestItem(QuestCategory.NETHER, QuestItem.of((ItemLike)Blocks.f_50700_, 5.0f, 5));
        WitchQuestHandler.addQuestItem(QuestCategory.NETHER, QuestItem.of((ItemLike)Items.f_42588_, 2.25f, 10));
        WitchQuestHandler.addQuestItem(QuestCategory.NETHER, QuestItem.of((ItemLike)Blocks.f_50704_, 1.0f, 3));
        WitchQuestHandler.addQuestItem(QuestCategory.NETHER, QuestItem.of((ItemLike)Blocks.f_50702_, 1.0f, 3));
        WitchQuestHandler.addQuestItem(QuestCategory.NETHER, QuestItem.of((ItemLike)Blocks.f_50693_, 3.0f, 3));
        WitchQuestHandler.addQuestItem(QuestCategory.NETHER, QuestItem.of((ItemLike)Blocks.f_50654_, 3.0f, 3));
        WitchQuestHandler.addQuestItem(QuestCategory.NETHER, QuestItem.of((ItemLike)Blocks.f_50692_, 6.0f, 2));
        WitchQuestHandler.addQuestItem(QuestCategory.NETHER, QuestItem.of((ItemLike)Blocks.f_50451_, 5.0f, 2));
        WitchQuestHandler.addQuestItem(QuestCategory.NETHER, QuestItem.of((ItemLike)Blocks.f_50694_, 2.0f, 2));
        WitchQuestHandler.addQuestItem(QuestCategory.NETHER, QuestItem.of((ItemLike)Blocks.f_50699_, 4.0f, 1));
        WitchQuestHandler.addQuestItem(QuestCategory.NETHER, QuestItem.of((ItemLike)Blocks.f_50690_, 4.0f, 1));
        WitchQuestHandler.addQuestItem(QuestCategory.NETHER, QuestItem.of((ItemLike)Blocks.f_50141_, 5.0f, 3));
        WitchQuestHandler.addQuestItem(QuestCategory.NETHER, QuestItem.of((ItemLike)Items.f_42585_, 10.0f, 3));
        WitchQuestHandler.addQuestItem(QuestCategory.NETHER, QuestItem.of((ItemLike)Items.f_42593_, 6.0f, 3));
        WitchQuestHandler.addQuestItem(QuestCategory.NETHER, QuestItem.of((ItemLike)Items.f_42542_, 7.0f, 3));
        WitchQuestHandler.addQuestItem(QuestCategory.NETHER, QuestItem.of((ItemLike)Items.f_42586_, 14.0f, 2));
        WitchQuestHandler.addQuestItem(QuestCategory.NETHER, QuestItem.of((ItemLike)Blocks.f_50701_, 8.0f, 2));
        WitchQuestHandler.addQuestItem(QuestCategory.COMMON, QuestItem.of((ItemLike)Items.f_42410_, 5.0f, 4));
        WitchQuestHandler.addQuestItem(QuestCategory.COMMON, QuestItem.of((ItemLike)Items.f_42405_, 1.0f, 10));
        WitchQuestHandler.addQuestItem(QuestCategory.COMMON, QuestItem.of((ItemLike)Items.f_42279_, 10.0f, 1));
        WitchQuestHandler.addQuestItem(QuestCategory.COMMON, QuestItem.of((ItemLike)Items.f_42210_, 2.0f, 4));
        WitchQuestHandler.addQuestItem(QuestCategory.COMMON, QuestItem.of((ItemLike)Items.f_42780_, 1.0f, 4));
        WitchQuestHandler.addQuestItem(QuestCategory.COMMON, QuestItem.of((ItemLike)Items.f_41909_, 0.5f, 8));
        WitchQuestHandler.addQuestItem(QuestCategory.COMMON, QuestItem.of((ItemLike)Items.f_42501_, 0.8f, 8));
        WitchQuestHandler.addQuestItem(QuestCategory.COMMON, QuestItem.of((ItemLike)Items.f_42516_, 0.8f, 8));
        WitchQuestHandler.addQuestItem(QuestCategory.COMMON, QuestItem.of((ItemLike)Items.f_42451_, 2.0f, 8));
        WitchQuestHandler.addQuestItem(QuestCategory.COMMON, QuestItem.of((ItemLike)Items.f_42054_, 4.0f, 2));
        WitchQuestHandler.addQuestItem(QuestCategory.COMMON, QuestItem.of((ItemLike)Items.f_42591_, 2.0f, 2));
        WitchQuestHandler.addQuestItem(QuestCategory.COMMON, QuestItem.of((ItemLike)Items.f_42592_, 8.0f, 1));
        WitchQuestHandler.addQuestItem(QuestCategory.COMMON, QuestItem.of((ItemLike)Items.f_42584_, 5.0f, 5));
        WitchQuestHandler.addQuestItem(QuestCategory.COMMON, QuestItem.of((ItemLike)Items.f_42355_, 8.0f, 1));
        WitchQuestHandler.addQuestItem(QuestCategory.COMMON, QuestItem.of((ItemLike)Items.f_42403_, 3.5f, 4));
        WitchQuestHandler.addQuestItem(QuestCategory.COMMON, QuestItem.of((ItemLike)Items.f_42648_, 5.0f, 2));
        WitchQuestHandler.addQuestItem(QuestCategory.COMMON, QuestItem.of((ItemLike)Items.f_42714_, 7.0f, 4));
        WitchQuestHandler.addQuestItem(QuestCategory.COMMON, QuestItem.of((ItemLike)Items.f_42677_, 6.0f, 4));
        WitchQuestHandler.addQuestItem(QuestCategory.COMMON, QuestItem.of((ItemLike)Items.f_42787_, 7.0f, 1));
        WitchQuestHandler.addQuestItem(QuestCategory.COMMON, QuestItem.of((ItemLike)Items.f_42789_, 7.0f, 1));
        WitchQuestHandler.addQuestItem(QuestCategory.COMMON, QuestItem.of((ItemLike)Items.f_42521_, 1.25f, 5));
        WitchQuestHandler.addQuestItem(QuestCategory.COMMON, QuestItem.of((ItemLike)Items.f_42675_, 3.0f, 5));
        WitchQuestHandler.addQuestItem(QuestCategory.COMMON, QuestItem.of((ItemLike)Items.f_42500_, 0.4f, 10));
        WitchQuestHandler.addQuestItem(QuestCategory.COMMON, QuestItem.of((ItemLike)Items.f_42534_, 0.5f, 10));
        WitchQuestHandler.addQuestItem(QuestCategory.COMMON, QuestItem.of((ItemLike)Blocks.f_50133_, 3.5f, 4));
        WitchQuestHandler.addQuestItem(QuestCategory.COMMON, QuestItem.of((ItemLike)Blocks.f_50360_, 0.75f, 4));
        WitchQuestHandler.addQuestItem(QuestCategory.COMMON, QuestItem.of((ItemLike)Blocks.f_50034_, 0.5f, 4));
        WitchQuestHandler.addQuestItem(QuestCategory.COMMON, QuestItem.of((ItemLike)Blocks.f_50256_, 4.0f, 1));
        WitchQuestHandler.addQuestItem(QuestCategory.COMMON, QuestItem.of((ItemLike)BMItems.BAT_WING.get(), 3.0f, 1));
        WitchQuestHandler.addQuestItem(QuestCategory.RARE, QuestItem.of((ItemLike)Blocks.f_50070_, 10.0f, 1));
        WitchQuestHandler.addQuestItem(QuestCategory.RARE, QuestItem.of((ItemLike)Items.f_42747_, 15.0f, 1));
        WitchQuestHandler.addQuestItem(QuestCategory.RARE, QuestItem.of((ItemLike)Blocks.f_50312_, 50.0f, 1));
        WitchQuestHandler.addQuestItem(QuestCategory.RARE, QuestItem.of((ItemLike)Items.f_42686_, 175.0f, 1));
        WitchQuestHandler.addQuestItem(QuestCategory.RARE, QuestItem.of((ItemLike)Items.f_42612_, 10.0f, 1));
        WitchQuestHandler.addQuestItem(QuestCategory.RARE, QuestItem.of((ItemLike)Items.f_42437_, 40.0f, 1));
        WitchQuestHandler.addQuestItem(QuestCategory.RARE, QuestItem.of((ItemLike)Items.f_42436_, 5.0f, 1));
        WitchQuestHandler.addQuestItem(QuestCategory.RARE, QuestItem.of((ItemLike)Items.f_42682_, 30.0f, 1));
        WitchQuestHandler.addQuestItem(QuestCategory.RARE, QuestItem.of((ItemLike)Items.f_42678_, 30.0f, 1));
        WitchQuestHandler.addQuestItem(QuestCategory.RARE, QuestItem.of((ItemLike)Items.f_42681_, 30.0f, 1));
    }

    public static ItemStack getRewardFor(WitchQuest quest, Random random) {
        QuestRarity rarity = QuestRarity.getRarityFromQuest(quest);
        return rarity.rewards.sample().pickRandom(random);
    }

    public static WitchQuest createQuest(Random random) {
        List counts = ITEM_COUNT_SELECTOR.m_147922_().m_147932_().toList();
        int count = (Integer)counts.get(random.nextInt(counts.size()));
        ArrayList questItems = Lists.newArrayList();
        while (questItems.size() < count) {
            QuestCategory category = QuestCategory.choose(random);
            List<QuestItem> itemPool = QUEST_ITEMS.get((Object)category);
            QuestItem item = itemPool.get(random.nextInt(itemPool.size()));
            if (questItems.contains(item)) continue;
            questItems.add(item);
        }
        WitchQuest quest = new WitchQuest(random, questItems);
        return quest;
    }

    public static void addQuestItem(QuestCategory category, QuestItem questItem) {
        if (!QUEST_ITEMS.containsKey((Object)category)) {
            QUEST_ITEMS.put(category, Lists.newArrayList());
        }
        QUEST_ITEMS.get((Object)category).add(questItem);
    }

    public static void sendQuests(Player player, int index, WitchQuestList quests) {
        if (player.f_19853_.m_5776_()) {
            return;
        }
        new S2C_HandleWitchQuests(index, quests).sendTo((ServerPlayer)player);
    }

    static {
        ITEM_COUNT_SELECTOR.m_147929_((Object)1, 5);
        ITEM_COUNT_SELECTOR.m_147929_((Object)2, 8);
        ITEM_COUNT_SELECTOR.m_147929_((Object)3, 4);
        ITEM_COUNT_SELECTOR.m_147929_((Object)4, 3);
        ITEM_COUNT_SELECTOR.m_147929_((Object)5, 1);
    }
}

