/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.biomemakeover;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import dev.architectury.event.EventResult;
import dev.architectury.event.events.common.CommandRegistrationEvent;
import dev.architectury.event.events.common.LifecycleEvent;
import dev.architectury.platform.Platform;
import dev.architectury.registry.CreativeTabRegistry;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.levelgen.PatrolSpawner;
import net.minecraft.world.level.storage.loot.providers.number.BinomialDistributionGenerator;
import party.lemons.biomemakeover.crafting.witch.WitchQuestHandler;
import party.lemons.biomemakeover.entity.adjudicator.AdjudicatorRoomListener;
import party.lemons.biomemakeover.init.BMAdvancements;
import party.lemons.biomemakeover.init.BMBlockEntities;
import party.lemons.biomemakeover.init.BMBlocks;
import party.lemons.biomemakeover.init.BMEffects;
import party.lemons.biomemakeover.init.BMEnchantments;
import party.lemons.biomemakeover.init.BMEntities;
import party.lemons.biomemakeover.init.BMFeatures;
import party.lemons.biomemakeover.init.BMItems;
import party.lemons.biomemakeover.init.BMNetwork;
import party.lemons.biomemakeover.init.BMPotions;
import party.lemons.biomemakeover.init.BMScreens;
import party.lemons.biomemakeover.init.BMWorldGen;
import party.lemons.biomemakeover.level.BMWorldEvents;
import party.lemons.biomemakeover.mixin.PatrolSpawnerInvoker;
import party.lemons.biomemakeover.util.data.wiki.WikiGenerator;
import party.lemons.biomemakeover.util.loot.BMLootTableInjection;

public class BiomeMakeover {
    public static final CreativeModeTab TAB = CreativeTabRegistry.create((ResourceLocation)BiomeMakeover.ID("biomemakeover"), () -> new ItemStack((ItemLike)BMItems.ICON_ITEM.get()));
    private static final boolean ENABLE_WIKI = false;

    public static void init() {
        BMEffects.init();
        BMEntities.init();
        BMBlocks.init();
        BMBlockEntities.init();
        BMItems.init();
        BMNetwork.init();
        BMPotions.init();
        BMFeatures.init();
        BMScreens.init();
        BMAdvancements.init();
        BMEnchantments.init();
        AdjudicatorRoomListener.init();
        BMWorldEvents.init();
        if (Platform.isDevelopmentEnvironment()) {
            // empty if block
        }
        CommandRegistrationEvent.EVENT.register((dispatcher, selection) -> dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"pillager").requires(serverCommandSource -> serverCommandSource.m_6761_(2))).then(Commands.m_82129_((String)"pos", (ArgumentType)BlockPosArgument.m_118239_()).then(Commands.m_82129_((String)"leader", (ArgumentType)BoolArgumentType.bool()).executes(c -> {
            ((PatrolSpawnerInvoker)new PatrolSpawner()).callSpawnPatrolMember(((CommandSourceStack)c.getSource()).m_81372_(), BlockPosArgument.m_118242_((CommandContext)c, (String)"pos"), ((CommandSourceStack)c.getSource()).m_81372_().f_46441_, BoolArgumentType.getBool((CommandContext)c, (String)"leader"));
            return 1;
        })))));
        LifecycleEvent.SETUP.register(() -> {
            BMWorldGen.init();
            WitchQuestHandler.init();
            BMEntities.initSpawnsAndAttributes();
            BMLootTableInjection.inject(new ResourceLocation("minecraft", "entities/bat"), BinomialDistributionGenerator.m_165659_((int)2, (float)0.5f), (ItemLike)BMItems.BAT_WING.get());
            BMLootTableInjection.inject(new ResourceLocation("minecraft", "entities/evoker"), BinomialDistributionGenerator.m_165659_((int)3, (float)0.15f), (ItemLike)BMItems.ILLUNITE_SHARD.get());
        });
    }

    public static ResourceLocation ID(String path) {
        return new ResourceLocation("biomemakeover", path);
    }

    private static /* synthetic */ EventResult lambda$init$1(Player player, ItemEntity entity) {
        WikiGenerator.generate();
        return EventResult.pass();
    }
}

