/*
 * Decompiled with CFR 0.152.
 */
package top.seraphjack.simplelogin.server.handler;

import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.server.ServerLifecycleHooks;
import top.seraphjack.simplelogin.SimpleLogin;
import top.seraphjack.simplelogin.server.SLRegistries;
import top.seraphjack.simplelogin.server.handler.HandlerPlugin;
import top.seraphjack.simplelogin.server.handler.Login;
import top.seraphjack.simplelogin.server.storage.SLStorage;

@OnlyIn(value=Dist.DEDICATED_SERVER)
public final class PlayerLoginHandler {
    private static PlayerLoginHandler INSTANCE;
    private final Set<Login> loginList = ConcurrentHashMap.newKeySet();
    private final ScheduledExecutorService executor = new ScheduledThreadPoolExecutor(2, new ThreadFactoryBuilder().setNameFormat("SimpleLogin-Worker-%d").build());
    private final Map<ResourceLocation, HandlerPlugin> plugins = new ConcurrentHashMap<ResourceLocation, HandlerPlugin>();

    private PlayerLoginHandler(Stream<ResourceLocation> plugins) {
        plugins.forEach(this::loadPlugin);
    }

    public void loadPlugin(ResourceLocation rl) {
        if (this.plugins.containsKey(rl)) {
            return;
        }
        SimpleLogin.logger.info("Loading plugin {}", (Object)rl.toString());
        HandlerPlugin plugin = SLRegistries.PLUGINS.get(rl).orElseThrow(() -> new IllegalArgumentException("No such plugin found: " + rl)).get();
        Optional.ofNullable(this.plugins.put(rl, plugin)).ifPresent(HandlerPlugin::disable);
        plugin.enable(this.executor);
    }

    public void unloadPlugin(ResourceLocation rl) {
        Optional.ofNullable(this.plugins.remove(rl)).ifPresent(p -> {
            p.disable();
            SimpleLogin.logger.info("Unloaded plugin {}", (Object)rl.toString());
        });
    }

    public Collection<ResourceLocation> listPlugins() {
        return new ImmutableSet.Builder().addAll(this.plugins.keySet()).build();
    }

    public static void initLoginHandler(Stream<ResourceLocation> pluginList) {
        if (INSTANCE != null) {
            throw new IllegalStateException();
        }
        INSTANCE = new PlayerLoginHandler(pluginList);
    }

    public static PlayerLoginHandler instance() {
        if (INSTANCE == null) {
            throw new IllegalStateException();
        }
        return INSTANCE;
    }

    public void login(String id, String pwd) {
        id = id.toLowerCase();
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        Login login = this.getLoginByName(id);
        ServerPlayer player = server.m_6846_().m_11255_(id);
        if (login == null || player == null) {
            return;
        }
        this.loginList.remove(login);
        if (!SLStorage.instance().storageProvider.registered(id)) {
            SLStorage.instance().storageProvider.register(id, pwd);
            SimpleLogin.logger.info("Player " + id + " has successfully registered.");
            this.postLogin(player, login);
        } else if (SLStorage.instance().storageProvider.checkPassword(id, pwd)) {
            SimpleLogin.logger.info("Player " + id + " has successfully logged in.");
            this.postLogin(player, login);
        } else {
            SimpleLogin.logger.warn("Player " + id + " tried to login with a wrong password.");
            player.f_8906_.m_9942_((Component)new TextComponent("Wrong Password."));
        }
    }

    public void playerJoin(ServerPlayer player) {
        Login login = new Login(player);
        this.loginList.add(login);
        this.plugins.values().forEach(p -> p.preLogin(player, login));
    }

    public void playerLeave(ServerPlayer player) {
        this.loginList.removeIf(l -> l.name.equals(player.m_36316_().getName()));
        this.plugins.values().forEach(p -> p.preLogout(player));
    }

    public void postLogin(ServerPlayer player, Login login) {
        this.plugins.values().forEach(p -> p.postLogin(player, login));
    }

    public boolean hasPlayerLoggedIn(String id) {
        return this.loginList.stream().noneMatch(e -> e.name.equals(id.toLowerCase()));
    }

    public void stop() {
        SimpleLogin.logger.info("Shutting down player login handler");
        SimpleLogin.logger.info("Disabling all plugins");
        this.plugins.values().forEach(HandlerPlugin::disable);
        this.plugins.clear();
        this.executor.shutdown();
        try {
            if (!this.executor.awaitTermination(5L, TimeUnit.SECONDS)) {
                SimpleLogin.logger.error("Timed out waiting player login handler to terminate.");
            }
        }
        catch (InterruptedException ignore) {
            SimpleLogin.logger.error("Interrupted when waiting player login handler to terminate.");
        }
    }

    @Nullable
    private Login getLoginByName(String name) {
        return this.loginList.stream().filter(l -> l.name.equals(name)).findAny().orElse(null);
    }
}

