/*
 * Decompiled with CFR 0.152.
 */
package top.seraphjack.simplelogin.network;

import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;
import top.seraphjack.simplelogin.SimpleLogin;
import top.seraphjack.simplelogin.network.MessageChangePasswordResponse;
import top.seraphjack.simplelogin.network.NetworkLoader;
import top.seraphjack.simplelogin.server.storage.SLStorage;
import top.seraphjack.simplelogin.utils.SHA256;

public class MessageChangePassword {
    private final String original;
    private final String to;

    public MessageChangePassword(String original, String to) {
        this.original = SHA256.getSHA256(original);
        this.to = SHA256.getSHA256(to);
    }

    public static void encode(MessageChangePassword msg, FriendlyByteBuf buf) {
        buf.writeInt(msg.original.length());
        buf.writeCharSequence((CharSequence)msg.original, StandardCharsets.UTF_8);
        buf.writeInt(msg.to.length());
        buf.writeCharSequence((CharSequence)msg.to, StandardCharsets.UTF_8);
    }

    public static MessageChangePassword decode(FriendlyByteBuf buf) {
        String original = buf.readCharSequence(buf.readInt(), StandardCharsets.UTF_8).toString();
        String to = buf.readCharSequence(buf.readInt(), StandardCharsets.UTF_8).toString();
        return new MessageChangePassword(original, to);
    }

    public static void handle(MessageChangePassword msg, Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        assert (context.getSender() != null);
        String username = Objects.requireNonNull(ctx.get().getSender()).m_36316_().getName();
        if (SLStorage.instance().storageProvider.checkPassword(username, msg.original)) {
            SLStorage.instance().storageProvider.changePassword(username, msg.to);
            context.getSender().m_5661_((Component)new TranslatableComponent("simplelogin.info.password_change_successful"), false);
            NetworkLoader.INSTANCE.send(PacketDistributor.PLAYER.with(() -> ((NetworkEvent.Context)context).getSender()), (Object)new MessageChangePasswordResponse(true));
        } else {
            context.getSender().m_5661_((Component)new TranslatableComponent("simplelogin.info.password_change_fail"), false);
            NetworkLoader.INSTANCE.send(PacketDistributor.PLAYER.with(() -> ((NetworkEvent.Context)context).getSender()), (Object)new MessageChangePasswordResponse(false));
            SimpleLogin.logger.warn("Player " + username + " tried to change password with a wrong password.");
        }
        context.setPacketHandled(true);
    }
}

