/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createenchantmentindustry.content.contraptions.enchanting.printer;

import com.simibubi.create.content.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.content.kinetics.belt.behaviour.BeltProcessingBehaviour;
import com.simibubi.create.content.kinetics.belt.behaviour.TransportedItemStackHandlerBehaviour;
import com.simibubi.create.content.kinetics.belt.transport.TransportedItemStack;
import com.simibubi.create.foundation.advancement.AdvancementBehaviour;
import com.simibubi.create.foundation.advancement.CreateAdvancement;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.fluid.SmartFluidTankBehaviour;
import com.simibubi.create.foundation.utility.VecHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Containers;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import plus.dragons.createenchantmentindustry.content.contraptions.enchanting.printer.PrintEntry;
import plus.dragons.createenchantmentindustry.content.contraptions.enchanting.printer.PrinterTargetItemHandler;
import plus.dragons.createenchantmentindustry.content.contraptions.enchanting.printer.Printing;
import plus.dragons.createenchantmentindustry.content.contraptions.fluids.FilteringFluidTankBehaviour;
import plus.dragons.createenchantmentindustry.content.contraptions.fluids.experience.ExperienceFluid;
import plus.dragons.createenchantmentindustry.entry.CeiTags;
import plus.dragons.createenchantmentindustry.foundation.config.CeiConfigs;
import plus.dragons.createenchantmentindustry.foundation.data.advancement.CeiAdvancements;
import plus.dragons.createenchantmentindustry.foundation.data.advancement.CeiTriggers;
import plus.dragons.createenchantmentindustry.foundation.mixin.AdvancementBehaviourAccessor;
import plus.dragons.createenchantmentindustry.foundation.utility.CeiLang;

public class PrinterBlockEntity
extends SmartBlockEntity
implements IHaveGoggleInformation {
    public static final int COPYING_TIME = 100;
    protected BeltProcessingBehaviour beltProcessing;
    public int processingTicks = -1;
    SmartFluidTankBehaviour tank;
    private ItemStack copyTarget = null;
    public boolean tooExpensive = false;
    public PrintEntry printEntry;
    boolean sendParticles;
    LazyOptional<PrinterTargetItemHandler> itemHandler = LazyOptional.of(() -> new PrinterTargetItemHandler(this));
    protected static int ENCHANT_PARTICLE_COUNT = 20;

    public PrinterBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        this.tank = FilteringFluidTankBehaviour.single(fluidStack -> fluidStack.getFluid().m_205067_(CeiTags.FluidTag.PRINTER_INPUT.tag()), this, (Integer)CeiConfigs.SERVER.copierTankCapacity.get());
        behaviours.add((BlockEntityBehaviour)this.tank);
        this.beltProcessing = new BeltProcessingBehaviour((SmartBlockEntity)this).whenItemEnters(this::onItemReceived).whileItemHeld(this::whenItemHeld);
        behaviours.add((BlockEntityBehaviour)this.beltProcessing);
        this.registerAwardables(behaviours, new CreateAdvancement[]{CeiAdvancements.COPIABLE_MASTERPIECE.asCreateAdvancement(), CeiAdvancements.COPIABLE_MYSTERY.asCreateAdvancement(), CeiAdvancements.RELIC_RESTORATION.asCreateAdvancement(), CeiAdvancements.EMERGING_BRAND.asCreateAdvancement()});
    }

    public void tick() {
        super.tick();
        if (this.processingTicks >= 0) {
            --this.processingTicks;
        }
    }

    public ItemStack getCopyTarget() {
        if (this.copyTarget == null) {
            return ItemStack.f_41583_;
        }
        return this.copyTarget;
    }

    public void setCopyTarget(@NotNull ItemStack copyTarget) {
        if (copyTarget.m_41619_()) {
            this.copyTarget = null;
            this.tooExpensive = false;
            this.printEntry = null;
        } else {
            this.copyTarget = copyTarget;
            this.matchPrintEntry(copyTarget);
            this.tooExpensive = Printing.isTooExpensive(this.printEntry, copyTarget, (Integer)CeiConfigs.SERVER.copierTankCapacity.get());
        }
        this.processingTicks = -1;
        this.notifyUpdate();
    }

    private void matchPrintEntry(ItemStack copyTarget) {
        PrintEntry entry = Printing.match(copyTarget);
        if (entry == null) {
            this.copyTarget = null;
            this.tooExpensive = false;
        }
        this.printEntry = entry;
    }

    protected void spawnParticles() {
        if (this.isVirtual()) {
            return;
        }
        Vec3 vec = VecHelper.getCenterOf((Vec3i)this.f_58858_);
        vec = vec.m_82492_(0.0, 0.6875, 0.0);
        SimpleParticleType particle = ParticleTypes.f_123809_;
        for (int i = 0; i < ENCHANT_PARTICLE_COUNT; ++i) {
            Vec3 m = VecHelper.offsetRandomly((Vec3)Vec3.f_82478_, (Random)this.f_58857_.f_46441_, (float)1.0f);
            m = new Vec3(m.f_82479_, Math.abs(m.f_82480_), m.f_82481_);
            this.f_58857_.m_7107_((ParticleOptions)particle, vec.f_82479_, vec.f_82480_, vec.f_82481_, m.f_82479_, m.f_82480_, m.f_82481_);
        }
        this.f_58857_.m_7785_(vec.f_82479_, vec.f_82480_, vec.f_82481_, SoundEvents.f_11887_, SoundSource.BLOCKS, 1.0f, this.f_58857_.f_46441_.nextFloat() * 0.1f + 0.9f, true);
    }

    protected BeltProcessingBehaviour.ProcessingResult onItemReceived(TransportedItemStack transported, TransportedItemStackHandlerBehaviour handler) {
        if (handler.blockEntity.isVirtual()) {
            return BeltProcessingBehaviour.ProcessingResult.PASS;
        }
        if (this.tooExpensive || this.copyTarget == null) {
            return BeltProcessingBehaviour.ProcessingResult.PASS;
        }
        if (!Printing.valid(this.printEntry, this.copyTarget, transported.stack)) {
            return BeltProcessingBehaviour.ProcessingResult.PASS;
        }
        if (this.tank.isEmpty() || Printing.isCorrectInk(this.printEntry, this.getCurrentFluidInTank(), this.copyTarget)) {
            return BeltProcessingBehaviour.ProcessingResult.HOLD;
        }
        if (Printing.getRequiredAmountForItem(this.printEntry, this.copyTarget) == -1) {
            return BeltProcessingBehaviour.ProcessingResult.PASS;
        }
        return BeltProcessingBehaviour.ProcessingResult.HOLD;
    }

    protected BeltProcessingBehaviour.ProcessingResult whenItemHeld(TransportedItemStack transported, TransportedItemStackHandlerBehaviour handler) {
        if (this.processingTicks != -1 && this.processingTicks != 10) {
            return BeltProcessingBehaviour.ProcessingResult.HOLD;
        }
        if (this.tooExpensive || this.copyTarget == null) {
            return BeltProcessingBehaviour.ProcessingResult.PASS;
        }
        if (!Printing.valid(this.printEntry, this.copyTarget, transported.stack)) {
            return BeltProcessingBehaviour.ProcessingResult.PASS;
        }
        if (this.tank.isEmpty() || !Printing.isCorrectInk(this.printEntry, this.getCurrentFluidInTank(), this.copyTarget)) {
            return BeltProcessingBehaviour.ProcessingResult.HOLD;
        }
        FluidStack fluid = this.getCurrentFluidInTank();
        int requiredAmountForItem = Printing.getRequiredAmountForItem(this.printEntry, this.copyTarget);
        if (requiredAmountForItem == -1) {
            return BeltProcessingBehaviour.ProcessingResult.PASS;
        }
        if (requiredAmountForItem > fluid.getAmount()) {
            return BeltProcessingBehaviour.ProcessingResult.HOLD;
        }
        if (this.processingTicks == -1) {
            this.processingTicks = 100;
            this.notifyUpdate();
            return BeltProcessingBehaviour.ProcessingResult.HOLD;
        }
        ItemStack item = this.copyTarget.m_41777_();
        if (!this.f_58857_.m_5776_()) {
            Player player;
            AdvancementBehaviour advancementBehaviour;
            UUID playerId;
            if (item.m_150930_(Items.f_42615_)) {
                this.award(CeiAdvancements.COPIABLE_MASTERPIECE.asCreateAdvancement());
                if (item.m_41784_().m_128451_("generation") == 3) {
                    this.award(CeiAdvancements.RELIC_RESTORATION.asCreateAdvancement());
                }
            } else if (item.m_150930_(Items.f_42690_)) {
                this.award(CeiAdvancements.COPIABLE_MYSTERY.asCreateAdvancement());
            } else if (item.m_150930_(Items.f_42656_) && !transported.stack.m_150930_(Items.f_42656_)) {
                this.award(CeiAdvancements.EMERGING_BRAND.asCreateAdvancement());
            }
            if ((playerId = ((AdvancementBehaviourAccessor)(advancementBehaviour = (AdvancementBehaviour)this.getBehaviour(AdvancementBehaviour.TYPE))).getPlayerId()) != null && (player = this.f_58857_.m_46003_(playerId)) != null) {
                CeiTriggers.BOOK_PRINTED.trigger(player, 1);
            }
        }
        ItemStack copy = Printing.print(this.printEntry, this.copyTarget, requiredAmountForItem, transported.stack, fluid);
        ArrayList<TransportedItemStack> outList = new ArrayList<TransportedItemStack>();
        TransportedItemStack held = null;
        TransportedItemStack result = transported.copy();
        result.stack = copy;
        if (!transported.stack.m_41619_()) {
            held = transported.copy();
        }
        outList.add(result);
        handler.handleProcessingOnItem(transported, TransportedItemStackHandlerBehaviour.TransportedResult.convertToAndLeaveHeld(outList, (TransportedItemStack)held));
        this.tank.getPrimaryHandler().setFluid(fluid);
        this.sendParticles = true;
        this.notifyUpdate();
        return BeltProcessingBehaviour.ProcessingResult.HOLD;
    }

    private FluidStack getCurrentFluidInTank() {
        return this.tank.getPrimaryHandler().getFluid();
    }

    public void destroy() {
        super.destroy();
        Level level = this.f_58857_;
        if (level instanceof ServerLevel) {
            FluidStack fluidStack;
            Fluid fluid;
            ServerLevel serverLevel = (ServerLevel)level;
            ItemStack heldItemStack = this.copyTarget;
            BlockPos pos = this.m_58899_();
            if (heldItemStack != null) {
                Containers.m_18992_((Level)this.f_58857_, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)heldItemStack);
            }
            if ((fluid = (fluidStack = this.tank.getPrimaryHandler().getFluid()).getFluid()) instanceof ExperienceFluid) {
                ExperienceFluid expFluid = (ExperienceFluid)fluid;
                expFluid.drop(serverLevel, VecHelper.getCenterOf((Vec3i)pos), fluidStack.getAmount());
            }
        }
    }

    protected void write(CompoundTag compoundTag, boolean clientPacket) {
        super.write(compoundTag, clientPacket);
        compoundTag.m_128405_("ProcessingTicks", this.processingTicks);
        compoundTag.m_128379_("tooExpensive", this.tooExpensive);
        if (this.copyTarget != null) {
            compoundTag.m_128365_("copyTarget", (Tag)this.copyTarget.serializeNBT());
        }
        if (this.sendParticles && clientPacket) {
            compoundTag.m_128379_("SpawnParticles", true);
            this.sendParticles = false;
        }
    }

    public void writeSafe(CompoundTag tag) {
        super.writeSafe(tag);
        tag.m_128379_("tooExpensive", this.tooExpensive);
    }

    protected void read(CompoundTag compoundTag, boolean clientPacket) {
        super.read(compoundTag, clientPacket);
        this.copyTarget = null;
        this.processingTicks = compoundTag.m_128451_("ProcessingTicks");
        this.tooExpensive = compoundTag.m_128471_("tooExpensive");
        if (compoundTag.m_128441_("copyTarget")) {
            this.copyTarget = ItemStack.m_41712_((CompoundTag)compoundTag.m_128469_("copyTarget"));
            this.matchPrintEntry(this.copyTarget);
        }
        if (!clientPacket) {
            return;
        }
        if (compoundTag.m_128441_("SpawnParticles")) {
            this.spawnParticles();
        }
    }

    public void invalidate() {
        super.invalidate();
        this.itemHandler.invalidate();
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && side != Direction.DOWN) {
            return this.tank.getCapability().cast();
        }
        if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return this.itemHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    protected AABB createRenderBoundingBox() {
        return super.createRenderBoundingBox().m_82363_(0.0, -2.0, 0.0);
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        CeiLang.translate("gui.goggles.printer", new Object[0]).forGoggles(tooltip);
        if (this.copyTarget == null) {
            CeiLang.translate("gui.goggles.printer.no_target", new Object[0]).style(ChatFormatting.GRAY).forGoggles(tooltip, 1);
        } else {
            this.printEntry.addToGoggleTooltip(tooltip, isPlayerSneaking, this.copyTarget);
        }
        this.containedFluidTooltip(tooltip, isPlayerSneaking, this.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY));
        return true;
    }
}

