/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createenchantmentindustry.content.contraptions.enchanting.enchanter;

import com.jozufozu.flywheel.core.PartialModel;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import com.simibubi.create.AllPartialModels;
import com.simibubi.create.content.kinetics.belt.transport.TransportedItemStack;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.renderer.SmartBlockEntityRenderer;
import com.simibubi.create.foundation.render.CachedBufferer;
import com.simibubi.create.foundation.render.SuperByteBuffer;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.BookModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.ForgeHooksClient;
import plus.dragons.createenchantmentindustry.EnchantmentIndustry;
import plus.dragons.createenchantmentindustry.content.contraptions.enchanting.enchanter.BlazeEnchanterBlock;
import plus.dragons.createenchantmentindustry.content.contraptions.enchanting.enchanter.BlazeEnchanterBlockEntity;

public class BlazeEnchanterRenderer
extends SmartBlockEntityRenderer<BlazeEnchanterBlockEntity> {
    public static final Material BOOK_MATERIAL = ForgeHooksClient.getBlockMaterial((ResourceLocation)EnchantmentIndustry.genRL("block/blaze_enchanter_book"));
    private static final float PI = (float)Math.PI;
    private final BookModel bookModel;

    public BlazeEnchanterRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
        this.bookModel = new BookModel(context.m_173582_(ModelLayers.f_171271_));
    }

    protected void renderSafe(BlazeEnchanterBlockEntity be, float partialTicks, PoseStack ps, MultiBufferSource buffer, int light, int overlay) {
        super.renderSafe((SmartBlockEntity)be, partialTicks, ps, buffer, light, overlay);
        float horizontalAngle = AngleHelper.rad((double)be.headAngle.getValue(partialTicks));
        float animation = be.headAnimation.getValue(partialTicks) * 0.175f;
        ps.m_85836_();
        this.renderItem(be, partialTicks, animation, ps, buffer);
        this.renderBlaze(be, horizontalAngle, animation, ps, buffer);
        this.renderBook(be, partialTicks, horizontalAngle, ps, buffer);
        ps.m_85849_();
    }

    protected void renderItem(BlazeEnchanterBlockEntity be, float partialTicks, float animation, PoseStack ps, MultiBufferSource buffer) {
        TransportedItemStack transported = be.heldItem;
        if (transported == null) {
            return;
        }
        Direction insertedFrom = transported.insertedFrom;
        boolean horizontal = insertedFrom.m_122434_().m_122479_();
        ps.m_85836_();
        BlazeEnchanterBlock.HeatLevel heatLevel = (BlazeEnchanterBlock.HeatLevel)((Object)be.m_58900_().m_61143_(BlazeEnchanterBlock.HEAT_LEVEL));
        boolean active = be.processingTicks > 0 && be.processingTicks < 200;
        float renderTick = AnimationTickHolder.getRenderTime((LevelAccessor)be.m_58904_()) + (float)(((Object)((Object)be)).hashCode() % 13) * 16.0f;
        float beltOffset = horizontal ? Mth.m_14179_((float)partialTicks, (float)transported.prevBeltPosition, (float)transported.beltPosition) : 0.5f;
        float movingProgress = Mth.m_14031_((float)((1.0f - 2.0f * Mth.m_14154_((float)(0.5f - beltOffset))) * (float)Math.PI / 2.0f));
        float verticalOffsetMult = heatLevel.isAtLeast(BlazeEnchanterBlock.HeatLevel.KINDLED) ? 64.0f : 16.0f;
        float verticalOffset = movingProgress * 5.0f / 8.0f + Mth.m_14031_((float)(renderTick / 16.0f % ((float)Math.PI * 2))) / verticalOffsetMult + animation * 0.75f;
        ps.m_85837_(0.5, (double)(0.75f + verticalOffset), 0.5);
        Vec3 offsetVec = Vec3.m_82528_((Vec3i)insertedFrom.m_122424_().m_122436_()).m_82490_((double)(0.5f - beltOffset));
        ps.m_85837_(offsetVec.f_82479_, 0.0, offsetVec.f_82481_);
        if (horizontal) {
            float sideOffset = Mth.m_14179_((float)partialTicks, (float)transported.prevSideOffset, (float)transported.sideOffset);
            sideOffset = Mth.m_14179_((float)movingProgress, (float)sideOffset, (float)0.0f);
            boolean alongX = insertedFrom.m_122427_().m_122434_() == Direction.Axis.X;
            ps.m_85837_(alongX ? (double)sideOffset : 0.0, 0.0, alongX ? 0.0 : (double)(-sideOffset));
        }
        float rot = active ? ((float)(200 - be.processingTicks) + partialTicks) / 16.0f % ((float)Math.PI * 2) : renderTick / 16.0f % ((float)Math.PI * 2);
        float rotX = active ? rot + 1.5707964f : 0.0f;
        float rotY = rot + (float)Math.PI + (float)transported.angle * movingProgress;
        float rotZ = active ? rot : 0.0f;
        ps.m_85845_(Quaternion.m_175228_((float)rotX, (float)rotY, (float)rotZ));
        ps.m_85841_(0.5f, 0.5f, 0.5f);
        ItemRenderer itemRenderer = Minecraft.m_91087_().m_91291_();
        itemRenderer.m_174269_(transported.stack, ItemTransforms.TransformType.FIXED, 0xF000F0, OverlayTexture.f_118083_, ps, buffer, 0);
        ps.m_85849_();
    }

    protected void renderBlaze(BlazeEnchanterBlockEntity be, float horizontalAngle, float animation, PoseStack ps, MultiBufferSource buffer) {
        BlockState blockState = be.m_58900_();
        BlazeEnchanterBlock.HeatLevel heatLevel = (BlazeEnchanterBlock.HeatLevel)((Object)blockState.m_61143_(BlazeEnchanterBlock.HEAT_LEVEL));
        boolean smouldering = heatLevel == BlazeEnchanterBlock.HeatLevel.SMOULDERING;
        boolean active = be.processingTicks > 0 && be.processingTicks < 200;
        float time = AnimationTickHolder.getRenderTime((LevelAccessor)be.m_58904_());
        float renderTick = time + (float)(((Object)((Object)be)).hashCode() % 13) * 16.0f;
        float offsetMult = heatLevel.isAtLeast(BlazeEnchanterBlock.HeatLevel.KINDLED) ? 64.0f : 16.0f;
        float offset = Mth.m_14031_((float)((float)((double)(renderTick / 16.0f) % (Math.PI * 2)))) / offsetMult;
        float offset1 = Mth.m_14031_((float)((float)(((double)(renderTick / 16.0f) + Math.PI) % (Math.PI * 2)))) / offsetMult;
        float offset2 = Mth.m_14031_((float)((float)(((double)(renderTick / 16.0f) + 1.5707963267948966) % (Math.PI * 2)))) / offsetMult;
        float headY = offset + animation * 0.75f;
        VertexConsumer solid = buffer.m_6299_(RenderType.m_110451_());
        ps.m_85836_();
        ps.m_85837_(0.0, 0.125, 0.0);
        PartialModel blazeModel = switch (heatLevel) {
            case BlazeEnchanterBlock.HeatLevel.SEETHING -> {
                if (active) {
                    yield AllPartialModels.BLAZE_SUPER_ACTIVE;
                }
                yield AllPartialModels.BLAZE_SUPER;
            }
            case BlazeEnchanterBlock.HeatLevel.KINDLED -> {
                if (active) {
                    yield AllPartialModels.BLAZE_ACTIVE;
                }
                yield AllPartialModels.BLAZE_IDLE;
            }
            default -> AllPartialModels.BLAZE_INERT;
        };
        SuperByteBuffer blazeBuffer = CachedBufferer.partial((PartialModel)blazeModel, (BlockState)blockState);
        blazeBuffer.translate(0.0, (double)headY, 0.0);
        this.draw(blazeBuffer, horizontalAngle, ps, solid);
        if (be.goggles) {
            PartialModel gogglesModel = blazeModel == AllPartialModels.BLAZE_INERT ? AllPartialModels.BLAZE_GOGGLES_SMALL : AllPartialModels.BLAZE_GOGGLES;
            SuperByteBuffer gogglesBuffer = CachedBufferer.partial((PartialModel)gogglesModel, (BlockState)blockState);
            gogglesBuffer.translate(0.0, (double)(headY + 0.5f), 0.0);
            this.draw(gogglesBuffer, horizontalAngle, ps, solid);
        }
        if (!smouldering) {
            PartialModel rodsModel = heatLevel == BlazeEnchanterBlock.HeatLevel.SEETHING ? AllPartialModels.BLAZE_BURNER_SUPER_RODS : AllPartialModels.BLAZE_BURNER_RODS;
            PartialModel rodsModel2 = heatLevel == BlazeEnchanterBlock.HeatLevel.SEETHING ? AllPartialModels.BLAZE_BURNER_SUPER_RODS_2 : AllPartialModels.BLAZE_BURNER_RODS_2;
            SuperByteBuffer rodsBuffer = CachedBufferer.partial((PartialModel)rodsModel, (BlockState)blockState);
            rodsBuffer.translate(0.0, (double)(offset1 + animation + 0.125f), 0.0).light(0xF000F0).renderInto(ps, solid);
            SuperByteBuffer rodsBuffer2 = CachedBufferer.partial((PartialModel)rodsModel2, (BlockState)blockState);
            rodsBuffer2.translate(0.0, (double)(offset2 + animation - 0.1875f), 0.0).light(0xF000F0).renderInto(ps, solid);
        }
        ps.m_85849_();
    }

    protected void renderBook(BlazeEnchanterBlockEntity be, float partialTicks, float horizontalAngle, PoseStack ps, MultiBufferSource buffer) {
        ps.m_85836_();
        ps.m_85837_(0.5, 0.25, 0.5);
        float time = AnimationTickHolder.getRenderTime((LevelAccessor)be.m_58904_());
        ps.m_85837_(0.0, (double)0.1f + (double)Mth.m_14031_((float)(time * 0.1f)) * 0.01, 0.0);
        ps.m_85845_(Vector3f.f_122225_.m_122270_(horizontalAngle + 1.5707964f));
        ps.m_85845_(Vector3f.f_122227_.m_122240_(80.0f));
        float flip = Mth.m_14179_((float)partialTicks, (float)be.oFlip, (float)be.flip);
        float page0 = Mth.m_14187_((float)(flip + 0.25f)) * 1.6f - 0.3f;
        float page1 = Mth.m_14187_((float)(flip + 0.75f)) * 1.6f - 0.3f;
        this.bookModel.m_102292_(time, Mth.m_14036_((float)page0, (float)0.0f, (float)1.0f), Mth.m_14036_((float)page1, (float)0.0f, (float)1.0f), 1.0f);
        VertexConsumer vertexconsumer = BOOK_MATERIAL.m_119194_(buffer, RenderType::m_110446_);
        this.bookModel.m_102316_(ps, vertexconsumer, 0xF000F0, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        ps.m_85849_();
    }

    private void draw(SuperByteBuffer buffer, float horizontalAngle, PoseStack ps, VertexConsumer vc) {
        buffer.rotateCentered(Direction.UP, horizontalAngle).light(0xF000F0).renderInto(ps, vc);
    }
}

