/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.dynamics.client.gui.attachment;

import cofh.core.client.gui.ContainerScreenCoFH;
import cofh.core.client.gui.IGuiAccess;
import cofh.core.client.gui.element.ElementBase;
import cofh.core.client.gui.element.ElementButton;
import cofh.core.client.gui.element.ElementFluid;
import cofh.core.client.gui.element.ITooltipFactory;
import cofh.core.client.gui.element.SimpleTooltip;
import cofh.core.client.gui.element.panel.PanelBase;
import cofh.core.client.gui.element.panel.RSControlPanel;
import cofh.core.util.helpers.GuiHelper;
import cofh.lib.api.control.IRedstoneControllable;
import cofh.lib.util.helpers.SoundHelper;
import cofh.thermal.dynamics.attachment.FluidFilterAttachment;
import cofh.thermal.dynamics.inventory.container.attachment.FluidFilterAttachmentContainer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;

public class FluidFilterAttachmentScreen
extends ContainerScreenCoFH<FluidFilterAttachmentContainer> {
    public static final ResourceLocation TEXTURE = new ResourceLocation("cofh_core:textures/gui/generic.png");
    public static final String TEX_DENY_LIST = "cofh_core:textures/gui/filters/filter_deny_list.png";
    public static final String TEX_ALLOW_LIST = "cofh_core:textures/gui/filters/filter_allow_list.png";
    public static final String TEX_IGNORE_NBT = "cofh_core:textures/gui/filters/filter_ignore_nbt.png";
    public static final String TEX_USE_NBT = "cofh_core:textures/gui/filters/filter_use_nbt.png";
    public static final String TEX_BIDIRECTIONAL = "thermal:textures/gui/container/filter_attachment_mode_bidirectional.png";
    public static final String TEX_INPUT = "thermal:textures/gui/container/filter_attachment_mode_inbound.png";
    public static final String TEX_OUTPUT = "thermal:textures/gui/container/filter_attachment_mode_outbound.png";
    protected final FluidFilterAttachment attachment;

    public FluidFilterAttachmentScreen(FluidFilterAttachmentContainer container, Inventory inv, Component titleIn) {
        super((AbstractContainerMenu)container, inv, titleIn);
        this.texture = TEXTURE;
        this.attachment = container.attachment;
        this.info = GuiHelper.generatePanelInfo((String)"info.thermal.fluid_filter_attachment");
    }

    public void m_7856_() {
        super.m_7856_();
        this.addPanel((PanelBase)new RSControlPanel((IGuiAccess)this, (IRedstoneControllable)this.attachment));
        int i = 0;
        while (i < ((FluidFilterAttachmentContainer)this.f_97732_).getFilterSize()) {
            Slot slot = (Slot)((FluidFilterAttachmentContainer)this.f_97732_).f_38839_.get(i);
            this.addElement((ElementBase)GuiHelper.createSlot((IGuiAccess)this, (int)slot.f_40220_, (int)slot.f_40221_));
            int j = i++;
            this.addElement(new ElementFluid((IGuiAccess)this, slot.f_40220_, slot.f_40221_).setFluid(() -> ((FluidFilterAttachmentContainer)this.f_97732_).getFilterStacks().get(j)).setSize(16, 16));
        }
        this.addButtons();
    }

    protected void addButtons() {
        this.addElement(new ElementButton((IGuiAccess)this, 121, 22){

            public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
                ((FluidFilterAttachmentContainer)FluidFilterAttachmentScreen.this.f_97732_).setAllowList(true);
                SoundHelper.playClickSound((float)0.7f);
                return true;
            }
        }.setSize(20, 20).setTexture(TEX_DENY_LIST, 40, 20).setTooltipFactory((ITooltipFactory)new SimpleTooltip((Component)new TranslatableComponent("info.cofh.filter.allowlist.0"))).setVisible(() -> !((FluidFilterAttachmentContainer)this.f_97732_).getAllowList()));
        this.addElement(new ElementButton((IGuiAccess)this, 121, 22){

            public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
                ((FluidFilterAttachmentContainer)FluidFilterAttachmentScreen.this.f_97732_).setAllowList(false);
                SoundHelper.playClickSound((float)0.4f);
                return true;
            }
        }.setSize(20, 20).setTexture(TEX_ALLOW_LIST, 40, 20).setTooltipFactory((ITooltipFactory)new SimpleTooltip((Component)new TranslatableComponent("info.cofh.filter.allowlist.1"))).setVisible(() -> ((FluidFilterAttachmentContainer)this.f_97732_).getAllowList()));
        this.addElement(new ElementButton((IGuiAccess)this, 121, 44){

            public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
                ((FluidFilterAttachmentContainer)FluidFilterAttachmentScreen.this.f_97732_).setCheckNBT(true);
                SoundHelper.playClickSound((float)0.7f);
                return true;
            }
        }.setSize(20, 20).setTexture(TEX_IGNORE_NBT, 40, 20).setTooltipFactory((ITooltipFactory)new SimpleTooltip((Component)new TranslatableComponent("info.cofh.filter.checkNBT.0"))).setVisible(() -> !((FluidFilterAttachmentContainer)this.f_97732_).getCheckNBT()));
        this.addElement(new ElementButton((IGuiAccess)this, 121, 44){

            public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
                ((FluidFilterAttachmentContainer)FluidFilterAttachmentScreen.this.f_97732_).setCheckNBT(false);
                SoundHelper.playClickSound((float)0.4f);
                return true;
            }
        }.setSize(20, 20).setTexture(TEX_USE_NBT, 40, 20).setTooltipFactory((ITooltipFactory)new SimpleTooltip((Component)new TranslatableComponent("info.cofh.filter.checkNBT.1"))).setVisible(() -> ((FluidFilterAttachmentContainer)this.f_97732_).getCheckNBT()));
        this.addElement(new ElementButton((IGuiAccess)this, 143, 33){

            public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
                if (mouseButton == 0) {
                    FluidFilterAttachmentScreen.this.attachment.setFilterMode(FluidFilterAttachment.FilterMode.TO_EXTERNAL_ONLY);
                } else {
                    FluidFilterAttachmentScreen.this.attachment.setFilterMode(FluidFilterAttachment.FilterMode.TO_GRID_ONLY);
                }
                SoundHelper.playClickSound((float)0.8f);
                return true;
            }
        }.setSize(20, 20).setTexture(TEX_BIDIRECTIONAL, 40, 20).setTooltipFactory((ITooltipFactory)new SimpleTooltip((Component)new TranslatableComponent("info.thermal.filter_attachment.mode.0"))).setVisible(() -> this.attachment.getFilterMode() == FluidFilterAttachment.FilterMode.BIDIRECTIONAL));
        this.addElement(new ElementButton((IGuiAccess)this, 143, 33){

            public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
                if (mouseButton == 0) {
                    FluidFilterAttachmentScreen.this.attachment.setFilterMode(FluidFilterAttachment.FilterMode.TO_GRID_ONLY);
                } else {
                    FluidFilterAttachmentScreen.this.attachment.setFilterMode(FluidFilterAttachment.FilterMode.BIDIRECTIONAL);
                }
                SoundHelper.playClickSound((float)0.7f);
                return true;
            }
        }.setSize(20, 20).setTexture(TEX_INPUT, 40, 20).setTooltipFactory((ITooltipFactory)new SimpleTooltip((Component)new TranslatableComponent("info.thermal.filter_attachment.mode.1"))).setVisible(() -> this.attachment.getFilterMode() == FluidFilterAttachment.FilterMode.TO_EXTERNAL_ONLY));
        this.addElement(new ElementButton((IGuiAccess)this, 143, 33){

            public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
                if (mouseButton == 0) {
                    FluidFilterAttachmentScreen.this.attachment.setFilterMode(FluidFilterAttachment.FilterMode.BIDIRECTIONAL);
                } else {
                    FluidFilterAttachmentScreen.this.attachment.setFilterMode(FluidFilterAttachment.FilterMode.TO_EXTERNAL_ONLY);
                }
                SoundHelper.playClickSound((float)0.6f);
                return true;
            }
        }.setSize(20, 20).setTexture(TEX_OUTPUT, 40, 20).setTooltipFactory((ITooltipFactory)new SimpleTooltip((Component)new TranslatableComponent("info.thermal.filter_attachment.mode.2"))).setVisible(() -> this.attachment.getFilterMode() == FluidFilterAttachment.FilterMode.TO_GRID_ONLY));
    }
}

