/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.renderers.tiles;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import java.util.Locale;
import net.mehvahdjukaar.supplementaries.client.TextUtil;
import net.mehvahdjukaar.supplementaries.client.renderers.LOD;
import net.mehvahdjukaar.supplementaries.client.renderers.RendererUtil;
import net.mehvahdjukaar.supplementaries.client.renderers.RotHlpr;
import net.mehvahdjukaar.supplementaries.common.block.tiles.NoticeBoardBlockTile;
import net.mehvahdjukaar.supplementaries.common.network.NetworkHandler;
import net.mehvahdjukaar.supplementaries.common.network.ServerBoundRequestMapDataPacket;
import net.mehvahdjukaar.supplementaries.common.utils.CommonUtil;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.MapRenderer;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ComplexItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import net.minecraft.world.phys.Vec3;

public class NoticeBoardBlockTileRenderer
implements BlockEntityRenderer<NoticeBoardBlockTile> {
    private final ItemRenderer itemRenderer;
    private final MapRenderer mapRenderer;
    private final Font font;
    private final Camera camera;

    public NoticeBoardBlockTileRenderer(BlockEntityRendererProvider.Context context) {
        Minecraft minecraft = Minecraft.m_91087_();
        this.itemRenderer = minecraft.m_91291_();
        this.mapRenderer = minecraft.f_91063_.m_109151_();
        this.font = context.m_173586_();
        this.camera = minecraft.f_91063_.m_109153_();
    }

    public int getFrontLight(Level world, BlockPos pos, Direction dir) {
        return LevelRenderer.m_109541_((BlockAndTintGetter)world, (BlockPos)pos.m_142300_(dir));
    }

    public boolean getAxis(Direction dir) {
        return dir == Direction.NORTH || dir == Direction.SOUTH;
    }

    public void render(NoticeBoardBlockTile tile, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        if (!tile.shouldSkipTileRenderer()) {
            BlockPos pos;
            Level world = tile.m_58904_();
            if (world == null) {
                return;
            }
            ItemStack stack = tile.getDisplayedItem();
            if (stack.m_41619_()) {
                return;
            }
            Direction dir = tile.getDirection();
            float yaw = -dir.m_122435_();
            Vec3 cameraPos = this.camera.m_90583_();
            if (LOD.isOutOfFocus(cameraPos, pos = tile.m_58899_(), yaw)) {
                return;
            }
            int frontLight = this.getFrontLight(world, pos, dir);
            matrixStackIn.m_85836_();
            matrixStackIn.m_85837_(0.5, 0.5, 0.5);
            matrixStackIn.m_85845_(RotHlpr.rot((int)yaw));
            matrixStackIn.m_85837_(0.0, 0.0, 0.5);
            MapItemSavedData mapData = MapItem.m_42853_((ItemStack)stack, (Level)world);
            if (stack.m_41720_() instanceof ComplexItem) {
                if (mapData != null) {
                    matrixStackIn.m_85836_();
                    matrixStackIn.m_85837_(0.0, 0.0, 0.008);
                    matrixStackIn.m_85841_(0.0078125f, -0.0078125f, -0.0078125f);
                    matrixStackIn.m_85837_(-64.0, -64.0, 0.0);
                    Integer integer = MapItem.m_151131_((ItemStack)stack);
                    this.mapRenderer.m_168771_(matrixStackIn, bufferIn, integer.intValue(), mapData, true, frontLight);
                    matrixStackIn.m_85849_();
                } else {
                    LocalPlayer player = Minecraft.m_91087_().f_91074_;
                    NetworkHandler.INSTANCE.sendToServer((Object)new ServerBoundRequestMapDataPacket(tile.m_58899_(), player.m_142081_()));
                }
                matrixStackIn.m_85849_();
                return;
            }
            String page = tile.getText();
            if (page != null && !page.equals("")) {
                int scalingfactor;
                List tempPageLines;
                LOD lod = new LOD(cameraPos, pos);
                if (!lod.isNearMed()) {
                    matrixStackIn.m_85849_();
                    return;
                }
                matrixStackIn.m_85836_();
                matrixStackIn.m_85837_(0.0, 0.5, 0.008);
                float d0 = this.getAxis(dir) ? 0.56f : 0.42000002f;
                if (CommonUtil.FESTIVITY.isAprilsFool()) {
                    TextUtil.renderBeeMovie(matrixStackIn, bufferIn, frontLight, this.font, d0);
                    matrixStackIn.m_85849_();
                    matrixStackIn.m_85849_();
                    return;
                }
                String bookName = tile.m_8020_(0).m_41786_().getString().toLowerCase(Locale.ROOT);
                if (bookName.equals("credits")) {
                    TextUtil.renderCredits(matrixStackIn, bufferIn, frontLight, this.font, d0);
                    matrixStackIn.m_85849_();
                    matrixStackIn.m_85849_();
                    return;
                }
                int i = tile.getTextColor().m_41071_();
                int r = (int)((double)NativeImage.m_85085_((int)i) * (double)d0);
                int g = (int)((double)NativeImage.m_85103_((int)i) * (double)d0);
                int b = (int)((double)NativeImage.m_85119_((int)i) * (double)d0);
                int i1 = NativeImage.m_84992_((int)0, (int)b, (int)g, (int)r);
                if (tile.getFlag()) {
                    float maxlines;
                    FormattedText txt = TextUtil.parseText(page);
                    int width = this.font.m_92852_(txt);
                    float bordery = 0.125f;
                    float borderx = 0.1875f;
                    float lx = 1.0f - 2.0f * borderx;
                    float ly = 1.0f - 2.0f * bordery;
                    do {
                        scalingfactor = Mth.m_14143_((float)Mth.m_14116_((float)((float)width * 8.0f / (lx * ly))));
                        tempPageLines = this.font.m_92923_(txt, Mth.m_14143_((float)(lx * (float)scalingfactor)));
                        maxlines = ly * (float)scalingfactor / 8.0f;
                        ++width;
                    } while (maxlines < (float)tempPageLines.size());
                    tile.setFontScale(scalingfactor);
                    tile.setCachedPageLines(tempPageLines);
                } else {
                    tempPageLines = tile.getCachedPageLines();
                    scalingfactor = tile.getFontScale();
                }
                float scale = 1.0f / (float)scalingfactor;
                matrixStackIn.m_85841_(scale, -scale, scale);
                int numberoflin = tempPageLines.size();
                for (int lin = 0; lin < numberoflin; ++lin) {
                    FormattedCharSequence str = tempPageLines.get(lin);
                    float dx = (float)(-this.font.m_92724_(str) / 2) + 0.5f;
                    float dy = (float)(scalingfactor - 8 * numberoflin) / 2.0f + 0.5f;
                    if (!bookName.equals("missingno")) {
                        this.font.m_92733_(str, dx, dy + (float)(8 * lin), i1, false, matrixStackIn.m_85850_().m_85861_(), bufferIn, false, 0, frontLight);
                        continue;
                    }
                    this.font.m_92811_("\u00a7ka", dx, dy + (float)(8 * lin), i1, false, matrixStackIn.m_85850_().m_85861_(), bufferIn, false, 0, frontLight);
                }
                matrixStackIn.m_85849_();
                matrixStackIn.m_85849_();
                return;
            }
            if (!stack.m_41619_()) {
                Material rendermaterial = tile.getCachedPattern();
                if (rendermaterial != null) {
                    VertexConsumer builder = rendermaterial.m_119194_(bufferIn, RenderType::m_110482_);
                    int i = tile.getTextColor().m_41071_();
                    float b = (float)NativeImage.m_85085_((int)i) / 255.0f;
                    float g = (float)NativeImage.m_85103_((int)i) / 255.0f;
                    float r = (float)NativeImage.m_85119_((int)i) / 255.0f;
                    int lu = frontLight & 0xFFFF;
                    int lv = frontLight >> 16 & 0xFFFF;
                    RendererUtil.addQuadSide(builder, matrixStackIn, -0.4375f, -0.4375f, 0.008f, 0.4375f, 0.4375f, 0.008f, 0.15625f, 0.0625f, 0.59375f, 0.9375f, r, g, b, 1.0f, lu, lv, 0.0f, 0.0f, 1.0f, rendermaterial.m_119204_());
                } else {
                    BakedModel model = this.itemRenderer.m_174264_(stack, world, null, 0);
                    matrixStackIn.m_85837_(0.0, 0.0, 0.015675);
                    matrixStackIn.m_85841_(-0.5f, 0.5f, -0.5f);
                    this.itemRenderer.m_115143_(stack, ItemTransforms.TransformType.FIXED, true, matrixStackIn, bufferIn, frontLight, combinedOverlayIn, model);
                }
                matrixStackIn.m_85849_();
                return;
            }
            matrixStackIn.m_85849_();
        }
    }
}

