/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.block_models;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.mehvahdjukaar.supplementaries.common.block.BlockProperties;
import net.mehvahdjukaar.supplementaries.common.block.blocks.MimicBlock;
import net.mehvahdjukaar.supplementaries.common.block.blocks.RopeKnotBlock;
import net.mehvahdjukaar.supplementaries.setup.ModRegistry;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IDynamicBakedModel;
import net.minecraftforge.client.model.data.IModelData;
import org.jetbrains.annotations.NotNull;

public class RopeKnotBlockBakedModel
implements IDynamicBakedModel {
    private final BakedModel knot;
    private final BlockModelShaper blockModelShaper;

    public RopeKnotBlockBakedModel(BakedModel knot) {
        this.knot = knot;
        this.blockModelShaper = Minecraft.m_91087_().m_91289_().m_110907_();
    }

    @Nonnull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand, @Nonnull IModelData extraData) {
        BakedModel model;
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        try {
            BlockState mimic = (BlockState)extraData.getData(BlockProperties.MIMIC);
            if (mimic != null && !(mimic.m_60734_() instanceof MimicBlock) && !mimic.m_60795_()) {
                model = this.blockModelShaper.m_110893_(mimic);
                quads.addAll(model.getQuads(mimic, side, rand, (IModelData)EmptyModelData.INSTANCE));
            }
        }
        catch (Exception mimic) {
            // empty catch block
        }
        try {
            if (state != null && state.m_60734_() instanceof RopeKnotBlock) {
                BlockState rope = (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((Block)ModRegistry.ROPE.get()).m_49966_().m_61124_((Property)RopeKnotBlock.UP, (Comparable)((Boolean)state.m_61143_((Property)RopeKnotBlock.UP)))).m_61124_((Property)RopeKnotBlock.DOWN, (Comparable)((Boolean)state.m_61143_((Property)RopeKnotBlock.DOWN)))).m_61124_((Property)RopeKnotBlock.NORTH, (Comparable)((Boolean)state.m_61143_((Property)RopeKnotBlock.NORTH)))).m_61124_((Property)RopeKnotBlock.SOUTH, (Comparable)((Boolean)state.m_61143_((Property)RopeKnotBlock.SOUTH)))).m_61124_((Property)RopeKnotBlock.EAST, (Comparable)((Boolean)state.m_61143_((Property)RopeKnotBlock.EAST)))).m_61124_((Property)RopeKnotBlock.WEST, (Comparable)((Boolean)state.m_61143_((Property)RopeKnotBlock.WEST)));
                model = this.blockModelShaper.m_110893_(rope);
                quads.addAll(model.getQuads(rope, side, rand, (IModelData)EmptyModelData.INSTANCE));
                quads.addAll(this.knot.getQuads(state, side, rand, (IModelData)EmptyModelData.INSTANCE));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return quads;
    }

    public boolean m_7541_() {
        return true;
    }

    public boolean m_7539_() {
        return false;
    }

    public boolean m_7547_() {
        return false;
    }

    public boolean m_7521_() {
        return false;
    }

    public TextureAtlasSprite m_6160_() {
        return this.knot.m_6160_();
    }

    public TextureAtlasSprite getParticleIcon(@NotNull IModelData data) {
        BlockState mimic = (BlockState)data.getData(BlockProperties.MIMIC);
        if (mimic != null && !mimic.m_60795_()) {
            BakedModel model = this.blockModelShaper.m_110893_(mimic);
            try {
                return model.m_6160_();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.m_6160_();
    }

    public ItemOverrides m_7343_() {
        return ItemOverrides.f_111734_;
    }

    public ItemTransforms m_7442_() {
        return ItemTransforms.f_111786_;
    }
}

