/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tables.client.inventory.module;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import slimeknights.mantle.client.screen.ElementScreen;
import slimeknights.mantle.client.screen.ModuleScreen;
import slimeknights.mantle.client.screen.MultiModuleScreen;
import slimeknights.mantle.client.screen.ScalableElementScreen;
import slimeknights.mantle.client.screen.SliderWidget;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.client.RenderUtils;
import slimeknights.tconstruct.tables.client.inventory.widget.BorderWidget;

public class InfoPanelScreen
extends ModuleScreen {
    private static final int resW = 118;
    private static final int resH = 75;
    private static final Component DEFAULT_CAPTION = TConstruct.makeTranslation("gui", "caption").m_130940_(ChatFormatting.UNDERLINE);
    protected static ResourceLocation BACKGROUND_IMAGE = TConstruct.getResource("textures/gui/panel.png");
    protected static final ElementScreen TOP_LEFT = new ElementScreen(0, 0, 4, 4, 256, 256);
    protected static final ElementScreen TOP_RIGHT = new ElementScreen(122, 0, 4, 4);
    protected static final ElementScreen BOTTOM_LEFT = new ElementScreen(0, 79, 4, 4);
    protected static final ElementScreen BOTTOM_RIGHT = new ElementScreen(122, 79, 4, 4);
    protected static final ScalableElementScreen TOP = new ScalableElementScreen(4, 0, 118, 4);
    protected static final ScalableElementScreen BOTTOM = new ScalableElementScreen(4, 79, 118, 4);
    protected static final ScalableElementScreen LEFT = new ScalableElementScreen(0, 4, 4, 75);
    protected static final ScalableElementScreen RIGHT = new ScalableElementScreen(122, 4, 4, 75);
    protected static final ScalableElementScreen BACKGROUND = new ScalableElementScreen(4, 4, 118, 75);
    protected static final ElementScreen SLIDER_NORMAL = new ElementScreen(0, 83, 3, 5);
    protected static final ElementScreen SLIDER_HOVER = SLIDER_NORMAL.shift(InfoPanelScreen.SLIDER_NORMAL.w, 0);
    protected static final ScalableElementScreen SLIDER_BAR = new ScalableElementScreen(0, 88, 3, 8);
    protected static final ElementScreen SLIDER_TOP = new ElementScreen(3, 88, 3, 4);
    protected static final ElementScreen SLIDER_BOTTOM = new ElementScreen(3, 92, 3, 4);
    protected BorderWidget border = new BorderWidget();
    protected SliderWidget slider = new SliderWidget(SLIDER_NORMAL, SLIDER_HOVER, SLIDER_HOVER, SLIDER_TOP, SLIDER_BOTTOM, SLIDER_BAR);
    protected Component caption;
    protected List<Component> text;
    protected List<Component> tooltips;
    protected List<Integer> tooltipLines = Lists.newLinkedList();
    protected float textScale = 1.0f;

    public InfoPanelScreen(MultiModuleScreen parent, AbstractContainerMenu container, Inventory playerInventory, Component title) {
        super(parent, container, playerInventory, title, true, false);
        this.border.borderTop = TOP;
        this.border.borderBottom = BOTTOM;
        this.border.borderLeft = LEFT;
        this.border.borderRight = RIGHT;
        this.border.cornerTopLeft = TOP_LEFT;
        this.border.cornerTopRight = TOP_RIGHT;
        this.border.cornerBottomLeft = BOTTOM_LEFT;
        this.border.cornerBottomRight = BOTTOM_RIGHT;
        this.f_97726_ = 126;
        this.f_97727_ = 83;
        this.caption = DEFAULT_CAPTION;
        this.text = Lists.newLinkedList();
    }

    public int getScaledFontHeight() {
        Objects.requireNonNull(this.f_96547_);
        return (int)Math.ceil(9.0f * this.textScale);
    }

    public void updatePosition(int parentX, int parentY, int parentSizeX, int parentSizeY) {
        super.updatePosition(parentX, parentY, parentSizeX, parentSizeY);
        this.border.setPosition(this.f_97735_, this.f_97736_);
        this.border.setSize(this.f_97726_, this.f_97727_);
        this.slider.setPosition(this.guiRight() - this.border.w - 2, this.f_97736_ + this.border.h + 12);
        this.slider.setSize(this.f_97727_ - this.border.h * 2 - 2 - 12);
        this.updateSliderParameters();
    }

    public void setCaption(Component caption) {
        this.caption = caption.m_6881_().m_130940_(ChatFormatting.UNDERLINE);
        this.updateSliderParameters();
    }

    public void setText(Component ... text) {
        ArrayList<Component> textComponents = new ArrayList<Component>(Arrays.asList(text));
        this.setText(textComponents, null);
    }

    public void setText(List<Component> text) {
        this.setText(text, null);
    }

    public void setText(List<Component> text, @Nullable List<Component> tooltips) {
        this.text = text;
        this.updateSliderParameters();
        this.setTooltips(tooltips);
    }

    protected void setTooltips(@Nullable List<Component> tooltips) {
        this.tooltips = tooltips;
    }

    public boolean hasCaption() {
        return this.caption != null && !this.caption.getString().isEmpty();
    }

    public boolean hasTooltips() {
        return this.tooltips != null && !this.tooltips.isEmpty();
    }

    public boolean hasInitialized() {
        return this.f_96547_ != null;
    }

    public int calcNeededHeight() {
        int neededHeight = 0;
        if (!this.hasInitialized()) {
            return this.f_96544_;
        }
        int scaledFontHeight = this.getScaledFontHeight();
        if (this.hasCaption()) {
            neededHeight += scaledFontHeight;
            neededHeight += 3;
        }
        neededHeight = (int)((float)neededHeight + ((float)scaledFontHeight + 0.5f) * (float)this.getTotalLines().size());
        return neededHeight;
    }

    protected void updateSliderParameters() {
        this.slider.hide();
        int h = this.f_97727_ - 10;
        if (this.calcNeededHeight() <= h) {
            return;
        }
        this.slider.show();
        int scaledFontHeight = this.getScaledFontHeight();
        int neededHeight = this.calcNeededHeight();
        int hiddenRows = (neededHeight - h) / scaledFontHeight;
        if ((neededHeight - h) % scaledFontHeight > 0) {
            ++hiddenRows;
        }
        this.slider.setSliderParameters(0, hiddenRows, 1);
    }

    protected List<FormattedCharSequence> getTotalLines() {
        int w = this.f_97726_ - this.border.w * 2 + 2;
        if (!this.slider.isHidden()) {
            w -= this.slider.width + 3;
        }
        w = (int)((float)w / this.textScale);
        LinkedList lines = Lists.newLinkedList();
        this.tooltipLines.clear();
        for (Component textComponent : this.text) {
            this.tooltipLines.add(lines.size());
            if (textComponent.getString().isEmpty()) {
                lines.add(TextComponent.f_131282_.m_7532_());
                continue;
            }
            lines.addAll(this.f_96547_.m_92923_((FormattedText)textComponent, w));
        }
        return lines;
    }

    public InfoPanelScreen wood() {
        this.shift(126, 0);
        this.shiftSlider(6, 0);
        return this;
    }

    public InfoPanelScreen metal() {
        this.shift(126, 83);
        this.shiftSlider(12, 0);
        return this;
    }

    private void shift(int xd, int yd) {
        this.border.borderTop = TOP.shift(xd, yd);
        this.border.borderBottom = BOTTOM.shift(xd, yd);
        this.border.borderLeft = LEFT.shift(xd, yd);
        this.border.borderRight = RIGHT.shift(xd, yd);
        this.border.cornerTopLeft = TOP_LEFT.shift(xd, yd);
        this.border.cornerTopRight = TOP_RIGHT.shift(xd, yd);
        this.border.cornerBottomLeft = BOTTOM_LEFT.shift(xd, yd);
        this.border.cornerBottomRight = BOTTOM_RIGHT.shift(xd, yd);
    }

    private void shiftSlider(int xd, int yd) {
        this.slider = new SliderWidget(SLIDER_NORMAL.shift(xd, yd), SLIDER_HOVER.shift(xd, yd), SLIDER_HOVER.shift(xd, yd), SLIDER_TOP.shift(xd, yd), SLIDER_BOTTOM.shift(xd, yd), SLIDER_BAR.shift(xd, yd));
    }

    protected void m_7027_(PoseStack matrixStack, int x, int y) {
    }

    protected void m_7025_(PoseStack matrices, int mouseX, int mouseY) {
        int i;
        super.m_7025_(matrices, mouseX, mouseY);
        if (this.tooltips == null) {
            return;
        }
        if (mouseX < this.f_97735_ || mouseX > this.guiRight()) {
            return;
        }
        int scaledFontHeight = this.getScaledFontHeight();
        if (this.hasTooltips() && mouseX >= this.guiRight() - this.border.w - this.f_96547_.m_92895_("?") / 2 && mouseX < this.guiRight() && mouseY > this.f_97736_ + 5 && mouseY < this.f_97736_ + 5 + scaledFontHeight) {
            this.m_96617_(matrices, this.f_96547_.m_92923_((FormattedText)new TranslatableComponent("gui.tconstruct.general.hover"), 150), mouseX - 155, mouseY);
        }
        float y = this.getTooltipStart(5 + this.f_97736_);
        Objects.requireNonNull(this.f_96547_);
        float textHeight = (9.0f + 0.5f) * this.textScale;
        float lowerBound = this.f_97736_ + this.f_97727_ - 5;
        int index = -1;
        ListIterator<FormattedCharSequence> iter = this.getTotalLines().listIterator(this.slider.getValue());
        while (iter.hasNext() && !(y + textHeight > lowerBound)) {
            if ((float)mouseY > y && (float)mouseY <= y + textHeight) {
                index = iter.nextIndex();
                break;
            }
            iter.next();
            y += textHeight;
        }
        if (index < 0) {
            return;
        }
        for (i = 0; this.tooltipLines.size() > i && index > this.tooltipLines.get(i); ++i) {
        }
        if (i >= this.tooltips.size() || this.tooltips.get(i).getString().isEmpty()) {
            return;
        }
        int w = Mth.m_14045_((int)(this.f_96543_ - mouseX - 12), (int)0, (int)200);
        if (w < 100) {
            mouseX -= 100 - w;
            w = 100;
        }
        List lines = this.f_96547_.m_92923_((FormattedText)this.tooltips.get(i), w);
        this.m_96617_(matrices, lines, mouseX, mouseY - lines.size() * this.getScaledFontHeight() / 2);
    }

    protected float getTooltipStart(float y) {
        if (this.hasCaption()) {
            y += (float)(this.getScaledFontHeight() + 3);
        }
        return y;
    }

    protected void m_7286_(PoseStack matrices, float partialTicks, int mouseX, int mouseY) {
        RenderUtils.setup(BACKGROUND_IMAGE);
        this.border.draw(matrices);
        BACKGROUND.drawScaled(matrices, this.f_97735_ + 4, this.f_97736_ + 4, this.f_97726_ - 8, this.f_97727_ - 8);
        float y = 5 + this.f_97736_;
        float x = 5 + this.f_97735_;
        int color = -986896;
        if (this.hasTooltips()) {
            this.f_96547_.m_92883_(matrices, "?", (float)(this.guiRight() - this.border.w) - (float)this.f_96547_.m_92895_("?") / 2.0f, (float)(this.f_97736_ + 5), -10526881);
        }
        int scaledFontHeight = this.getScaledFontHeight();
        if (this.hasCaption()) {
            int x2 = this.f_97726_ / 2;
            this.f_96547_.m_92744_(matrices, this.caption.m_7532_(), (float)this.f_97735_ + (float)(x2 -= this.f_96547_.m_92852_((FormattedText)this.caption) / 2), y, color);
            y += (float)(scaledFontHeight + 3);
        }
        if (this.text == null || this.text.size() == 0) {
            return;
        }
        Objects.requireNonNull(this.f_96547_);
        float textHeight = 9.0f + 0.5f;
        float lowerBound = (float)(this.f_97736_ + this.f_97727_ - 5) / this.textScale;
        matrices.m_85836_();
        matrices.m_85841_(this.textScale, this.textScale, 1.0f);
        x /= this.textScale;
        y /= this.textScale;
        ListIterator<FormattedCharSequence> iter = this.getTotalLines().listIterator(this.slider.getValue());
        while (iter.hasNext() && !(y + textHeight - 0.5f > lowerBound)) {
            FormattedCharSequence line = iter.next();
            this.f_96547_.m_92744_(matrices, line, x, y, color);
            y += textHeight;
        }
        matrices.m_85849_();
        RenderUtils.setup(BACKGROUND_IMAGE);
        this.slider.update(mouseX, mouseY);
        this.slider.draw(matrices);
    }

    public boolean handleMouseClicked(double mouseX, double mouseY, int mouseButton) {
        if (!this.slider.isEnabled()) {
            return false;
        }
        if (mouseButton == 0 && mouseX >= (double)this.slider.xPos && mouseY >= (double)this.slider.yPos && mouseX <= (double)(this.slider.xPos + this.slider.width) && mouseY <= (double)(this.slider.yPos + this.slider.height)) {
            this.slider.handleMouseClicked((int)mouseX, (int)mouseY, mouseButton);
            return true;
        }
        return false;
    }

    public boolean handleMouseReleased(double mouseX, double mouseY, int state) {
        if (!this.slider.isEnabled()) {
            return false;
        }
        this.slider.handleMouseReleased();
        return mouseX >= (double)this.slider.xPos && mouseY >= (double)this.slider.yPos && mouseX <= (double)(this.slider.xPos + this.slider.width) && mouseY <= (double)(this.slider.yPos + this.slider.height);
    }

    public boolean handleMouseScrolled(double mouseX, double mouseY, double scrollData) {
        if (!this.slider.isEnabled() || !this.isMouseInModule((int)mouseX, (int)mouseY) || this.isMouseOverFullSlot(mouseX, mouseY)) {
            return false;
        }
        return this.slider.mouseScrolled(scrollData, true);
    }

    public void setTextScale(float textScale) {
        this.textScale = textScale;
    }
}

