/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.block.component;

import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.mantle.fluid.FluidTransferHelper;
import slimeknights.mantle.util.BlockEntityHelper;
import slimeknights.tconstruct.smeltery.block.component.SearedBlock;
import slimeknights.tconstruct.smeltery.block.entity.ITankBlockEntity;
import slimeknights.tconstruct.smeltery.block.entity.component.TankBlockEntity;

public class SearedTankBlock
extends SearedBlock
implements TankBlockEntity.ITankBlock,
EntityBlock {
    private final int capacity;

    public SearedTankBlock(BlockBehaviour.Properties properties, int capacity) {
        super(properties);
        this.capacity = capacity;
    }

    @Deprecated
    public float m_7749_(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return 1.0f;
    }

    @Override
    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return new TankBlockEntity(pPos, pState, this);
    }

    @Deprecated
    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (FluidTransferHelper.interactWithTank((Level)world, (BlockPos)pos, (Player)player, (InteractionHand)hand, (BlockHitResult)hit)) {
            return InteractionResult.SUCCESS;
        }
        return super.m_6227_(state, world, pos, player, hand, hit);
    }

    public int getLightEmission(BlockState state, BlockGetter world, BlockPos pos) {
        BlockEntity te = world.m_7702_(pos);
        if (te instanceof TankBlockEntity) {
            FluidStack fluid = ((TankBlockEntity)te).getTank().getFluid();
            return fluid.getFluid().getAttributes().getLuminosity(fluid);
        }
        return super.getLightEmission(state, world, pos);
    }

    @Override
    public void m_6402_(Level worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        CompoundTag nbt = stack.m_41783_();
        if (nbt != null) {
            BlockEntityHelper.get(TankBlockEntity.class, (BlockGetter)worldIn, (BlockPos)pos).ifPresent(te -> te.updateTank(nbt.m_128469_("tank")));
        }
        super.m_6402_(worldIn, pos, state, placer, stack);
    }

    @Deprecated
    public boolean m_7278_(BlockState state) {
        return true;
    }

    @Deprecated
    public int m_6782_(BlockState blockState, Level worldIn, BlockPos pos) {
        return ITankBlockEntity.getComparatorInputOverride((LevelAccessor)worldIn, pos);
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter world, BlockPos pos, Player player) {
        ItemStack stack = new ItemStack((ItemLike)this);
        BlockEntityHelper.get(TankBlockEntity.class, (BlockGetter)world, (BlockPos)pos).ifPresent(te -> te.setTankTag(stack));
        return stack;
    }

    @Override
    public int getCapacity() {
        return this.capacity;
    }

    public static enum TankType implements StringRepresentable
    {
        FUEL_TANK(4000),
        FUEL_GAUGE(4000),
        INGOT_TANK(4320),
        INGOT_GAUGE(4320);

        private final int capacity;

        public String m_7912_() {
            return this.toString().toLowerCase(Locale.US);
        }

        private TankType(int capacity) {
            this.capacity = capacity;
        }

        public int getCapacity() {
            return this.capacity;
        }
    }
}

