/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.utils;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.event.OnDatapackSyncEvent;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import slimeknights.mantle.network.NetworkWrapper;
import slimeknights.mantle.network.packet.ISimplePacket;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.tconstruct.common.network.TinkerNetwork;

public class JsonUtils {
    private JsonUtils() {
    }

    public static int getIntMin(JsonObject json, String key, int min) {
        int value = GsonHelper.m_13824_((JsonObject)json, (String)key, (int)min);
        if (value < min) {
            throw new JsonSyntaxException(key + " must be at least " + min);
        }
        return value;
    }

    public static int getIntMin(JsonElement json, String key, int min) {
        int value = GsonHelper.m_13897_((JsonElement)json, (String)key);
        if (value < min) {
            throw new JsonSyntaxException(key + " must be at least " + min);
        }
        return value;
    }

    @Deprecated
    public static <T extends IForgeRegistryEntry<T>> T convertToEntry(IForgeRegistry<T> registry, JsonElement element, String key) {
        return (T)JsonHelper.convertToEntry(registry, (JsonElement)element, (String)key);
    }

    @Deprecated
    public static <T extends IForgeRegistryEntry<T>> T getAsEntry(IForgeRegistry<T> registry, JsonObject parent, String key) {
        return (T)JsonHelper.getAsEntry(registry, (JsonObject)parent, (String)key);
    }

    @Deprecated
    @Nullable
    public static JsonObject getJson(Resource resource) {
        return JsonHelper.getJson((Resource)resource);
    }

    @Deprecated
    public static <T extends Enum<T>> T convertToEnum(JsonElement element, String key, Class<T> enumClass) {
        return (T)JsonHelper.convertToEnum((JsonElement)element, (String)key, enumClass);
    }

    @Deprecated
    public static <T extends Enum<T>> T getAsEnum(JsonObject json, String key, Class<T> enumClass) {
        return (T)JsonHelper.getAsEnum((JsonObject)json, (String)key, enumClass);
    }

    @Deprecated
    public static List<JsonObject> getFileInAllDomainsAndPacks(ResourceManager manager, String path) {
        return JsonHelper.getFileInAllDomainsAndPacks((ResourceManager)manager, (String)path, null);
    }

    public static void syncPackets(OnDatapackSyncEvent event, ISimplePacket ... packets) {
        JsonHelper.syncPackets((OnDatapackSyncEvent)event, (NetworkWrapper)TinkerNetwork.getInstance(), (ISimplePacket[])packets);
    }

    public static JsonObject withLocation(String key, ResourceLocation value) {
        JsonObject json = new JsonObject();
        json.addProperty(key, value.toString());
        return json;
    }

    public static JsonObject withType(ResourceLocation type) {
        return JsonUtils.withLocation("type", type);
    }

    public static ItemStack convertToItemStack(JsonElement element, String name) {
        if (element.isJsonPrimitive()) {
            return new ItemStack((ItemLike)GsonHelper.m_13874_((JsonElement)element, (String)name));
        }
        return CraftingHelper.getItemStack((JsonObject)GsonHelper.m_13918_((JsonElement)element, (String)name), (boolean)true);
    }

    public static ItemStack getAsItemStack(JsonObject parent, String name) {
        return JsonUtils.convertToItemStack(JsonHelper.getElement((JsonObject)parent, (String)name), name);
    }

    public static JsonElement serializeItemStack(ItemStack result) {
        String itemName = Objects.requireNonNull(result.m_41720_().getRegistryName()).toString();
        if (result.m_41782_()) {
            JsonObject jsonResult = new JsonObject();
            jsonResult.addProperty("item", itemName);
            int count = result.m_41613_();
            if (count > 1) {
                jsonResult.addProperty("count", (Number)count);
            }
            jsonResult.addProperty("nbt", Objects.requireNonNull(result.m_41783_()).toString());
            return jsonResult;
        }
        return new JsonPrimitive(itemName);
    }
}

