/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.structures.trollcave;

import java.util.Objects;
import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.StructureFeatureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.NoiseEffect;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructurePieceAccessor;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import twilightforest.block.TFBlocks;
import twilightforest.loot.TFTreasure;
import twilightforest.util.RotationUtil;
import twilightforest.util.WorldUtil;
import twilightforest.world.components.feature.BlockSpikeFeature;
import twilightforest.world.components.feature.config.SpikeConfig;
import twilightforest.world.components.structures.TFStructureComponentOld;
import twilightforest.world.components.structures.trollcave.CloudCastleComponent;
import twilightforest.world.components.structures.trollcave.TrollCaveConnectComponent;
import twilightforest.world.components.structures.trollcave.TrollCavePieces;
import twilightforest.world.components.structures.trollcave.TrollVaultComponent;
import twilightforest.world.registration.TFFeature;
import twilightforest.world.registration.features.TFConfiguredFeatures;

public class TrollCaveMainComponent
extends TFStructureComponentOld {
    protected static final SpikeConfig STONE_STALACTITE = new SpikeConfig((BlockStateProvider)BlockStateProvider.m_191382_((Block)Blocks.f_50069_), (IntProvider)UniformInt.m_146622_((int)6, (int)9), (IntProvider)UniformInt.m_146622_((int)3, (int)4), true);
    protected static final SpikeConfig STONE_STALAGMITE = new SpikeConfig((BlockStateProvider)BlockStateProvider.m_191382_((Block)Blocks.f_50069_), (IntProvider)UniformInt.m_146622_((int)4, (int)7), (IntProvider)UniformInt.m_146622_((int)3, (int)4), false);
    protected int size;
    protected int height;
    protected static final Predicate<Biome> highlands = biome -> false;

    public TrollCaveMainComponent(StructurePieceSerializationContext ctx, CompoundTag nbt) {
        this(TrollCavePieces.TFTCMai, nbt);
    }

    public TrollCaveMainComponent(StructurePieceType piece, CompoundTag nbt) {
        super(piece, nbt);
        this.size = nbt.m_128451_("size");
        this.height = nbt.m_128451_("height");
    }

    public TrollCaveMainComponent(StructurePieceType type, TFFeature feature, int i, int x, int y, int z) {
        super(type, feature, i, x, y, z);
        this.m_73519_(Direction.SOUTH);
        this.size = 30;
        this.height = 20;
        int radius = this.size / 2;
        this.f_73383_ = feature.getComponentToAddBoundingBox(x, y, z, -radius, -this.height, -radius, this.size, this.height, this.size, Direction.SOUTH);
    }

    @Override
    protected void m_183620_(StructurePieceSerializationContext ctx, CompoundTag tagCompound) {
        super.m_183620_(ctx, tagCompound);
        tagCompound.m_128405_("size", this.size);
        tagCompound.m_128405_("height", this.height);
    }

    public void m_142537_(StructurePiece parent, StructurePieceAccessor list, Random rand) {
        for (Rotation caveRotation : RotationUtil.ROTATIONS) {
            BlockPos dest = this.getValidOpening(rand, caveRotation);
            this.makeSmallerCave(list, rand, this.m_73548_() + 1, dest.m_123341_(), dest.m_123342_(), dest.m_123343_(), 18, 15, caveRotation);
        }
        CloudCastleComponent castle = new CloudCastleComponent(this.getFeatureType(), this.m_73548_() + 1, this.f_73383_.m_162395_() + (this.f_73383_.m_162399_() - this.f_73383_.m_162395_()) / 2, 168, this.f_73383_.m_162398_() + (this.f_73383_.m_162401_() - this.f_73383_.m_162398_()) / 2);
        list.m_142679_((StructurePiece)castle);
        castle.m_142537_(this, list, rand);
        TrollVaultComponent vault = new TrollVaultComponent(this.getFeatureType(), this.m_73548_() + 1, this.f_73383_.m_162395_() + (this.f_73383_.m_162399_() - this.f_73383_.m_162395_()) / 2, this.f_73383_.m_162396_(), this.f_73383_.m_162398_() + (this.f_73383_.m_162401_() - this.f_73383_.m_162398_()) / 2);
        list.m_142679_((StructurePiece)vault);
        vault.m_142537_(this, list, rand);
    }

    protected boolean makeSmallerCave(StructurePieceAccessor list, Random rand, int index, int x, int y, int z, int caveSize, int caveHeight, Rotation rotation) {
        Direction direction = this.getStructureRelativeRotation(rotation);
        BlockPos dest = this.offsetTowerCCoords(x, y, z, caveSize, direction);
        TrollCaveConnectComponent cave = new TrollCaveConnectComponent(this.getFeatureType(), index, dest.m_123341_(), dest.m_123342_(), dest.m_123343_(), caveSize, caveHeight, direction);
        StructurePiece intersect = list.m_141921_(cave.m_73547_());
        if (intersect == null || intersect == this) {
            list.m_142679_((StructurePiece)cave);
            cave.m_142537_(this, list, rand);
            return true;
        }
        return false;
    }

    public void m_183269_(WorldGenLevel world, StructureFeatureManager manager, ChunkGenerator generator, Random rand, BoundingBox sbb, ChunkPos chunkPosIn, BlockPos blockPos) {
        BlockPos.MutableBlockPos dest;
        int i;
        Random decoRNG = new Random(world.m_7328_() + (long)this.f_73383_.m_162395_() * 321534781L ^ (long)this.f_73383_.m_162398_() * 756839L);
        this.hollowCaveMiddle(world, sbb, rand, 0, 0, 0, this.size - 1, this.height - 1, this.size - 1);
        for (i = 0; i < 128; ++i) {
            dest = this.getCoordsInCave(decoRNG);
            this.generateBlockSpike(world, STONE_STALACTITE, (Vec3i)dest.m_175288_(this.height), sbb);
        }
        for (i = 0; i < 32; ++i) {
            dest = this.getCoordsInCave(decoRNG);
            this.generateBlockSpike(world, STONE_STALAGMITE, (Vec3i)dest.m_175288_(0), sbb);
        }
        for (i = 0; i < 32; ++i) {
            dest = this.getCoordsInCave(decoRNG);
            this.generateAtSurface(world, generator, TFConfiguredFeatures.UBEROUS_SOIL_PATCH_BIG, decoRNG, dest.m_123341_(), dest.m_123343_(), sbb);
        }
    }

    protected BlockPos.MutableBlockPos getCoordsInCave(Random rand) {
        return new BlockPos.MutableBlockPos(rand.nextInt(this.size - 1), rand.nextInt(this.height - 1), rand.nextInt(this.size - 1));
    }

    protected void hollowCaveMiddle(WorldGenLevel world, BoundingBox boundingBox, Random rand, int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        int threshold = this.size / 5;
        for (int y = minY; y <= maxY; ++y) {
            for (int x = minX; x <= maxX; ++x) {
                for (int z = minZ; z <= maxZ; ++z) {
                    int ez;
                    int ey;
                    int ex = Math.min(x - minX, maxX - x);
                    double dist = Math.sqrt(ex * (ey = Math.min((y - minY) * 2, maxY - y)) * (ez = Math.min(z - minZ, maxZ - z)));
                    if (dist > (double)threshold) {
                        this.m_73434_(world, Blocks.f_50016_.m_49966_(), x, y, z, boundingBox);
                        continue;
                    }
                    if (dist != (double)threshold || rand.nextInt(4) != 0 || !this.m_73398_((BlockGetter)world, x, y, z, boundingBox).m_204336_(BlockTags.f_13061_)) continue;
                    this.m_73434_(world, ((Block)TFBlocks.TROLLSTEINN.get()).m_49966_(), x, y, z, boundingBox);
                }
            }
        }
    }

    public BlockPos getValidOpening(Random rand, Rotation direction) {
        int offset = this.size / 4;
        int wLength = this.size - offset * 2;
        if (direction == Rotation.NONE || direction == Rotation.CLOCKWISE_180) {
            int rx = direction == Rotation.NONE ? this.size - 1 : 0;
            int rz = offset + rand.nextInt(wLength);
            int ry = 0;
            return new BlockPos(rx, ry, rz);
        }
        if (direction == Rotation.CLOCKWISE_90 || direction == Rotation.COUNTERCLOCKWISE_90) {
            int rx = offset + rand.nextInt(wLength);
            int rz = direction == Rotation.CLOCKWISE_90 ? this.size - 1 : 0;
            int ry = rand.nextInt(offset) - rand.nextInt(offset);
            return new BlockPos(rx, ry, rz);
        }
        return null;
    }

    @Override
    protected BlockPos offsetTowerCCoords(int x, int y, int z, int towerSize, Direction direction) {
        int dx = this.m_73392_(x, z);
        int dy = this.m_73544_(y);
        int dz = this.m_73525_(x, z);
        if (direction == Direction.SOUTH) {
            return new BlockPos(dx - 1, dy - 1, dz - towerSize / 2);
        }
        if (direction == Direction.WEST) {
            return new BlockPos(dx + towerSize / 2, dy - 1, dz - 1);
        }
        if (direction == Direction.NORTH) {
            return new BlockPos(dx + 1, dy - 1, dz + towerSize / 2);
        }
        if (direction == Direction.EAST) {
            return new BlockPos(dx - towerSize / 2, dy - 1, dz + 1);
        }
        return new BlockPos(x, y, z);
    }

    protected void generateBlockSpike(WorldGenLevel world, SpikeConfig config, Vec3i pos, BoundingBox sbb) {
        this.generateBlockSpike(world, config, pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), sbb);
    }

    protected void generateBlockSpike(WorldGenLevel world, SpikeConfig config, int x, int y, int z, BoundingBox sbb) {
        int dz;
        int dy;
        int dx = this.m_73392_(x, z);
        BlockPos pos = new BlockPos(dx, dy = this.m_73544_(y), dz = this.m_73525_(x, z));
        if (sbb.m_71051_((Vec3i)pos)) {
            Random stalRNG = new Random(world.m_7328_() + (long)dx * (long)dz);
            BlockSpikeFeature.startSpike(world, pos, config, stalRNG);
        }
    }

    protected <FC extends FeatureConfiguration> void generateAtSurface(WorldGenLevel world, ChunkGenerator generator, Holder<ConfiguredFeature<FC, ?>> feature, Random rand, int x, int z, BoundingBox sbb) {
        int dx = this.m_73392_(x, z);
        int dz = this.m_73525_(x, z);
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(dx, WorldUtil.getSeaLevel(Objects.requireNonNull(WorldUtil.getChunkGenerator((LevelAccessor)world))) + 15, dz);
        for (int i = 0; i < 15; ++i) {
            pos.m_122184_(0, 1, 0);
            if (!sbb.m_71051_((Vec3i)pos) || !world.m_8055_(pos.m_7494_()).m_60795_()) continue;
            ((ConfiguredFeature)feature.m_203334_()).m_65385_(world, generator, rand, (BlockPos)pos);
            break;
        }
    }

    protected void makeTreasureCrate(WorldGenLevel world, BoundingBox sbb) {
        int mid = this.size / 2;
        this.m_73441_(world, sbb, mid - 2, 0, mid - 2, mid + 1, 3, mid + 1, Blocks.f_50080_.m_49966_(), Blocks.f_50080_.m_49966_(), false);
        this.m_73535_(world, sbb, mid - 1, 1, mid - 1, mid, 2, mid);
        this.placeTreasureAtCurrentPosition(world, mid, 1, mid, TFTreasure.TROLL_GARDEN, false, sbb);
    }

    @Override
    public NoiseEffect m_142318_() {
        return NoiseEffect.BURY;
    }
}

