/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.structures.trollcave;

import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.StructureFeatureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructurePieceAccessor;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import twilightforest.block.TFBlocks;
import twilightforest.entity.TFEntities;
import twilightforest.entity.monster.ArmoredGiant;
import twilightforest.entity.monster.GiantMiner;
import twilightforest.world.components.structures.TFStructureComponentOld;
import twilightforest.world.components.structures.trollcave.CloudTreeComponent;
import twilightforest.world.components.structures.trollcave.TrollCavePieces;
import twilightforest.world.registration.TFFeature;

public class CloudCastleComponent
extends TFStructureComponentOld {
    private boolean minerPlaced = false;
    private boolean warriorPlaced = false;

    public CloudCastleComponent(StructurePieceSerializationContext ctx, CompoundTag nbt) {
        super(TrollCavePieces.TFClCa, nbt);
        this.minerPlaced = nbt.m_128471_("minerPlaced");
        this.warriorPlaced = nbt.m_128471_("warriorPlaced");
    }

    public CloudCastleComponent(TFFeature feature, int index, int x, int y, int z) {
        super(TrollCavePieces.TFClCa, feature, index, x, y, z);
        this.m_73519_(Direction.SOUTH);
        this.spawnListIndex = 1;
        this.f_73383_ = feature.getComponentToAddBoundingBox(x &= 0xFFFFFFFC, y &= 0xFFFFFFFC, z &= 0xFFFFFFFC, -8, -4, -8, 64, 16, 64, Direction.SOUTH);
    }

    @Override
    protected void m_183620_(StructurePieceSerializationContext ctx, CompoundTag tagCompound) {
        super.m_183620_(ctx, tagCompound);
        tagCompound.m_128379_("minerPlaced", this.minerPlaced);
        tagCompound.m_128379_("warriorPlaced", this.warriorPlaced);
    }

    public void m_142537_(StructurePiece parent, StructurePieceAccessor list, Random rand) {
        boolean plus = rand.nextBoolean();
        int offset = rand.nextInt(5) - rand.nextInt(5);
        CloudTreeComponent treeX = new CloudTreeComponent(this.getFeatureType(), this.m_73548_() + 1, this.f_73383_.m_162395_() + 8 + (plus ? 32 : -16), 168, this.f_73383_.m_162398_() + offset * 4);
        list.m_142679_((StructurePiece)treeX);
        treeX.m_142537_(this, list, rand);
        plus = rand.nextBoolean();
        offset = rand.nextInt(5) - rand.nextInt(5);
        CloudTreeComponent treeZ = new CloudTreeComponent(this.getFeatureType(), this.m_73548_() + 1, this.f_73383_.m_162395_() + offset * 4, 168, this.f_73383_.m_162398_() + 8 + (plus ? 32 : -16));
        list.m_142679_((StructurePiece)treeZ);
        treeZ.m_142537_(this, list, rand);
    }

    public void m_183269_(WorldGenLevel world, StructureFeatureManager manager, ChunkGenerator generator, Random rand, BoundingBox sbb, ChunkPos chunkPosIn, BlockPos blockPos) {
        int bz;
        int by;
        int bx;
        BlockPos pos;
        this.m_73441_(world, sbb, 8, 0, 8, 23, 3, 23, ((Block)TFBlocks.FLUFFY_CLOUD.get()).m_49966_(), ((Block)TFBlocks.FLUFFY_CLOUD.get()).m_49966_(), false);
        this.m_73441_(world, sbb, 8, 4, 8, 23, 15, 23, ((Block)TFBlocks.GIANT_COBBLESTONE.get()).m_49966_(), ((Block)TFBlocks.GIANT_COBBLESTONE.get()).m_49966_(), false);
        this.m_73441_(world, sbb, 8, 16, 8, 23, 19, 23, ((Block)TFBlocks.GIANT_LOG.get()).m_49966_(), ((Block)TFBlocks.GIANT_LOG.get()).m_49966_(), false);
        this.m_73535_(world, sbb, 12, 4, 12, 19, 15, 19);
        this.m_73535_(world, sbb, 8, 4, 12, 12, 11, 15);
        if (!this.minerPlaced && sbb.m_71051_((Vec3i)(pos = new BlockPos(bx = this.m_73392_(14, 14), by = this.m_73544_(4), bz = this.m_73525_(14, 14))))) {
            this.minerPlaced = true;
            GiantMiner miner = (GiantMiner)((EntityType)TFEntities.GIANT_MINER.get()).m_20615_((Level)world.m_6018_());
            miner.m_6034_(bx, by, bz);
            miner.m_21530_();
            miner.m_6518_((ServerLevelAccessor)world, world.m_6436_(pos), MobSpawnType.STRUCTURE, null, null);
            world.m_7967_((Entity)miner);
        }
        if (!this.warriorPlaced && sbb.m_71051_((Vec3i)(pos = new BlockPos(bx = this.m_73392_(17, 17), by = this.m_73544_(4), bz = this.m_73525_(17, 17))))) {
            this.warriorPlaced = true;
            ArmoredGiant warrior = (ArmoredGiant)((EntityType)TFEntities.ARMORED_GIANT.get()).m_20615_((Level)world.m_6018_());
            warrior.m_6034_(bx, by, bz);
            warrior.m_21530_();
            warrior.m_6518_((ServerLevelAccessor)world, world.m_6436_(pos), MobSpawnType.STRUCTURE, null, null);
            world.m_7967_((Entity)warrior);
        }
    }
}

