/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.structures.mushroomtower;

import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.StructureFeatureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructurePieceAccessor;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import twilightforest.TwilightForestMod;
import twilightforest.world.components.structures.TFStructureComponentOld;
import twilightforest.world.components.structures.mushroomtower.MushroomTowerPieces;
import twilightforest.world.components.structures.mushroomtower.MushroomTowerWingComponent;
import twilightforest.world.registration.TFFeature;

public class MushroomTowerBridgeComponent
extends MushroomTowerWingComponent {
    int dSize;
    int dHeight;

    public MushroomTowerBridgeComponent(StructurePieceSerializationContext ctx, CompoundTag nbt) {
        this(MushroomTowerPieces.TFMTBri, nbt);
    }

    public MushroomTowerBridgeComponent(StructurePieceType piece, CompoundTag nbt) {
        super(piece, nbt);
        this.dSize = nbt.m_128451_("destSize");
        this.dHeight = nbt.m_128451_("destHeight");
    }

    protected MushroomTowerBridgeComponent(StructurePieceType piece, TFFeature feature, int i, int x, int y, int z, int pSize, int pHeight, Direction direction) {
        super(piece, feature, i, x, y, z, pSize, pHeight, direction);
        this.f_73383_ = feature.getComponentToAddBoundingBox(x, y, z, 0, 0, 0, this.size - 1, this.height - 1, 3, direction);
        this.dSize = pSize;
        this.dHeight = pHeight;
    }

    @Override
    protected void m_183620_(StructurePieceSerializationContext ctx, CompoundTag tagCompound) {
        super.m_183620_(ctx, tagCompound);
        tagCompound.m_128405_("destSize", this.dSize);
        tagCompound.m_128405_("destHeight", this.dHeight);
    }

    @Override
    public void m_142537_(StructurePiece parent, StructurePieceAccessor list, Random rand) {
        if (parent != null && parent instanceof TFStructureComponentOld) {
            this.deco = ((TFStructureComponentOld)parent).deco;
        }
        int[] dest = new int[]{this.dSize - 1, 1, 1};
        boolean madeWing = this.makeTowerWing(list, rand, this.m_73548_(), dest[0], dest[1], dest[2], this.dSize, this.dHeight, Rotation.NONE);
        if (!madeWing) {
            int[] dx = this.offsetTowerCoords(dest[0], dest[1], dest[2], this.dSize, Direction.SOUTH);
            TwilightForestMod.LOGGER.info("Making tower wing failed when bridge was already made.  Size = {}, x = {}, z = {}", (Object)this.dSize, (Object)dx[0], (Object)dx[2]);
        }
    }

    public BoundingBox getWingBB() {
        int[] dest = this.offsetTowerCoords(this.dSize - 1, 1, 1, this.dSize, this.m_73549_());
        return this.getFeatureType().getComponentToAddBoundingBox(dest[0], dest[1], dest[2], 0, 0, 0, this.dSize - 1, this.dHeight - 1, this.dSize - 1, this.m_73549_());
    }

    @Override
    public void m_183269_(WorldGenLevel world, StructureFeatureManager manager, ChunkGenerator generator, Random rand, BoundingBox sbb, ChunkPos chunkPosIn, BlockPos blockPos) {
        for (int x = 0; x < this.dSize; ++x) {
            this.m_73434_(world, this.deco.fenceState, x, 1, 0, sbb);
            this.m_73434_(world, this.deco.fenceState, x, 1, 2, sbb);
            this.m_73434_(world, this.isAscender ? Blocks.f_50743_.m_49966_() : this.deco.floorState, x, 0, 1, sbb);
        }
        this.m_73535_(world, sbb, 0, 1, 1, 2, 2, 1);
    }
}

