/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.placements;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Random;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.placement.PlacementContext;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.PlacementModifierType;
import twilightforest.world.components.chunkgenerators.ChunkGeneratorTwilight;
import twilightforest.world.registration.TFFeature;
import twilightforest.world.registration.TwilightFeatures;

public class OutOfStructureFilter
extends PlacementModifier {
    public static final Codec<OutOfStructureFilter> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.fieldOf("occupies_surface").forGetter(o -> o.occupiesSurface), (App)Codec.BOOL.fieldOf("occupies_underground").forGetter(o -> o.occupiesUnderground), (App)Codec.INT.fieldOf("additional_clearance").forGetter(o -> o.additionalClearance)).apply((Applicative)instance, OutOfStructureFilter::new)).flatXmap(OutOfStructureFilter::validate, OutOfStructureFilter::validate);
    private final boolean occupiesSurface;
    private final boolean occupiesUnderground;
    private final int additionalClearance;

    public OutOfStructureFilter(boolean occupiesSurface, boolean occupiesUnderground, int additionalClearance) {
        this.occupiesSurface = occupiesSurface;
        this.occupiesUnderground = occupiesUnderground;
        this.additionalClearance = additionalClearance;
    }

    public static OutOfStructureFilter checkSurface() {
        return new OutOfStructureFilter(true, false, 0);
    }

    public static OutOfStructureFilter checkUnderground() {
        return new OutOfStructureFilter(false, true, 0);
    }

    public static OutOfStructureFilter checkBoth() {
        return new OutOfStructureFilter(true, true, 0);
    }

    public Stream<BlockPos> m_183381_(PlacementContext worldDecoratingHelper, Random random, BlockPos blockPos) {
        ChunkGenerator chunkGenerator = worldDecoratingHelper.m_191831_().m_6018_().m_7726_().m_8481_();
        if (!(chunkGenerator instanceof ChunkGeneratorTwilight)) {
            return Stream.of(blockPos);
        }
        ChunkGeneratorTwilight tfChunkGen = (ChunkGeneratorTwilight)chunkGenerator;
        BlockPos.MutableBlockPos featurePos = TFFeature.getNearestCenterXYZ(blockPos.m_123341_() >> 4, blockPos.m_123343_() >> 4).m_122032_();
        TFFeature feature = tfChunkGen.getFeatureCached(new ChunkPos((BlockPos)featurePos), worldDecoratingHelper.m_191831_());
        if (!(this.occupiesSurface && !feature.surfaceDecorationsAllowed || this.occupiesUnderground && !feature.undergroundDecoAllowed)) {
            return Stream.of(blockPos);
        }
        featurePos.m_122178_(Math.abs(featurePos.m_123341_() - blockPos.m_123341_()), 0, Math.abs(featurePos.m_123343_() - blockPos.m_123343_()));
        int size = feature.size * 16 + this.additionalClearance;
        return featurePos.m_123341_() < size && featurePos.m_123343_() < size ? Stream.empty() : Stream.of(blockPos);
    }

    public PlacementModifierType<?> m_183327_() {
        return (PlacementModifierType)TwilightFeatures.NO_STRUCTURE.get();
    }

    private static DataResult<OutOfStructureFilter> validate(OutOfStructureFilter config) {
        return config.occupiesSurface || config.occupiesUnderground ? DataResult.success((Object)((Object)config)) : DataResult.error((String)"Feature Decorator cannot occupy neither surface nor underground");
    }
}

