/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.chunkgenerators;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.function.Predicate;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.util.Mth;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.StructureFeatureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeResolver;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.chunk.ProtoChunk;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.NoiseBasedChunkGenerator;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.NoiseSettings;
import net.minecraft.world.level.levelgen.RandomSource;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.blending.Blender;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import twilightforest.block.TFBlocks;
import twilightforest.util.IntPair;
import twilightforest.world.components.biomesources.TFBiomeProvider;
import twilightforest.world.components.chunkgenerators.ChunkGeneratorWrapper;
import twilightforest.world.components.chunkgenerators.warp.NoiseModifier;
import twilightforest.world.components.chunkgenerators.warp.TFBlendedNoise;
import twilightforest.world.components.chunkgenerators.warp.TFNoiseInterpolator;
import twilightforest.world.components.chunkgenerators.warp.TFTerrainWarp;
import twilightforest.world.components.structures.start.TFStructureStart;
import twilightforest.world.registration.TFFeature;
import twilightforest.world.registration.TwilightFeatures;
import twilightforest.world.registration.biomes.BiomeKeys;

public class ChunkGeneratorTwilight
extends ChunkGeneratorWrapper {
    public static final Codec<ChunkGeneratorTwilight> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ChunkGenerator.f_62136_.fieldOf("wrapped_generator").forGetter(o -> o.delegate), (App)RegistryOps.m_206832_((ResourceKey)Registry.f_211073_).forGetter(o -> o.f_207955_), (App)NoiseGeneratorSettings.f_64431_.fieldOf("noise_generation_settings").forGetter(o -> o.noiseGeneratorSettings), (App)Codec.BOOL.fieldOf("generate_dark_forest_canopy").forGetter(o -> o.genDarkForestCanopy), (App)Codec.BOOL.fieldOf("monster_spawns_below_sealevel").forGetter(o -> o.monsterSpawnsBelowSeaLevel), (App)Codec.INT.optionalFieldOf("dark_forest_canopy_height").forGetter(o -> o.darkForestCanopyHeight), (App)Codec.BOOL.fieldOf("use_overworld_seed").forGetter(o -> false)).apply((Applicative)instance, instance.stable(ChunkGeneratorTwilight::new)));
    private final Holder<NoiseGeneratorSettings> noiseGeneratorSettings;
    private final boolean genDarkForestCanopy;
    private final boolean monsterSpawnsBelowSeaLevel;
    private final Optional<Integer> darkForestCanopyHeight;
    private final BlockState defaultBlock;
    private final BlockState defaultFluid;
    private final Optional<Climate.Sampler> surfaceNoiseGetter;
    private final Optional<TFTerrainWarp> warper;
    public final ConcurrentHashMap<ChunkPos, TFFeature> featureCache = new ConcurrentHashMap();
    private static final BlockState[] EMPTY_COLUMN = new BlockState[0];

    public ChunkGeneratorTwilight(ChunkGenerator delegate, Registry<StructureSet> structures, Holder<NoiseGeneratorSettings> noiseGenSettings, boolean genDarkForestCanopy, boolean monsterSpawnsBelowSeaLevel, Optional<Integer> darkForestCanopyHeight, boolean owSeed) {
        super(structures, owSeed ? (delegate = delegate.m_6819_(TwilightFeatures.seed)) : delegate);
        this.noiseGeneratorSettings = noiseGenSettings;
        this.genDarkForestCanopy = genDarkForestCanopy;
        this.monsterSpawnsBelowSeaLevel = monsterSpawnsBelowSeaLevel;
        this.darkForestCanopyHeight = darkForestCanopyHeight;
        if (delegate instanceof NoiseBasedChunkGenerator) {
            NoiseBasedChunkGenerator noiseGen = (NoiseBasedChunkGenerator)delegate;
            this.defaultBlock = noiseGen.f_64316_;
            this.defaultFluid = ((NoiseGeneratorSettings)noiseGenSettings.m_203334_()).f_64441_();
            this.surfaceNoiseGetter = Optional.of(noiseGen.f_158382_);
        } else {
            this.defaultBlock = Blocks.f_50069_.m_49966_();
            this.defaultFluid = Blocks.f_49990_.m_49966_();
            this.surfaceNoiseGetter = Optional.empty();
        }
        NoiseSettings settings = ((NoiseGeneratorSettings)noiseGenSettings.m_203334_()).f_64439_();
        BiomeSource biomeSource = delegate.m_62218_();
        if (biomeSource instanceof TFBiomeProvider) {
            TFBiomeProvider source = (TFBiomeProvider)biomeSource;
            WorldgenRandom random = new WorldgenRandom((RandomSource)new LegacyRandomSource(delegate.f_212255_));
            TFBlendedNoise blendedNoise = new TFBlendedNoise((RandomSource)random, settings.f_64509_(), settings.m_189213_(), settings.m_189212_());
            NoiseModifier modifier = NoiseModifier.PASS;
            this.warper = Optional.of(new TFTerrainWarp(settings.m_189213_(), settings.m_189212_(), settings.m_189216_(), source, settings, blendedNoise, modifier));
        } else {
            this.warper = Optional.empty();
        }
    }

    protected Codec<? extends ChunkGenerator> m_6909_() {
        return CODEC;
    }

    @Override
    public ChunkGenerator m_6819_(long newSeed) {
        return new ChunkGeneratorTwilight(this.delegate.m_6819_(newSeed), (Registry<StructureSet>)this.f_207955_, this.noiseGeneratorSettings, this.genDarkForestCanopy, this.monsterSpawnsBelowSeaLevel, this.darkForestCanopyHeight, false);
    }

    @Override
    public int m_142647_(int x, int z, Heightmap.Types heightMap, LevelHeightAccessor level) {
        if (this.warper.isEmpty()) {
            return super.m_142647_(x, z, heightMap, level);
        }
        NoiseSettings settings = ((NoiseGeneratorSettings)this.noiseGeneratorSettings.m_203334_()).f_64439_();
        int minY = Math.max(settings.f_158688_(), level.m_141937_());
        int maxY = Math.min(settings.f_158688_() + settings.f_64508_(), level.m_151558_());
        int minCell = Mth.m_14042_((int)minY, (int)settings.m_189212_());
        int maxCell = Mth.m_14042_((int)(maxY - minY), (int)settings.m_189212_());
        return maxCell <= 0 ? level.m_141937_() : this.iterateNoiseColumn(x, z, null, heightMap.m_64299_(), minCell, maxCell).orElse(level.m_141937_());
    }

    @Override
    public NoiseColumn m_141914_(int x, int z, LevelHeightAccessor level) {
        if (this.warper.isEmpty()) {
            return super.m_141914_(x, z, level);
        }
        NoiseSettings settings = ((NoiseGeneratorSettings)this.noiseGeneratorSettings.m_203334_()).f_64439_();
        int minY = Math.max(settings.f_158688_(), level.m_141937_());
        int maxY = Math.min(settings.f_158688_() + settings.f_64508_(), level.m_151558_());
        int minCell = Mth.m_14042_((int)minY, (int)settings.m_189212_());
        int maxCell = Mth.m_14042_((int)(maxY - minY), (int)settings.m_189212_());
        if (maxCell <= 0) {
            return new NoiseColumn(minY, EMPTY_COLUMN);
        }
        BlockState[] ablockstate = new BlockState[maxCell * settings.m_189212_()];
        this.iterateNoiseColumn(x, z, ablockstate, null, minCell, maxCell);
        return new NoiseColumn(minY, ablockstate);
    }

    protected OptionalInt iterateNoiseColumn(int x, int z, BlockState[] states, Predicate<BlockState> predicate, int min, int max) {
        NoiseSettings settings = ((NoiseGeneratorSettings)this.noiseGeneratorSettings.m_203334_()).f_64439_();
        int cellWidth = settings.m_189213_();
        int cellHeight = settings.m_189212_();
        int xDiv = Math.floorDiv(x, cellWidth);
        int zDiv = Math.floorDiv(z, cellWidth);
        int xMod = Math.floorMod(x, cellWidth);
        int zMod = Math.floorMod(z, cellWidth);
        int xMin = xMod / cellWidth;
        int zMin = zMod / cellWidth;
        double[][] columns = new double[][]{this.makeAndFillNoiseColumn(xDiv, zDiv, min, max), this.makeAndFillNoiseColumn(xDiv, zDiv + 1, min, max), this.makeAndFillNoiseColumn(xDiv + 1, zDiv, min, max), this.makeAndFillNoiseColumn(xDiv + 1, zDiv + 1, min, max)};
        for (int cell = max - 1; cell >= 0; --cell) {
            double d00 = columns[0][cell];
            double d10 = columns[1][cell];
            double d20 = columns[2][cell];
            double d30 = columns[3][cell];
            double d01 = columns[0][cell + 1];
            double d11 = columns[1][cell + 1];
            double d21 = columns[2][cell + 1];
            double d31 = columns[3][cell + 1];
            for (int height = cellHeight - 1; height >= 0; --height) {
                double dcell = (double)height / (double)cellHeight;
                double lcell = Mth.m_14019_((double)dcell, (double)xMin, (double)zMin, (double)d00, (double)d01, (double)d20, (double)d21, (double)d10, (double)d11, (double)d30, (double)d31);
                int layer = cell * cellHeight + height;
                int maxlayer = layer + min * cellHeight;
                BlockState state = this.generateBaseState(lcell, layer);
                if (states != null) {
                    states[layer] = state;
                }
                if (predicate == null || !predicate.test(state)) continue;
                return OptionalInt.of(maxlayer + 1);
            }
        }
        return OptionalInt.empty();
    }

    @Override
    public CompletableFuture<ChunkAccess> m_196423_(Registry<Biome> biomes, Executor executor, Blender blender, StructureFeatureManager manager, ChunkAccess chunkAccess) {
        return CompletableFuture.supplyAsync(Util.m_183946_((String)"init_biomes", () -> {
            chunkAccess.m_183442_((BiomeResolver)this.m_62218_(), this.m_183403_());
            return chunkAccess;
        }), Util.m_183991_());
    }

    @Override
    public CompletableFuture<ChunkAccess> m_183489_(Executor executor, Blender blender, StructureFeatureManager structureManager, ChunkAccess chunkAccess) {
        if (this.warper.isEmpty()) {
            return super.m_183489_(executor, blender, structureManager, chunkAccess);
        }
        NoiseSettings settings = ((NoiseGeneratorSettings)this.noiseGeneratorSettings.m_203334_()).f_64439_();
        int cellHeight = settings.m_189212_();
        int minY = Math.max(settings.f_158688_(), chunkAccess.m_141937_());
        int maxY = Math.min(settings.f_158688_() + settings.f_64508_(), chunkAccess.m_151558_());
        int mincell = Mth.m_14042_((int)minY, (int)cellHeight);
        int maxcell = Mth.m_14042_((int)(maxY - minY), (int)cellHeight);
        if (maxcell <= 0) {
            return CompletableFuture.completedFuture(chunkAccess);
        }
        int maxIndex = chunkAccess.m_151564_(maxcell * cellHeight - 1 + minY);
        int minIndex = chunkAccess.m_151564_(minY);
        HashSet sections = Sets.newHashSet();
        for (int index = maxIndex; index >= minIndex; --index) {
            LevelChunkSection section = chunkAccess.m_183278_(index);
            section.m_62981_();
            sections.add(section);
        }
        return CompletableFuture.supplyAsync(() -> this.doFill(chunkAccess, mincell, maxcell), Util.m_183991_()).whenCompleteAsync((chunk, throwable) -> {
            for (LevelChunkSection section : sections) {
                section.m_63006_();
            }
        }, executor);
    }

    private ChunkAccess doFill(ChunkAccess access, int min, int max) {
        NoiseSettings settings = ((NoiseGeneratorSettings)this.noiseGeneratorSettings.m_203334_()).f_64439_();
        int cellWidth = settings.m_189213_();
        int cellHeight = settings.m_189212_();
        int cellCountX = 16 / cellWidth;
        int cellCountZ = 16 / cellWidth;
        Heightmap oceanfloor = access.m_6005_(Heightmap.Types.OCEAN_FLOOR_WG);
        Heightmap surface = access.m_6005_(Heightmap.Types.WORLD_SURFACE_WG);
        ChunkPos chunkpos = access.m_7697_();
        int minX = chunkpos.m_45604_();
        int minZ = chunkpos.m_45605_();
        TFNoiseInterpolator interpolator = new TFNoiseInterpolator(cellCountX, max, cellCountZ, chunkpos, min, this::fillNoiseColumn);
        ArrayList list = Lists.newArrayList((Object[])new TFNoiseInterpolator[]{interpolator});
        list.forEach(TFNoiseInterpolator::initialiseFirstX);
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        for (int cellX = 0; cellX < cellCountX; ++cellX) {
            int advX = cellX;
            list.forEach(noiseint -> noiseint.advanceX(advX));
            for (int cellZ = 0; cellZ < cellCountZ; ++cellZ) {
                LevelChunkSection section = access.m_183278_(access.m_151559_() - 1);
                for (int cellY = max - 1; cellY >= 0; --cellY) {
                    int advY = cellY;
                    int advZ = cellZ;
                    list.forEach(noiseint -> noiseint.selectYZ(advY, advZ));
                    for (int height = cellHeight - 1; height >= 0; --height) {
                        int minheight = (min + cellY) * cellHeight + height;
                        int mincellY = minheight & 0xF;
                        int minindexY = access.m_151564_(minheight);
                        if (access.m_151564_(section.m_63017_()) != minindexY) {
                            section = access.m_183278_(minindexY);
                        }
                        double heightdiv = (double)height / (double)cellHeight;
                        list.forEach(noiseint -> noiseint.updateY(heightdiv));
                        for (int widthX = 0; widthX < cellWidth; ++widthX) {
                            int minwidthX = minX + cellX * cellWidth + widthX;
                            int mincellX = minwidthX & 0xF;
                            double widthdivX = (double)widthX / (double)cellWidth;
                            list.forEach(noiseint -> noiseint.updateX(widthdivX));
                            for (int widthZ = 0; widthZ < cellWidth; ++widthZ) {
                                int minwidthZ = minZ + cellZ * cellWidth + widthZ;
                                int mincellZ = minwidthZ & 0xF;
                                double widthdivZ = (double)widthZ / (double)cellWidth;
                                double noiseval = interpolator.updateZ(widthdivZ);
                                BlockState state = this.generateBaseState(noiseval, minheight);
                                if (state == Blocks.f_50016_.m_49966_()) continue;
                                if (state.m_60791_() != 0 && access instanceof ProtoChunk) {
                                    ProtoChunk proto = (ProtoChunk)access;
                                    mutable.m_122178_(minwidthX, minheight, minwidthZ);
                                    proto.m_63277_((BlockPos)mutable);
                                }
                                section.m_62991_(mincellX, mincellY, mincellZ, state, false);
                                oceanfloor.m_64249_(mincellX, minheight, mincellZ, state);
                                surface.m_64249_(mincellX, minheight, mincellZ, state);
                            }
                        }
                    }
                }
            }
            list.forEach(TFNoiseInterpolator::swapSlices);
        }
        return access;
    }

    private double[] makeAndFillNoiseColumn(int x, int z, int min, int max) {
        double[] columns = new double[max + 1];
        this.fillNoiseColumn(columns, x, z, min, max);
        return columns;
    }

    private void fillNoiseColumn(double[] columns, int x, int z, int min, int max) {
        NoiseSettings settings = ((NoiseGeneratorSettings)this.noiseGeneratorSettings.m_203334_()).f_64439_();
        this.warper.get().fillNoiseColumn(this, columns, x, z, settings, this.m_6337_(), min, max);
    }

    private BlockState generateBaseState(double noiseVal, double level) {
        BlockState state = noiseVal > 0.0 ? this.defaultBlock : (level < (double)this.m_6337_() ? this.defaultFluid : Blocks.f_50016_.m_49966_());
        return state;
    }

    @Override
    public void m_183621_(WorldGenRegion world, StructureFeatureManager manager, ChunkAccess chunk) {
        this.deformTerrainForFeature(world, chunk);
        super.m_183621_(world, manager, chunk);
        if (this.darkForestCanopyHeight.isPresent()) {
            this.addDarkForestCanopy(world, chunk, this.darkForestCanopyHeight.get());
        }
        this.addGlaciers(world, chunk);
    }

    private void addGlaciers(WorldGenRegion primer, ChunkAccess chunk) {
        BlockState glacierBase = Blocks.f_49994_.m_49966_();
        BlockState glacierMain = Blocks.f_50354_.m_49966_();
        BlockState glacierTop = Blocks.f_50126_.m_49966_();
        for (int z = 0; z < 16; ++z) {
            for (int x = 0; x < 16; ++x) {
                Optional biome = primer.m_204166_(primer.m_143488_().m_45615_().m_142082_(x, 0, z)).m_203543_();
                if (biome.isEmpty() || !BiomeKeys.GLACIER.m_135782_().equals((Object)((ResourceKey)biome.get()).m_135782_())) continue;
                int gBase = -1;
                for (int y = 127; y >= 0; --y) {
                    Block currentBlock = primer.m_8055_(this.withY(primer.m_143488_().m_45615_().m_142082_(x, 0, z), y)).m_60734_();
                    if (currentBlock != Blocks.f_50069_) continue;
                    gBase = y;
                    primer.m_7731_(this.withY(primer.m_143488_().m_45615_().m_142082_(x, 0, z), y), glacierBase, 3);
                    break;
                }
                int gHeight = 32;
                int gTop = Math.min(gBase + gHeight, 127);
                for (int y = gBase; y < gTop; ++y) {
                    primer.m_7731_(this.withY(primer.m_143488_().m_45615_().m_142082_(x, 0, z), y), glacierMain, 3);
                }
                primer.m_7731_(this.withY(primer.m_143488_().m_45615_().m_142082_(x, 0, z), gTop), glacierTop, 3);
            }
        }
    }

    public void m_207076_(List<String> p_208054_, BlockPos p_208055_) {
    }

    protected final void deformTerrainForFeature(WorldGenRegion primer, ChunkAccess chunk) {
        IntPair featureRelativePos = new IntPair();
        TFFeature nearFeature = TFFeature.getNearestFeature(primer.m_143488_().f_45578_, primer.m_143488_().f_45579_, (WorldGenLevel)primer, featureRelativePos);
        if (!nearFeature.requiresTerraforming) {
            return;
        }
        int relativeFeatureX = featureRelativePos.x;
        int relativeFeatureZ = featureRelativePos.z;
        if (TFFeature.isTheseFeatures(nearFeature, TFFeature.SMALL_HILL, TFFeature.MEDIUM_HILL, TFFeature.LARGE_HILL, TFFeature.HYDRA_LAIR)) {
            int hdiam = (nearFeature.size * 2 + 1) * 16;
            for (int xInChunk = 0; xInChunk < 16; ++xInChunk) {
                for (int zInChunk = 0; zInChunk < 16; ++zInChunk) {
                    int featureDX = xInChunk - relativeFeatureX;
                    int featureDZ = zInChunk - relativeFeatureZ;
                    float dist = (int)Mth.m_14116_((float)(featureDX * featureDX + featureDZ * featureDZ));
                    float hheight = (int)(Mth.m_14089_((float)(dist / (float)hdiam * (float)Math.PI)) * ((float)hdiam / 3.0f));
                    this.raiseHills(primer, chunk, nearFeature, hdiam, xInChunk, zInChunk, featureDX, featureDZ, hheight);
                }
            }
        } else if (nearFeature == TFFeature.HEDGE_MAZE || nearFeature == TFFeature.NAGA_COURTYARD || nearFeature == TFFeature.QUEST_GROVE) {
            for (int xInChunk = 0; xInChunk < 16; ++xInChunk) {
                for (int zInChunk = 0; zInChunk < 16; ++zInChunk) {
                    int featureDX = xInChunk - relativeFeatureX;
                    int featureDZ = zInChunk - relativeFeatureZ;
                    this.flattenTerrainForFeature(primer, nearFeature, xInChunk, zInChunk, featureDX, featureDZ);
                }
            }
        } else if (nearFeature == TFFeature.YETI_CAVE) {
            for (int xInChunk = 0; xInChunk < 16; ++xInChunk) {
                for (int zInChunk = 0; zInChunk < 16; ++zInChunk) {
                    int featureDX = xInChunk - relativeFeatureX;
                    int featureDZ = zInChunk - relativeFeatureZ;
                    this.deformTerrainForYetiLair(primer, nearFeature, xInChunk, zInChunk, featureDX, featureDZ);
                }
            }
        } else if (nearFeature == TFFeature.TROLL_CAVE) {
            this.deformTerrainForTrollCloud2(primer, chunk, nearFeature, relativeFeatureX, relativeFeatureZ);
        }
    }

    private void flattenTerrainForFeature(WorldGenRegion primer, TFFeature nearFeature, int x, int z, int dx, int dz) {
        BlockState b;
        int y;
        float squishFactor = 0.0f;
        int mazeHeight = 2;
        int FEATURE_BOUNDARY = (nearFeature.size * 2 + 1) * 8 - 8;
        if (dx <= -FEATURE_BOUNDARY) {
            squishFactor = (float)(-dx - FEATURE_BOUNDARY) / 8.0f;
        } else if (dx >= FEATURE_BOUNDARY) {
            squishFactor = (float)(dx - FEATURE_BOUNDARY) / 8.0f;
        }
        if (dz <= -FEATURE_BOUNDARY) {
            squishFactor = Math.max(squishFactor, (float)(-dz - FEATURE_BOUNDARY) / 8.0f);
        } else if (dz >= FEATURE_BOUNDARY) {
            squishFactor = Math.max(squishFactor, (float)(dz - FEATURE_BOUNDARY) / 8.0f);
        }
        if (squishFactor > 0.0f) {
            for (y = 0; y <= 127; ++y) {
                Block currentTerrain = primer.m_8055_(this.withY(primer.m_143488_().m_45615_().m_142082_(x, 0, z), y)).m_60734_();
                if (currentTerrain == Blocks.f_50069_) continue;
                mazeHeight = (int)((float)mazeHeight + (float)(y - mazeHeight) * squishFactor);
                break;
            }
        }
        for (y = 0; y < mazeHeight; ++y) {
            b = primer.m_8055_(this.withY(primer.m_143488_().m_45615_().m_142082_(x, 0, z), y));
            if (primer.m_204166_(this.withY(primer.m_143488_().m_45615_().m_142082_(x, 0, z), y)).m_203565_(BiomeKeys.STREAM) || !b.m_60795_() && !b.m_60767_().m_76332_()) continue;
            primer.m_7731_(this.withY(primer.m_143488_().m_45615_().m_142082_(x, 0, z), y), Blocks.f_50069_.m_49966_(), 3);
        }
        for (y = mazeHeight; y <= 127; ++y) {
            b = primer.m_8055_(this.withY(primer.m_143488_().m_45615_().m_142082_(x, 0, z), y));
            if (primer.m_204166_(this.withY(primer.m_143488_().m_45615_().m_142082_(x, 0, z), y)).m_203565_(BiomeKeys.STREAM) || b.m_60795_() || b.m_60767_().m_76332_()) continue;
            primer.m_7731_(this.withY(primer.m_143488_().m_45615_().m_142082_(x, 0, z), y), Blocks.f_50016_.m_49966_(), 3);
        }
    }

    protected final BlockPos withY(BlockPos old, int y) {
        return new BlockPos(old.m_123341_(), y, old.m_123343_());
    }

    private void deformTerrainForTrollCloud2(WorldGenRegion primer, ChunkAccess chunkAccess, TFFeature nearFeature, int hx, int hz) {
        for (int bx = 0; bx < 4; ++bx) {
            for (int bz = 0; bz < 4; ++bz) {
                int dx = bx * 4 - hx - 2;
                int dz = bz * 4 - hz - 2;
                int regionX = primer.m_143488_().f_45578_ + 8 >> 4;
                int regionZ = primer.m_143488_().f_45579_ + 8 >> 4;
                long seed = (long)regionX * 3129871L ^ (long)regionZ * 116129781L;
                seed = seed * seed * 42317861L + seed * 7L;
                int num0 = (int)(seed >> 12 & 3L);
                int num1 = (int)(seed >> 15 & 3L);
                int num2 = (int)(seed >> 18 & 3L);
                int num3 = (int)(seed >> 21 & 3L);
                int num4 = (int)(seed >> 9 & 3L);
                int num5 = (int)(seed >> 6 & 3L);
                int num6 = (int)(seed >> 3 & 3L);
                int num7 = (int)(seed >> 0 & 3L);
                int dx2 = dx + num0 * 5 - num1 * 4;
                int dz2 = dz + num2 * 4 - num3 * 5;
                int dx3 = dx + num4 * 5 - num5 * 4;
                int dz3 = dz + num6 * 4 - num7 * 5;
                float dist0 = Mth.m_14116_((float)(dx * dx + dz * dz)) / 4.0f;
                float dist2 = Mth.m_14116_((float)(dx2 * dx2 + dz2 * dz2)) / 3.5f;
                float dist3 = Mth.m_14116_((float)(dx3 * dx3 + dz3 * dz3)) / 4.5f;
                double dist = Math.min(dist0, Math.min(dist2, dist3));
                float pr = primer.m_5822_().nextFloat();
                double cv = dist - 7.0 - (double)(pr * 3.0f);
                int y = 166;
                int depth = 4;
                if (pr < 0.1f) {
                    ++y;
                }
                if (pr > 0.6f) {
                    ++depth;
                }
                if (pr > 0.9f) {
                    ++depth;
                }
                for (int sx = 0; sx < 4; ++sx) {
                    for (int sz = 0; sz < 4; ++sz) {
                        int lx = bx * 4 + sx;
                        int lz = bz * 4 + sz;
                        BlockPos.MutableBlockPos movingPos = primer.m_143488_().m_45615_().m_122032_().m_122184_(lx, 0, lz);
                        int dY = primer.m_6924_(Heightmap.Types.WORLD_SURFACE_WG, movingPos.m_123341_(), movingPos.m_123343_());
                        int oceanFloor = primer.m_6924_(Heightmap.Types.OCEAN_FLOOR_WG, movingPos.m_123341_(), movingPos.m_123343_());
                        if (dist < 7.0 || cv < (double)0.05f) {
                            primer.m_7731_((BlockPos)movingPos.m_142448_(y), ((Block)TFBlocks.WISPY_CLOUD.get()).m_49966_(), 3);
                            for (d = 1; d < depth; ++d) {
                                primer.m_7731_((BlockPos)movingPos.m_142448_(y - d), ((Block)TFBlocks.FLUFFY_CLOUD.get()).m_49966_(), 3);
                            }
                            primer.m_7731_((BlockPos)movingPos.m_142448_(y - depth), ((Block)TFBlocks.WISPY_CLOUD.get()).m_49966_(), 3);
                        } else if (dist < 8.0 || cv < 1.0) {
                            for (d = 1; d < depth; ++d) {
                                primer.m_7731_((BlockPos)movingPos.m_142448_(y - d), ((Block)TFBlocks.FLUFFY_CLOUD.get()).m_49966_(), 3);
                            }
                        }
                        ChunkGeneratorTwilight.forceHeightMapLevel(chunkAccess, Heightmap.Types.WORLD_SURFACE_WG, (BlockPos)movingPos, dY);
                        ChunkGeneratorTwilight.forceHeightMapLevel(chunkAccess, Heightmap.Types.WORLD_SURFACE, (BlockPos)movingPos, dY);
                        ChunkGeneratorTwilight.forceHeightMapLevel(chunkAccess, Heightmap.Types.OCEAN_FLOOR_WG, (BlockPos)movingPos, oceanFloor);
                        ChunkGeneratorTwilight.forceHeightMapLevel(chunkAccess, Heightmap.Types.OCEAN_FLOOR, (BlockPos)movingPos, oceanFloor);
                    }
                }
            }
        }
    }

    private void raiseHills(WorldGenRegion world, ChunkAccess chunk, TFFeature nearFeature, int hdiam, int xInChunk, int zInChunk, int featureDX, int featureDZ, float hillHeight) {
        BlockPos.MutableBlockPos movingPos = world.m_143488_().m_45615_().m_142082_(xInChunk, 0, zInChunk).m_122032_();
        int groundHeight = chunk.m_5885_(Heightmap.Types.OCEAN_FLOOR_WG, movingPos.m_123341_(), movingPos.m_123343_());
        float noiseRaw = this.surfaceNoiseGetter.map(ns -> Float.valueOf(0.0f)).orElse(Float.valueOf(0.0f)).floatValue();
        float totalHeightRaw = (float)groundHeight * 0.75f + (float)this.m_6337_() * 0.25f + hillHeight + noiseRaw;
        int totalHeight = (int)((float)((int)totalHeightRaw >> 1) * 0.375f + totalHeightRaw * 0.625f);
        for (int y = groundHeight; y <= totalHeight; ++y) {
            world.m_7731_((BlockPos)movingPos.m_142448_(y), this.defaultBlock, 3);
        }
        int hollow = Math.min((int)hillHeight - 4 - nearFeature.size, totalHeight - 3);
        if (nearFeature == TFFeature.HYDRA_LAIR) {
            int mx = featureDX + 16;
            int mz = featureDZ + 16;
            int mdist = (int)Mth.m_14116_((float)(mx * mx + mz * mz));
            int mheight = (int)(Mth.m_14089_((float)((float)mdist / ((float)hdiam / 1.5f) * (float)Math.PI)) * ((float)hdiam / 1.5f));
            hollow = Math.max(mheight - 4, hollow);
        }
        int hollowFloor = nearFeature == TFFeature.HYDRA_LAIR ? this.m_6337_() : this.m_6337_() - 5 - (hollow >> 3);
        for (int y = hollowFloor + 1; y < hollowFloor + hollow; ++y) {
            world.m_7731_((BlockPos)movingPos.m_142448_(y), Blocks.f_50016_.m_49966_(), 3);
        }
    }

    private void deformTerrainForYetiLair(WorldGenRegion primer, TFFeature nearFeature, int xInChunk, int zInChunk, int featureDX, int featureDZ) {
        int y;
        float squishFactor = 0.0f;
        int topHeight = this.m_6337_() + 24;
        int outerBoundary = (nearFeature.size * 2 + 1) * 8 - 8;
        if (featureDX <= -outerBoundary) {
            squishFactor = (float)(-featureDX - outerBoundary) / 8.0f;
        } else if (featureDX >= outerBoundary) {
            squishFactor = (float)(featureDX - outerBoundary) / 8.0f;
        }
        if (featureDZ <= -outerBoundary) {
            squishFactor = Math.max(squishFactor, (float)(-featureDZ - outerBoundary) / 8.0f);
        } else if (featureDZ >= outerBoundary) {
            squishFactor = Math.max(squishFactor, (float)(featureDZ - outerBoundary) / 8.0f);
        }
        int caveBoundary = nearFeature.size * 2 * 8 - 8;
        int offset = Math.min(Math.abs(featureDX), Math.abs(featureDZ));
        int hollowCeiling = this.m_6337_() + 40 - offset * 4;
        if (featureDX >= -caveBoundary && featureDZ >= -caveBoundary && featureDX <= caveBoundary && featureDZ <= caveBoundary) {
            hollowCeiling = this.m_6337_() + 16;
        }
        hollowCeiling -= offset / 6;
        hollowCeiling = Math.min(hollowCeiling, this.m_6337_() + 16);
        int hollowFloor = this.m_6337_() - 4 + offset / 6;
        BlockPos.MutableBlockPos movingPos = primer.m_143488_().m_45615_().m_142082_(xInChunk, 0, zInChunk).m_122032_();
        if (squishFactor > 0.0f) {
            for (y = primer.m_141937_(); y <= primer.m_151558_(); ++y) {
                if (this.defaultBlock.equals(primer.m_8055_((BlockPos)movingPos.m_142448_(y)))) continue;
                topHeight = (int)((float)topHeight + (float)(y - topHeight) * squishFactor);
                hollowFloor = (int)((float)hollowFloor + (float)(y - hollowFloor) * squishFactor);
                break;
            }
        }
        for (y = primer.m_141937_(); y < topHeight; ++y) {
            Block b = primer.m_8055_((BlockPos)movingPos.m_142448_(y)).m_60734_();
            if (b != Blocks.f_50016_ && b != Blocks.f_49990_) continue;
            primer.m_7731_((BlockPos)movingPos.m_142448_(y), this.defaultBlock, 3);
        }
        for (y = hollowFloor + 1; y < hollowCeiling; ++y) {
            primer.m_7731_((BlockPos)movingPos.m_142448_(y), Blocks.f_50016_.m_49966_(), 3);
        }
        if (hollowFloor < hollowCeiling && hollowFloor < this.m_6337_() + 3) {
            primer.m_7731_((BlockPos)movingPos.m_142448_(hollowFloor), Blocks.f_50354_.m_49966_(), 3);
        }
    }

    private void addDarkForestCanopy(WorldGenRegion primer, ChunkAccess chunk, int height) {
        BlockPos blockpos = primer.m_143488_().m_45615_();
        int[] thicks = new int[25];
        boolean biomeFound = false;
        for (int dZ = 0; dZ < 5; ++dZ) {
            for (int dX = 0; dX < 5; ++dX) {
                for (int bx = -1; bx <= 1; ++bx) {
                    for (int bz = -1; bz <= 1; ++bz) {
                        BlockPos p = blockpos.m_142082_(dX + bx << 2, 0, dZ + bz << 2);
                        Biome biome = (Biome)this.f_62137_.m_203407_(p.m_123341_() >> 2, 0, p.m_123343_() >> 2, null).m_203334_();
                        if (!BiomeKeys.DARK_FOREST.m_135782_().equals((Object)biome.getRegistryName()) && !BiomeKeys.DARK_FOREST_CENTER.m_135782_().equals((Object)biome.getRegistryName())) continue;
                        int n = dX + dZ * 5;
                        thicks[n] = thicks[n] + 1;
                        biomeFound = true;
                    }
                }
            }
        }
        if (!biomeFound) {
            return;
        }
        IntPair nearCenter = new IntPair();
        TFFeature nearFeature = TFFeature.getNearestFeature(primer.m_143488_().f_45578_, primer.m_143488_().f_45579_, (WorldGenLevel)primer, nearCenter);
        double d = 0.03125;
        for (int dZ = 0; dZ < 16; ++dZ) {
            for (int dX = 0; dX < 16; ++dX) {
                int hz;
                int rz;
                int hx;
                int rx;
                int dist;
                int qx = dX >> 2;
                int qz = dZ >> 2;
                float xweight = (float)(dX % 4) * 0.25f + 0.125f;
                float zweight = (float)(dZ % 4) * 0.25f + 0.125f;
                float thickness = (float)thicks[qx + qz * 5] * (1.0f - xweight) * (1.0f - zweight) + (float)thicks[qx + 1 + qz * 5] * xweight * (1.0f - zweight) + (float)thicks[qx + (qz + 1) * 5] * (1.0f - xweight) * zweight + (float)thicks[qx + 1 + (qz + 1) * 5] * xweight * zweight - 4.0f;
                if (nearFeature == TFFeature.DARK_TOWER && (dist = (int)Mth.m_14116_((float)((rx = dX - (hx = nearCenter.x)) * rx + (rz = dZ - (hz = nearCenter.z)) * rz))) < 24) {
                    thickness -= (float)(24 - dist);
                }
                if (!(thickness > 1.0f)) continue;
                int dY = chunk.m_5885_(Heightmap.Types.WORLD_SURFACE_WG, dX, dZ);
                int oceanFloor = chunk.m_5885_(Heightmap.Types.OCEAN_FLOOR_WG, dX, dZ);
                BlockPos pos = primer.m_143488_().m_45615_().m_142082_(dX, dY, dZ);
                if (chunk.m_8055_(pos).m_60767_().m_76332_()) continue;
                int noise = 0;
                int treeBottom = pos.m_123342_() + height - (int)(thickness * 0.5f);
                int treeTop = treeBottom + (int)(thickness * 1.5f);
                BlockState darkLeaves = ((Block)TFBlocks.HARDENED_DARK_LEAVES.get()).m_49966_();
                for (int y = treeBottom -= noise; y < treeTop; ++y) {
                    primer.m_7731_(pos.m_175288_(y), darkLeaves, 3);
                }
                ChunkGeneratorTwilight.forceHeightMapLevel(chunk, Heightmap.Types.WORLD_SURFACE_WG, pos, dY);
                ChunkGeneratorTwilight.forceHeightMapLevel(chunk, Heightmap.Types.WORLD_SURFACE, pos, dY);
                ChunkGeneratorTwilight.forceHeightMapLevel(chunk, Heightmap.Types.OCEAN_FLOOR_WG, pos, oceanFloor);
                ChunkGeneratorTwilight.forceHeightMapLevel(chunk, Heightmap.Types.OCEAN_FLOOR, pos, oceanFloor);
            }
        }
    }

    static void forceHeightMapLevel(ChunkAccess chunk, Heightmap.Types type, BlockPos pos, int dY) {
        chunk.m_6005_(type).m_64245_(pos.m_123341_() & 0xF, pos.m_123343_() & 0xF, dY + 1);
    }

    @Override
    public WeightedRandomList<MobSpawnSettings.SpawnerData> m_203315_(Holder<Biome> biome, StructureFeatureManager structureManager, MobCategory mobCategory, BlockPos pos) {
        if (!this.monsterSpawnsBelowSeaLevel) {
            return super.m_203315_(biome, structureManager, mobCategory, pos);
        }
        List<MobSpawnSettings.SpawnerData> potentialStructureSpawns = TFStructureStart.gatherPotentialSpawns(structureManager, mobCategory, pos);
        if (potentialStructureSpawns != null) {
            return WeightedRandomList.m_146328_(potentialStructureSpawns);
        }
        return mobCategory == MobCategory.MONSTER && pos.m_123342_() >= this.m_6337_() ? WeightedRandomList.m_146332_() : super.m_203315_(biome, structureManager, mobCategory, pos);
    }

    public TFFeature getFeatureCached(ChunkPos chunk, WorldGenLevel world) {
        return this.featureCache.computeIfAbsent(chunk, chunkPos -> TFFeature.generateFeature(chunkPos.f_45578_, chunkPos.f_45579_, world));
    }
}

