/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.util;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.data.worldgen.biome.OverworldBiomes;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.ChunkSource;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.AABB;
import twilightforest.world.components.chunkgenerators.ChunkGeneratorTwilight;

public final class WorldUtil {
    private WorldUtil() {
    }

    public static Biome voidFallback() {
        return OverworldBiomes.m_194913_();
    }

    public static Iterable<BlockPos> getAllAround(BlockPos center, int range) {
        return BlockPos.m_121940_((BlockPos)center.m_142082_(-range, -range, -range), (BlockPos)center.m_142082_(range, range, range));
    }

    public static Iterable<BlockPos> getAllInBB(AABB bb) {
        return BlockPos.m_121976_((int)((int)bb.f_82288_), (int)((int)bb.f_82289_), (int)((int)bb.f_82290_), (int)((int)bb.f_82291_), (int)((int)bb.f_82292_), (int)((int)bb.f_82293_));
    }

    public static BlockPos randomOffset(Random random, BlockPos pos, int range) {
        return WorldUtil.randomOffset(random, pos, range, range, range);
    }

    public static BlockPos randomOffset(Random random, BlockPos pos, int rx, int ry, int rz) {
        int dx = random.nextInt(rx * 2 + 1) - rx;
        int dy = random.nextInt(ry * 2 + 1) - ry;
        int dz = random.nextInt(rz * 2 + 1) - rz;
        return pos.m_142082_(dx, dy, dz);
    }

    @Nullable
    public static ChunkGeneratorTwilight getChunkGenerator(LevelAccessor level) {
        ChunkSource chunkSource = level.m_7726_();
        if (chunkSource instanceof ServerChunkCache) {
            ServerChunkCache chunkSource2 = (ServerChunkCache)chunkSource;
            chunkSource = chunkSource2.f_8325_.m_183719_();
            if (chunkSource instanceof ChunkGeneratorTwilight) {
                ChunkGeneratorTwilight chunkGenerator = (ChunkGeneratorTwilight)chunkSource;
                return chunkGenerator;
            }
        }
        return null;
    }

    public static int getSeaLevel(ChunkGenerator generator) {
        if (generator instanceof ChunkGeneratorTwilight) {
            return generator.m_6337_();
        }
        return 0;
    }

    public static int getBaseHeight(LevelAccessor level, int x, int z, Heightmap.Types type) {
        ChunkSource chunkSource = level.m_7726_();
        if (chunkSource instanceof ServerChunkCache) {
            ServerChunkCache chunkSource2 = (ServerChunkCache)chunkSource;
            return chunkSource2.f_8325_.m_183719_().m_142647_(x, z, type, (LevelHeightAccessor)level);
        }
        return level.m_6924_(type, x, z);
    }
}

