/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Predicate;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TieredItem;
import net.minecraftforge.items.CapabilityItemHandler;
import twilightforest.TwilightForestMod;

public class TFItemStackUtils {
    public static int damage = 0;

    @Deprecated
    public static boolean consumeInventoryItem(LivingEntity living, Predicate<ItemStack> matcher, int count) {
        TwilightForestMod.LOGGER.warn("consumeInventoryItem accessed! Forge requires the player to be alive before we can access this cap. This cap is most likely being accessed for an Afterdeath Charm!");
        return living.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).map(inv -> {
            int innerCount = count;
            boolean consumedSome = false;
            for (int i = 0; i < inv.getSlots() && innerCount > 0; ++i) {
                ItemStack stack = inv.getStackInSlot(i);
                if (!matcher.test(stack)) continue;
                ItemStack consumed = inv.extractItem(i, innerCount, false);
                innerCount -= consumed.m_41613_();
                consumedSome = true;
            }
            return consumedSome;
        }).orElse(false);
    }

    public static boolean consumeInventoryItem(Player player, Item item) {
        return TFItemStackUtils.consumeInventoryItem((NonNullList<ItemStack>)player.m_150109_().f_35975_, item) || TFItemStackUtils.consumeInventoryItem((NonNullList<ItemStack>)player.m_150109_().f_35974_, item) || TFItemStackUtils.consumeInventoryItem((NonNullList<ItemStack>)player.m_150109_().f_35976_, item);
    }

    public static boolean consumeInventoryItem(NonNullList<ItemStack> stacks, Item item) {
        for (ItemStack stack : stacks) {
            CompoundTag damageNbt;
            if (stack.m_41720_() != item) continue;
            stack.m_41774_(1);
            CompoundTag nbt = stack.m_41784_();
            if (nbt.m_128441_("BlockStateTag") && (damageNbt = nbt.m_128469_("BlockStateTag")).m_128441_("damage")) {
                damage = damageNbt.m_128451_("damage");
            }
            return true;
        }
        return false;
    }

    public static NonNullList<ItemStack> sortArmorForCasket(Player player) {
        NonNullList armor = player.m_150109_().f_35975_;
        Collections.reverse(armor);
        return armor;
    }

    public static NonNullList<ItemStack> sortInvForCasket(Player player) {
        NonNullList inv = player.m_150109_().f_35974_;
        NonNullList sorted = NonNullList.m_122779_();
        sorted.addAll((Collection)inv.subList(9, 36));
        sorted.addAll((Collection)inv.subList(0, 9));
        return sorted;
    }

    public static NonNullList<ItemStack> splitToSize(ItemStack stack) {
        NonNullList result = NonNullList.m_122779_();
        int size = stack.m_41741_();
        while (!stack.m_41619_()) {
            result.add((Object)stack.m_41620_(size));
        }
        return result;
    }

    public static boolean hasToolMaterial(ItemStack stack, Tier tier) {
        HoeItem hoe;
        SwordItem sword;
        TieredItem tieredItem;
        Item item = stack.m_41720_();
        if (item instanceof TieredItem && tier.equals((tieredItem = (TieredItem)item).m_43314_())) {
            return true;
        }
        if (item instanceof SwordItem && tier.equals((sword = (SwordItem)item).m_43314_())) {
            return true;
        }
        return item instanceof HoeItem && tier.equals((hoe = (HoeItem)item).m_43314_());
    }

    public static void clearInfoTag(ItemStack stack, String key) {
        CompoundTag nbt = stack.m_41783_();
        if (nbt != null) {
            nbt.m_128473_(key);
            if (nbt.m_128456_()) {
                stack.m_41751_(null);
            }
        }
    }

    public static void loadNoClear(ListTag tag, Inventory inventory) {
        ArrayList<ItemStack> blockedItems = new ArrayList<ItemStack>();
        for (int i = 0; i < tag.size(); ++i) {
            CompoundTag compoundtag = tag.m_128728_(i);
            int j = compoundtag.m_128445_("Slot") & 0xFF;
            ItemStack itemstack = ItemStack.m_41712_((CompoundTag)compoundtag);
            if (itemstack.m_41619_()) continue;
            if (j < inventory.f_35974_.size()) {
                if (((ItemStack)inventory.f_35974_.get(j)).m_41619_()) {
                    inventory.f_35974_.set(j, (Object)itemstack);
                    continue;
                }
                blockedItems.add(itemstack);
                continue;
            }
            if (j >= 100 && j < inventory.f_35975_.size() + 100) {
                if (((ItemStack)inventory.f_35975_.get(j - 100)).m_41619_()) {
                    inventory.f_35975_.set(j - 100, (Object)itemstack);
                    continue;
                }
                blockedItems.add(itemstack);
                continue;
            }
            if (j < 150 || j >= inventory.f_35976_.size() + 150) continue;
            if (((ItemStack)inventory.f_35976_.get(j - 150)).m_41619_()) {
                inventory.f_35976_.set(j - 150, (Object)itemstack);
                continue;
            }
            blockedItems.add(itemstack);
        }
        if (!blockedItems.isEmpty()) {
            blockedItems.forEach(arg_0 -> ((Inventory)inventory).m_36054_(arg_0));
        }
    }
}

