/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.item;

import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.TierSortingRegistry;
import twilightforest.TFSounds;
import twilightforest.entity.ChainBlock;
import twilightforest.entity.TFEntities;
import twilightforest.util.TwilightItemTier;

public class ChainBlockItem
extends DiggerItem {
    private static final String THROWN_UUID_KEY = "chainEntity";

    protected ChainBlockItem(Item.Properties props) {
        super(6.0f, -3.0f, TwilightItemTier.KNIGHTMETAL, BlockTags.f_13061_, props);
    }

    public void m_6883_(ItemStack stack, Level world, Entity holder, int slot, boolean isSelected) {
        if (!world.f_46443_ && ChainBlockItem.getThrownUuid(stack) != null && ChainBlockItem.getThrownEntity(world, stack) == null) {
            stack.m_41783_().m_128473_(THROWN_UUID_KEY);
        }
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (ChainBlockItem.getThrownUuid(stack) != null) {
            return new InteractionResultHolder(InteractionResult.PASS, (Object)stack);
        }
        player.m_5496_(TFSounds.BLOCKCHAIN_FIRED, 0.5f, 1.0f / (world.f_46441_.nextFloat() * 0.4f + 1.2f));
        if (!world.f_46443_) {
            ChainBlock launchedBlock = new ChainBlock((EntityType<? extends ChainBlock>)((EntityType)TFEntities.CHAIN_BLOCK.get()), world, (LivingEntity)player, hand, stack);
            world.m_7967_((Entity)launchedBlock);
            ChainBlockItem.setThrownEntity(stack, launchedBlock);
            stack.m_41622_(1, (LivingEntity)player, user -> user.m_21190_(hand));
        }
        player.m_6672_(hand);
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
    }

    @Nullable
    protected static UUID getThrownUuid(ItemStack stack) {
        if (stack.m_41782_() && stack.m_41783_().m_128403_(THROWN_UUID_KEY)) {
            return stack.m_41783_().m_128342_(THROWN_UUID_KEY);
        }
        return null;
    }

    @Nullable
    private static ChainBlock getThrownEntity(Level world, ItemStack stack) {
        Entity e;
        UUID id;
        if (world instanceof ServerLevel && (id = ChainBlockItem.getThrownUuid(stack)) != null && (e = ((ServerLevel)world).m_8791_(id)) instanceof ChainBlock) {
            return (ChainBlock)e;
        }
        return null;
    }

    private static void setThrownEntity(ItemStack stack, ChainBlock cube) {
        if (!stack.m_41782_()) {
            stack.m_41751_(new CompoundTag());
        }
        stack.m_41783_().m_128362_(THROWN_UUID_KEY, cube.m_142081_());
    }

    public int m_8105_(ItemStack stack) {
        return 72000;
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.BLOCK;
    }

    public boolean canDisableShield(ItemStack stack, ItemStack shield, LivingEntity entity, LivingEntity attacker) {
        return true;
    }

    public boolean isCorrectToolForDrops(ItemStack stack, BlockState state) {
        if (state.m_204336_(BlockTags.f_144282_) || state.m_204336_(BlockTags.f_144281_) || state.m_204336_(BlockTags.f_144283_) || state.m_204336_(BlockTags.f_144280_)) {
            return TierSortingRegistry.isCorrectTierForDrops((Tier)Tiers.IRON, (BlockState)state);
        }
        return super.isCorrectToolForDrops(stack, state);
    }
}

