/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.phys.Vec3;
import twilightforest.TwilightForestMod;
import twilightforest.client.model.entity.NagaModel;
import twilightforest.entity.boss.Naga;

public class NagaRenderer<M extends NagaModel<Naga>>
extends MobRenderer<Naga, M> {
    private static final ResourceLocation textureLoc = TwilightForestMod.getModelTexture("nagahead.png");
    private static final ResourceLocation textureLocDazed = TwilightForestMod.getModelTexture("nagahead_dazed.png");
    private static final ResourceLocation textureLocCharging = TwilightForestMod.getModelTexture("nagahead_charge.png");
    private int lastTick;

    public NagaRenderer(EntityRendererProvider.Context manager, M modelbase, float shadowSize) {
        super(manager, modelbase, shadowSize);
    }

    public void render(Naga entity, float entityYaw, float partialTicks, PoseStack stack, MultiBufferSource buffer, int light) {
        super.m_7392_((Mob)entity, entityYaw, partialTicks, stack, buffer, light);
        if (!Minecraft.m_91087_().m_91104_() && entity.isDazed() && entity.f_19797_ != this.lastTick) {
            for (int i = 0; i < 5; ++i) {
                Vec3 pos = new Vec3(entity.m_20185_(), entity.m_20186_() + 2.15, entity.m_20189_()).m_82549_(new Vec3(1.5, 0.0, 0.0).m_82524_((float)Math.toRadians(entity.m_21187_().nextInt(360))));
                Minecraft.m_91087_().f_91073_.m_7106_((ParticleOptions)ParticleTypes.f_123797_, pos.f_82479_, pos.f_82480_, pos.f_82481_, 0.0, 0.0, 0.0);
            }
            this.lastTick = entity.f_19797_;
        }
    }

    public ResourceLocation getTextureLocation(Naga entity) {
        if (entity.isDazed()) {
            return textureLocDazed;
        }
        if (entity.isCharging()) {
            return textureLocCharging;
        }
        return textureLoc;
    }
}

