/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.client.model.item;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.pipeline.LightUtil;

public class FullbrightBakedModel
implements BakedModel {
    protected final BakedModel delegate;
    protected final Map<Direction, List<BakedQuad>> cachedQuads = Maps.newHashMap();
    protected boolean cache = true;

    public FullbrightBakedModel(BakedModel delegate) {
        this.delegate = delegate;
    }

    public final FullbrightBakedModel disableCache() {
        this.cache = false;
        return this;
    }

    @Nonnull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand, @Nonnull IModelData extraData) {
        return this.m_6840_(state, side, rand);
    }

    public List<BakedQuad> m_6840_(@Nullable BlockState state, @Nullable Direction side, Random rand) {
        if (this.cache) {
            List<BakedQuad> quads = this.cachedQuads.get(side);
            if (quads == null) {
                quads = this.getQuads(side, this.delegate.m_6840_(state, side, rand));
                this.cachedQuads.put(side, quads);
            }
            return quads;
        }
        return this.getQuads(side, this.delegate.m_6840_(state, side, rand));
    }

    protected List<BakedQuad> getQuads(@Nullable Direction face, List<BakedQuad> quads) {
        for (BakedQuad quad : quads) {
            LightUtil.setLightData((BakedQuad)quad, (int)0xF000F0);
        }
        return quads;
    }

    public boolean m_7541_() {
        return this.delegate.m_7541_();
    }

    public boolean m_7539_() {
        return this.delegate.m_7539_();
    }

    public boolean m_7547_() {
        return this.delegate.m_7547_();
    }

    public boolean m_7521_() {
        return this.delegate.m_7521_();
    }

    public TextureAtlasSprite m_6160_() {
        return this.delegate.m_6160_();
    }

    public ItemTransforms m_7442_() {
        return this.delegate.m_7442_();
    }

    public ItemOverrides m_7343_() {
        return this.delegate.m_7343_();
    }

    public BakedModel handlePerspective(ItemTransforms.TransformType cameraTransformType, PoseStack mat) {
        return ForgeHooksClient.handlePerspective((BakedModel)this, (ItemTransforms.TransformType)cameraTransformType, (PoseStack)mat);
    }
}

