/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import twilightforest.TFSounds;
import twilightforest.block.BuilderBlock;
import twilightforest.block.TFBlocks;
import twilightforest.block.TranslucentBuiltBlock;
import twilightforest.block.entity.TFBlockEntities;
import twilightforest.enums.TowerDeviceVariant;

public class CarminiteBuilderBlockEntity
extends BlockEntity {
    private static final int RANGE = 16;
    private int ticksRunning = 0;
    private int blockedCounter = 0;
    private int ticksStopped = 0;
    public boolean makingBlocks = false;
    private int blocksMade = 0;
    private BlockPos lastBlockCoords;
    private Player trackedPlayer;
    private final BlockState blockBuiltState = (BlockState)((Block)TFBlocks.BUILT_BLOCK.get()).m_49966_().m_61124_((Property)TranslucentBuiltBlock.ACTIVE, (Comparable)Boolean.valueOf(false));

    public CarminiteBuilderBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)TFBlockEntities.TOWER_BUILDER.get(), pos, state);
    }

    public void startBuilding() {
        this.makingBlocks = true;
        this.resetStats();
    }

    public void resetStats() {
        this.blocksMade = 0;
        this.lastBlockCoords = this.m_58899_();
        this.ticksStopped = 0;
        this.blockedCounter = 0;
    }

    public static void tick(Level level, BlockPos pos, BlockState state, CarminiteBuilderBlockEntity te) {
        if (!level.f_46443_ && te.makingBlocks) {
            if (te.trackedPlayer == null) {
                te.trackedPlayer = te.findClosestValidPlayer();
            }
            Direction nextFacing = te.findNextFacing();
            ++te.ticksRunning;
            if (te.ticksRunning % 10 == 0 && te.lastBlockCoords != null && nextFacing != null) {
                BlockPos nextPos = te.lastBlockCoords.m_142300_(nextFacing);
                if (te.blocksMade <= 16 && level.m_46859_(nextPos)) {
                    level.m_7731_(nextPos, te.blockBuiltState, 3);
                    level.m_5594_(null, pos, TFSounds.BUILDER_CREATE, SoundSource.BLOCKS, 0.75f, 1.2f);
                    te.lastBlockCoords = nextPos;
                    te.blockedCounter = 0;
                    ++te.blocksMade;
                } else {
                    ++te.blockedCounter;
                }
            }
            if (te.blockedCounter > 0) {
                te.makingBlocks = false;
                te.trackedPlayer = null;
                te.ticksStopped = 0;
            }
        } else if (!level.f_46443_ && !te.makingBlocks) {
            te.trackedPlayer = null;
            if (++te.ticksStopped == 60) {
                level.m_46597_(pos, (BlockState)state.m_61124_(BuilderBlock.STATE, (Comparable)((Object)TowerDeviceVariant.BUILDER_TIMEOUT)));
                level.m_186460_(pos, state.m_60734_(), 4);
            }
        }
    }

    private Direction findNextFacing() {
        if (this.trackedPlayer != null) {
            int pitch = Mth.m_14107_((double)((double)(this.trackedPlayer.m_146909_() * 4.0f / 360.0f) + 1.5)) & 3;
            if (pitch == 0) {
                return Direction.UP;
            }
            if (pitch == 2) {
                return Direction.DOWN;
            }
            return this.trackedPlayer.m_6350_();
        }
        return null;
    }

    private Player findClosestValidPlayer() {
        return this.f_58857_.m_45924_((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5, 16.0, false);
    }
}

