/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import twilightforest.block.AbstractTrophyBlock;
import twilightforest.block.TrophyBlock;
import twilightforest.enums.BossVariant;

public class TrophyWallBlock
extends AbstractTrophyBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    private static final Map<Direction, VoxelShape> SHAPES = Maps.newEnumMap((Map)ImmutableMap.of((Object)Direction.NORTH, (Object)Block.m_49796_((double)4.0, (double)4.0, (double)8.0, (double)12.0, (double)12.0, (double)16.0), (Object)Direction.SOUTH, (Object)Block.m_49796_((double)4.0, (double)4.0, (double)0.0, (double)12.0, (double)12.0, (double)8.0), (Object)Direction.EAST, (Object)Block.m_49796_((double)0.0, (double)4.0, (double)4.0, (double)8.0, (double)12.0, (double)12.0), (Object)Direction.WEST, (Object)Block.m_49796_((double)8.0, (double)4.0, (double)4.0, (double)16.0, (double)12.0, (double)12.0)));
    private static final Map<Direction, VoxelShape> YETI_SHAPES = Maps.newEnumMap((Map)ImmutableMap.of((Object)Direction.NORTH, (Object)Block.m_49796_((double)3.25, (double)4.0, (double)8.5, (double)12.75, (double)14.5, (double)16.0), (Object)Direction.SOUTH, (Object)Block.m_49796_((double)3.25, (double)4.0, (double)0.0, (double)12.75, (double)14.5, (double)7.5), (Object)Direction.EAST, (Object)Block.m_49796_((double)0.0, (double)4.0, (double)3.25, (double)7.5, (double)14.5, (double)12.75), (Object)Direction.WEST, (Object)Block.m_49796_((double)8.5, (double)4.0, (double)3.25, (double)16.0, (double)14.5, (double)12.75)));

    public TrophyWallBlock(BossVariant variant) {
        super(variant, 0, BlockBehaviour.Properties.m_60939_((Material)Material.f_76310_).m_60966_());
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    public String m_7705_() {
        return this.m_5456_().m_5524_();
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        if (((AbstractTrophyBlock)state.m_60734_()).getVariant() == BossVariant.UR_GHAST) {
            return TrophyBlock.GHAST_SHAPE;
        }
        if (((AbstractTrophyBlock)state.m_60734_()).getVariant() == BossVariant.ALPHA_YETI) {
            return YETI_SHAPES.get(state.m_61143_((Property)FACING));
        }
        return SHAPES.get(state.m_61143_((Property)FACING));
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        Direction[] adirection;
        BlockState blockstate = this.m_49966_();
        Level iblockreader = context.m_43725_();
        BlockPos blockpos = context.m_8083_();
        for (Direction direction : adirection = context.m_6232_()) {
            if (!direction.m_122434_().m_122479_()) continue;
            Direction direction1 = direction.m_122424_();
            blockstate = (BlockState)blockstate.m_61124_((Property)FACING, (Comparable)direction1);
            if (iblockreader.m_8055_(blockpos.m_142300_(direction)).m_60629_(context)) continue;
            return blockstate;
        }
        return null;
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirrorIn) {
        return state.m_60717_(mirrorIn.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, POWERED});
    }
}

