/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.registries.RegistryObject;
import twilightforest.block.HollowLogVertical;
import twilightforest.block.WaterloggedBlock;
import twilightforest.enums.HollowLogVariants;

public class HollowLogClimbable
extends HorizontalDirectionalBlock
implements WaterloggedBlock {
    public static final EnumProperty<HollowLogVariants.Climbable> VARIANT = EnumProperty.m_61587_((String)"variant", HollowLogVariants.Climbable.class);
    private static final VoxelShape LADDER_EAST = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)3.0, (double)16.0, (double)16.0);
    private static final VoxelShape LADDER_WEST = Block.m_49796_((double)13.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape LADDER_SOUTH = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)3.0);
    private static final VoxelShape LADDER_NORTH = Block.m_49796_((double)0.0, (double)0.0, (double)13.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape HOLLOW_SHAPE = Shapes.m_83113_((VoxelShape)Shapes.m_83144_(), (VoxelShape)Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0), (BooleanOp)BooleanOp.f_82685_);
    private static final VoxelShape HOLLOW_SHAPE_SOUTH = Shapes.m_83110_((VoxelShape)HOLLOW_SHAPE, (VoxelShape)LADDER_SOUTH);
    private static final VoxelShape HOLLOW_SHAPE_NORTH = Shapes.m_83110_((VoxelShape)HOLLOW_SHAPE, (VoxelShape)LADDER_NORTH);
    private static final VoxelShape HOLLOW_SHAPE_EAST = Shapes.m_83110_((VoxelShape)HOLLOW_SHAPE, (VoxelShape)LADDER_EAST);
    private static final VoxelShape HOLLOW_SHAPE_WEST = Shapes.m_83110_((VoxelShape)HOLLOW_SHAPE, (VoxelShape)LADDER_WEST);
    private static final VoxelShape COLLISION_SHAPE = Shapes.m_83113_((VoxelShape)Shapes.m_83144_(), (VoxelShape)Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0), (BooleanOp)BooleanOp.f_82685_);
    private static final VoxelShape COLLISION_SHAPE_SOUTH = Shapes.m_83110_((VoxelShape)COLLISION_SHAPE, (VoxelShape)LADDER_SOUTH);
    private static final VoxelShape COLLISION_SHAPE_NORTH = Shapes.m_83110_((VoxelShape)COLLISION_SHAPE, (VoxelShape)LADDER_NORTH);
    private static final VoxelShape COLLISION_SHAPE_EAST = Shapes.m_83110_((VoxelShape)COLLISION_SHAPE, (VoxelShape)LADDER_EAST);
    private static final VoxelShape COLLISION_SHAPE_WEST = Shapes.m_83110_((VoxelShape)COLLISION_SHAPE, (VoxelShape)LADDER_WEST);
    private final RegistryObject<HollowLogVertical> vertical;

    public HollowLogClimbable(BlockBehaviour.Properties props, RegistryObject<HollowLogVertical> vertical) {
        super(props);
        this.vertical = vertical;
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_(VARIANT, (Comparable)((Object)HollowLogVariants.Climbable.VINE))).m_61124_((Property)f_54117_, (Comparable)Direction.NORTH));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        VoxelShape voxelShape;
        if (state.m_61143_(VARIANT) == HollowLogVariants.Climbable.VINE) {
            voxelShape = HOLLOW_SHAPE;
        } else {
            switch ((Direction)state.m_61143_((Property)f_54117_)) {
                case SOUTH: {
                    voxelShape = HOLLOW_SHAPE_SOUTH;
                    break;
                }
                case WEST: {
                    voxelShape = HOLLOW_SHAPE_WEST;
                    break;
                }
                case EAST: {
                    voxelShape = HOLLOW_SHAPE_EAST;
                    break;
                }
                default: {
                    voxelShape = HOLLOW_SHAPE_NORTH;
                }
            }
        }
        return voxelShape;
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        VoxelShape voxelShape;
        if (state.m_61143_(VARIANT) == HollowLogVariants.Climbable.VINE) {
            voxelShape = COLLISION_SHAPE;
        } else {
            switch ((Direction)state.m_61143_((Property)f_54117_)) {
                case SOUTH: {
                    voxelShape = COLLISION_SHAPE_SOUTH;
                    break;
                }
                case WEST: {
                    voxelShape = COLLISION_SHAPE_WEST;
                    break;
                }
                case EAST: {
                    voxelShape = COLLISION_SHAPE_EAST;
                    break;
                }
                default: {
                    voxelShape = COLLISION_SHAPE_NORTH;
                }
            }
        }
        return voxelShape;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder.m_61104_(new Property[]{VARIANT, f_54117_}));
    }

    @Override
    public boolean isStateWaterlogged(BlockState state) {
        return state.m_61143_(VARIANT) == HollowLogVariants.Climbable.LADDER_WATERLOGGED;
    }

    @Override
    public BlockState setWaterlog(BlockState prior, boolean doWater) {
        return switch ((HollowLogVariants.Climbable)((Object)prior.m_61143_(VARIANT))) {
            default -> throw new IncompatibleClassChangeError();
            case HollowLogVariants.Climbable.VINE -> {
                if (doWater) {
                    yield (BlockState)((HollowLogVertical)((Object)this.vertical.get())).m_49966_().m_61124_((Property)HollowLogVertical.WATERLOGGED, (Comparable)Boolean.valueOf(true));
                }
                yield prior;
            }
            case HollowLogVariants.Climbable.LADDER -> (BlockState)prior.m_61124_(VARIANT, (Comparable)((Object)HollowLogVariants.Climbable.LADDER_WATERLOGGED));
            case HollowLogVariants.Climbable.LADDER_WATERLOGGED -> (BlockState)prior.m_61124_(VARIANT, (Comparable)((Object)HollowLogVariants.Climbable.LADDER));
        };
    }

    public FluidState m_5888_(BlockState state) {
        return state.m_61143_(VARIANT) == HollowLogVariants.Climbable.LADDER_WATERLOGGED ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        if (this.isStateWaterlogged(state)) {
            level.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        return super.m_7417_(state, facing, neighborState, level, pos, neighborPos);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (!HollowLogClimbable.isInside((HitResult)hit, pos)) {
            return super.m_6227_(state, level, pos, player, hand, hit);
        }
        ItemStack stack = player.m_21120_(hand);
        if (stack.canPerformAction(ToolActions.SHEARS_HARVEST)) {
            HollowLogVariants.Climbable variant = (HollowLogVariants.Climbable)((Object)state.m_61143_(VARIANT));
            level.m_7731_(pos, (BlockState)((HollowLogVertical)((Object)this.vertical.get())).m_49966_().m_61124_((Property)HollowLogVertical.WATERLOGGED, (Comparable)Boolean.valueOf(variant == HollowLogVariants.Climbable.LADDER_WATERLOGGED)), 3);
            level.m_5594_(null, pos, SoundEvents.f_12344_, SoundSource.BLOCKS, 1.0f, 1.0f);
            if (!player.m_7500_()) {
                stack.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(hand));
                level.m_7967_((Entity)new ItemEntity(level, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, new ItemStack((ItemLike)(variant == HollowLogVariants.Climbable.VINE ? Blocks.f_50191_ : Blocks.f_50155_))));
            }
            player.m_6674_(hand);
            return InteractionResult.CONSUME;
        }
        return super.m_6227_(state, level, pos, player, hand, hit);
    }

    private static boolean isInside(HitResult result, BlockPos pos) {
        Vec3 vec = result.m_82450_().m_82492_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
        return 0.124 <= vec.f_82479_ && vec.f_82479_ <= 0.876 && 0.124 <= vec.f_82481_ && vec.f_82481_ <= 0.876;
    }

    public int getFlammability(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        return 5;
    }

    public int getFireSpreadSpeed(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        return 5;
    }
}

