/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.rhino;

import dev.latvian.mods.rhino.Context;
import dev.latvian.mods.rhino.ContinuationPending;
import dev.latvian.mods.rhino.JavaMembers;
import dev.latvian.mods.rhino.VMBridge;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public final class MemberBox {
    transient Class<?>[] argTypes;
    transient Object delegateTo;
    transient boolean vararg;
    public transient Executable memberObject;

    private static Method searchAccessibleMethod(Method method, Class<?>[] params) {
        Class<?> c;
        int modifiers = method.getModifiers();
        if (Modifier.isPublic(modifiers) && !Modifier.isStatic(modifiers) && !Modifier.isPublic((c = method.getDeclaringClass()).getModifiers())) {
            String name = method.getName();
            Class<?>[] intfs = c.getInterfaces();
            int N = intfs.length;
            for (int i = 0; i != N; ++i) {
                Class<?> intf = intfs[i];
                if (!Modifier.isPublic(intf.getModifiers())) continue;
                try {
                    return intf.getMethod(name, params);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    continue;
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
            }
            while ((c = c.getSuperclass()) != null) {
                if (!Modifier.isPublic(c.getModifiers())) continue;
                try {
                    Method m = c.getMethod(name, params);
                    int mModifiers = m.getModifiers();
                    if (!Modifier.isPublic(mModifiers) || Modifier.isStatic(mModifiers)) continue;
                    return m;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                }
                catch (SecurityException securityException) {
                }
            }
        }
        return null;
    }

    MemberBox(Method method) {
        this.init(method);
    }

    MemberBox(Constructor<?> constructor) {
        this.init(constructor);
    }

    private void init(Method method) {
        this.memberObject = method;
        this.argTypes = method.getParameterTypes();
        this.vararg = method.isVarArgs();
    }

    private void init(Constructor<?> constructor) {
        this.memberObject = constructor;
        this.argTypes = constructor.getParameterTypes();
        this.vararg = constructor.isVarArgs();
    }

    Method method() {
        return (Method)this.memberObject;
    }

    Constructor<?> ctor() {
        return (Constructor)this.memberObject;
    }

    Member member() {
        return this.memberObject;
    }

    boolean isMethod() {
        return this.memberObject instanceof Method;
    }

    boolean isCtor() {
        return this.memberObject instanceof Constructor;
    }

    boolean isStatic() {
        return Modifier.isStatic(this.memberObject.getModifiers());
    }

    boolean isPublic() {
        return Modifier.isPublic(this.memberObject.getModifiers());
    }

    String getName() {
        return this.memberObject.getName();
    }

    Class<?> getDeclaringClass() {
        return this.memberObject.getDeclaringClass();
    }

    String toJavaDeclaration() {
        StringBuilder sb = new StringBuilder();
        if (this.isMethod()) {
            Method method = this.method();
            sb.append(method.getReturnType());
            sb.append(' ');
            sb.append(method.getName());
        } else {
            Constructor<?> ctor = this.ctor();
            String name = ctor.getDeclaringClass().getName();
            int lastDot = name.lastIndexOf(46);
            if (lastDot >= 0) {
                name = name.substring(lastDot + 1);
            }
            sb.append(name);
        }
        sb.append(JavaMembers.liveConnectSignature(this.argTypes));
        return sb.toString();
    }

    public String toString() {
        return this.memberObject.toString();
    }

    Object invoke(Object target, Object[] args) {
        Method method = this.method();
        try {
            try {
                return method.invoke(target, args);
            }
            catch (IllegalAccessException ex) {
                Method accessible = MemberBox.searchAccessibleMethod(method, this.argTypes);
                if (accessible != null) {
                    this.memberObject = accessible;
                    method = accessible;
                } else if (!VMBridge.tryToMakeAccessible(target, method)) {
                    throw Context.throwAsScriptRuntimeEx(ex);
                }
                return method.invoke(target, args);
            }
        }
        catch (InvocationTargetException ite) {
            Throwable e = ite;
            while ((e = e.getTargetException()) instanceof InvocationTargetException) {
            }
            if (e instanceof ContinuationPending) {
                throw (ContinuationPending)e;
            }
            throw Context.throwAsScriptRuntimeEx(e);
        }
        catch (Exception ex) {
            throw Context.throwAsScriptRuntimeEx(ex);
        }
    }

    Object newInstance(Object[] args) {
        Constructor<?> ctor = this.ctor();
        try {
            try {
                return ctor.newInstance(args);
            }
            catch (IllegalAccessException ex) {
                if (!VMBridge.tryToMakeAccessible(null, ctor)) {
                    throw Context.throwAsScriptRuntimeEx(ex);
                }
                return ctor.newInstance(args);
            }
        }
        catch (Exception ex) {
            throw Context.throwAsScriptRuntimeEx(ex);
        }
    }
}

