/*
 * Decompiled with CFR 0.152.
 */
package codechicken.enderstorage.init;

import codechicken.enderstorage.init.EnderStorageModContent;
import codechicken.lib.datagen.ItemModelProvider;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.tags.BlockTagsProvider;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.forge.event.lifecycle.GatherDataEvent;
import org.jetbrains.annotations.Nullable;

@Mod.EventBusSubscriber(modid="enderstorage", bus=Mod.EventBusSubscriber.Bus.MOD)
public class DataGenerators {
    @SubscribeEvent
    public static void gatherDataGenerators(GatherDataEvent event) {
        DataGenerator gen = event.getGenerator();
        ExistingFileHelper files = event.getExistingFileHelper();
        if (event.includeClient()) {
            gen.m_123914_((DataProvider)new BlockStates(gen, files));
            gen.m_123914_((DataProvider)new ItemModels(gen, files));
        }
        if (event.includeServer()) {
            gen.m_123914_((DataProvider)new BlockTagGen(gen, files));
        }
    }

    private static class BlockStates
    extends BlockStateProvider {
        public BlockStates(DataGenerator gen, ExistingFileHelper exFileHelper) {
            super(gen, "enderstorage", exFileHelper);
        }

        @Nonnull
        public String m_6055_() {
            return "EnderStorage BlockStates";
        }

        protected void registerStatesAndModels() {
            ModelBuilder model = ((BlockModelBuilder)this.models().withExistingParent("dummy", "block")).texture("particle", "minecraft:block/obsidian");
            this.simpleBlock((Block)EnderStorageModContent.ENDER_CHEST_BLOCK.get(), (ModelFile)model);
            this.simpleBlock((Block)EnderStorageModContent.ENDER_TANK_BLOCK.get(), (ModelFile)model);
        }
    }

    private static class ItemModels
    extends ItemModelProvider {
        public ItemModels(DataGenerator generator, ExistingFileHelper existingFileHelper) {
            super(generator, "enderstorage", existingFileHelper);
        }

        protected void registerModels() {
            this.generated((Supplier)EnderStorageModContent.ENDER_CHEST_ITEM).noTexture();
            this.generated((Supplier)EnderStorageModContent.ENDER_TANK_ITEM).noTexture();
            this.generated((Supplier)EnderStorageModContent.ENDER_POUCH).noTexture();
        }

        public String m_6055_() {
            return "EnderStorage Item models";
        }
    }

    private static class BlockTagGen
    extends BlockTagsProvider {
        public BlockTagGen(DataGenerator gen, @Nullable ExistingFileHelper existingFileHelper) {
            super(gen, "enderstorage", existingFileHelper);
        }

        protected void m_6577_() {
            this.m_206424_(BlockTags.f_144282_).m_126582_((Object)((Block)EnderStorageModContent.ENDER_CHEST_BLOCK.get())).m_126582_((Object)((Block)EnderStorageModContent.ENDER_TANK_BLOCK.get()));
        }
    }
}

