/*
 * Decompiled with CFR 0.152.
 */
package codechicken.enderstorage.block;

import codechicken.enderstorage.block.BlockEnderStorage;
import codechicken.enderstorage.init.EnderStorageModContent;
import codechicken.enderstorage.tile.TileEnderTank;
import codechicken.enderstorage.tile.TileFrequencyOwner;
import codechicken.lib.raytracer.IndexedVoxelShape;
import codechicken.lib.raytracer.MultiIndexedVoxelShape;
import codechicken.lib.raytracer.VoxelShapeCache;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.Scale;
import codechicken.lib.vec.Transformation;
import codechicken.lib.vec.Translation;
import codechicken.lib.vec.Vector3;
import com.google.common.collect.ImmutableSet;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BlockEnderTank
extends BlockEnderStorage {
    private static final IndexedVoxelShape TANK = new IndexedVoxelShape(Shapes.m_166049_((double)0.15, (double)0.0, (double)0.15, (double)0.85, (double)0.916, (double)0.85), (Object)0);
    private static final IndexedVoxelShape[][] BUTTONS = new IndexedVoxelShape[4][3];
    private static final IndexedVoxelShape[] DIAL = new IndexedVoxelShape[4];
    private static final MultiIndexedVoxelShape[] SHAPES = new MultiIndexedVoxelShape[4];
    public static Transformation[] buttonT = new Transformation[3];

    public BlockEnderTank(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        IndexedVoxelShape shape = TANK;
        BlockEntity t = worldIn.m_7702_(pos);
        if (t instanceof TileEnderTank) {
            TileEnderTank tile = (TileEnderTank)t;
            shape = SHAPES[tile.rotation];
        }
        return shape;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new TileEnderTank(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level p_153212_, BlockState p_153213_, BlockEntityType<T> p_153214_) {
        return BlockEnderTank.m_152132_(p_153214_, (BlockEntityType)((BlockEntityType)EnderStorageModContent.ENDER_TANK_TILE.get()), (level, pos, state, tile) -> tile.tick());
    }

    static {
        boolean asd = false;
        for (int i = 0; i < 3; ++i) {
            BlockEnderTank.buttonT[i] = new Scale(0.6).with((Transformation)new Translation(0.35 + (double)(2 - i) * 0.15, 0.91, 0.5));
        }
        Cuboid6 dialBase = new Cuboid6(0.358, 0.268, 0.05, 0.662, 0.565, 0.15);
        for (int rot = 0; rot < 4; ++rot) {
            Transformation rotation = Rotation.quarterRotations[rot ^ 2].at(Vector3.CENTER);
            for (int button = 0; button < 3; ++button) {
                BlockEnderTank.BUTTONS[rot][button] = new IndexedVoxelShape(VoxelShapeCache.getShape((Cuboid6)TileFrequencyOwner.SELECTION_BUTTON.copy().apply(buttonT[button]).apply(rotation)), (Object)(button + 1));
            }
            BlockEnderTank.DIAL[rot] = new IndexedVoxelShape(VoxelShapeCache.getShape((Cuboid6)dialBase.copy().apply(rotation)), (Object)4);
            ImmutableSet.Builder cuboids = ImmutableSet.builder();
            cuboids.add((Object)TANK);
            cuboids.add(BUTTONS[rot]);
            cuboids.add((Object)DIAL[rot]);
            BlockEnderTank.SHAPES[rot] = new MultiIndexedVoxelShape((VoxelShape)TANK, cuboids.build());
        }
    }
}

