/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.world;

import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.zerono.mods.zerocore.lib.world.OreGenRegisteredFeature;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockMatchTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockStateMatchTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.TagMatchTest;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.commons.lang3.tuple.Pair;

abstract class AbstractWorldGenFeaturesMap<PredicateObject> {
    protected final Map<GenerationStep.Decoration, List<Pair<Predicate<PredicateObject>, Supplier<Holder<PlacedFeature>>>>> _entries = new Object2ObjectArrayMap(16);

    public static RuleTest oreMatch(Block block) {
        return new BlockMatchTest(block);
    }

    public static RuleTest oreMatch(TagKey<Block> tag) {
        return new TagMatchTest(tag);
    }

    public static RuleTest oreMatch(BlockState state) {
        return new BlockStateMatchTest(state);
    }

    public void addOreVein(Predicate<PredicateObject> biomeMatcher, OreGenRegisteredFeature feature) {
        this.add(GenerationStep.Decoration.UNDERGROUND_ORES, biomeMatcher, feature);
    }

    protected AbstractWorldGenFeaturesMap() {
        FMLJavaModLoadingContext.get().getModEventBus().addGenericListener(Feature.class, EventPriority.HIGHEST, this::clearItems);
    }

    protected void add(GenerationStep.Decoration stage, Predicate<PredicateObject> biomeMatcher, Supplier<Holder<PlacedFeature>> featureSupplier) {
        this._entries.computeIfAbsent(stage, s -> new ObjectArrayList(8)).add(Pair.of(biomeMatcher, featureSupplier));
    }

    public void clearItems(RegistryEvent.Register<Feature<?>> event) {
        this._entries.clear();
    }
}

