/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.item.inventory.container.data;

import it.zerono.mods.zerocore.lib.data.stack.IStackHolderAccess;
import it.zerono.mods.zerocore.lib.item.ItemHelper;
import it.zerono.mods.zerocore.lib.item.inventory.ItemStackHolder;
import it.zerono.mods.zerocore.lib.item.inventory.container.data.IContainerData;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.NonNullConsumer;
import net.minecraftforge.common.util.NonNullSupplier;
import net.minecraftforge.items.IItemHandlerModifiable;

public class ItemStackData
implements IContainerData {
    private final NonNullSupplier<ItemStack> _getter;
    private final NonNullConsumer<ItemStack> _setter;
    private ItemStack _lastValue;

    public ItemStackData(NonNullSupplier<ItemStack> getter, NonNullConsumer<ItemStack> setter) {
        this._getter = getter;
        this._setter = setter;
        this._lastValue = ItemStack.f_41583_;
    }

    public static ItemStackData wrap(NonNullList<ItemStack> list, int index) {
        return new ItemStackData((NonNullSupplier<ItemStack>)((NonNullSupplier)() -> (ItemStack)list.get(index)), (NonNullConsumer<ItemStack>)((NonNullConsumer)v -> list.set(index, v)));
    }

    public static ItemStackData wrap(IItemHandlerModifiable handler, int slot) {
        return new ItemStackData((NonNullSupplier<ItemStack>)((NonNullSupplier)() -> handler.getStackInSlot(slot)), (NonNullConsumer<ItemStack>)((NonNullConsumer)v -> handler.setStackInSlot(slot, v)));
    }

    public static ItemStackData wrap(IStackHolderAccess<ItemStackHolder, ItemStack> holder, int index) {
        return new ItemStackData((NonNullSupplier<ItemStack>)((NonNullSupplier)() -> (ItemStack)holder.getStackAt(index)), (NonNullConsumer<ItemStack>)((NonNullConsumer)v -> holder.setStackAt(index, (ItemStack)v)));
    }

    @Override
    @Nullable
    public NonNullConsumer<FriendlyByteBuf> getContainerDataWriter() {
        ItemStack current = (ItemStack)this._getter.get();
        if (this._lastValue.m_41619_() && current.m_41619_()) {
            return null;
        }
        boolean equalItem = ItemHelper.stackMatch(this._lastValue, current, ItemHelper.MatchOption.MATCH_ITEM_NBT);
        if (!equalItem || current.m_41613_() != this._lastValue.m_41613_()) {
            this._lastValue = current.m_41777_();
            if (equalItem) {
                return buffer -> {
                    buffer.writeByte(1);
                    buffer.m_130130_(this._lastValue.m_41613_());
                };
            }
            return buffer -> {
                buffer.writeByte(0);
                buffer.writeItemStack(this._lastValue, true);
            };
        }
        return null;
    }

    @Override
    public void readContainerData(FriendlyByteBuf dataSource) {
        switch (dataSource.readByte()) {
            case 0: {
                this._setter.accept((Object)dataSource.m_130267_());
                break;
            }
            case 1: {
                this._setter.accept((Object)ItemHelper.stackFrom((ItemStack)this._getter.get(), dataSource.m_130242_()));
            }
        }
    }
}

