/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.datagen.provider.recipe;

import com.google.common.base.Preconditions;
import com.google.gson.JsonObject;
import it.zerono.mods.zerocore.lib.datagen.provider.recipe.AbstractModRecipeBuilder;
import it.zerono.mods.zerocore.lib.recipe.ingredient.IRecipeIngredient;
import it.zerono.mods.zerocore.lib.recipe.result.IRecipeResult;
import java.util.function.Consumer;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;

public class OneToOneRecipeBuilder<RecipeIngredient, RecipeResult>
extends AbstractModRecipeBuilder<OneToOneRecipeBuilder<RecipeIngredient, RecipeResult>> {
    private final IRecipeIngredient<RecipeIngredient> _ingredient;
    private final IRecipeResult<RecipeResult> _result;

    public OneToOneRecipeBuilder(ResourceLocation serializerId, IRecipeIngredient<RecipeIngredient> ingredient, IRecipeResult<RecipeResult> result) {
        super(serializerId);
        Preconditions.checkArgument((!ingredient.isEmpty() ? 1 : 0) != 0, (Object)"An ingredient cannot be empty");
        Preconditions.checkArgument((!result.isEmpty() ? 1 : 0) != 0, (Object)"A result cannot be empty");
        this._ingredient = ingredient;
        this._result = result;
    }

    public void build(Consumer<FinishedRecipe> consumer) {
        this.build(consumer, this._result.getId());
    }

    @Override
    protected FinishedRecipe getFinishedRecipe(ResourceLocation id) {
        return new OneToOneRecipeBuilderFinishedRecipe(id);
    }

    public class OneToOneRecipeBuilderFinishedRecipe
    extends AbstractModRecipeBuilder.AbstractFinishedRecipe {
        protected OneToOneRecipeBuilderFinishedRecipe(ResourceLocation id) {
            super(id);
        }

        public void m_7917_(JsonObject json) {
            json.add("ingredient", OneToOneRecipeBuilder.this._ingredient.serializeTo());
            json.add("result", OneToOneRecipeBuilder.this._result.serializeTo());
        }
    }
}

