/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.compat;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraftforge.common.util.NonNullSupplier;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.IForgeRegistryEntry;

public enum Mods {
    MINECRAFT("minecraft"),
    ZEROCORE("zerocore"),
    EXTREMEREACTORS("bigreactors"),
    COMPUTERCRAFT("computercraft"),
    OPENCOMPUTERS("opencomputers"),
    MEKANISM("mekanism"),
    COFHCORE("cofhcore"),
    COFHWORLD("cofhworld"),
    ENDERIO("enderio"),
    FORESTRY("forestry"),
    JEI("jei"),
    REDSTONEFLUX("redstoneflux"),
    THERMALEXPANSION("thermalexpansion"),
    THERMALDYNAMICS("thermaldynamics"),
    THERMALFOUNDATION("thermalfoundation"),
    MINEFACTORYRELOADED("minefactoryreloaded"),
    APPLIEDENERGISTICS2("appliedenergistics2"),
    PATCHOULI("patchouli");

    private final String _id;
    private final boolean _present;

    public static Optional<Mods> from(String id) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)id) ? 1 : 0) != 0);
        for (Mods mod : Mods.values()) {
            if (!mod.match(id)) continue;
            return Optional.of(mod);
        }
        return Optional.empty();
    }

    public String id() {
        return this._id;
    }

    public boolean match(String id) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)id) ? 1 : 0) != 0);
        return this.id().equals(id);
    }

    public boolean isPresent() {
        return this._present;
    }

    public void ifPresent(Runnable present) {
        if (this.isPresent()) {
            present.run();
        }
    }

    public void ifPresent(NonNullSupplier<Runnable> present) {
        if (this.isPresent()) {
            ((Runnable)present.get()).run();
        }
    }

    public void ifPresentOrElse(Runnable present, Runnable notPresent) {
        if (this.isPresent()) {
            present.run();
        } else {
            notPresent.run();
        }
    }

    public void ifPresentOrElse(NonNullSupplier<Runnable> present, NonNullSupplier<Runnable> notPresent) {
        if (this.isPresent()) {
            ((Runnable)present.get()).run();
        } else {
            ((Runnable)notPresent.get()).run();
        }
    }

    public <T> Optional<T> map(Supplier<T> supplier) {
        return this.isPresent() ? Optional.of(supplier.get()) : Optional.empty();
    }

    public <T> Optional<T> flatMap(Supplier<Optional<T>> supplier) {
        return this.isPresent() ? supplier.get() : Optional.empty();
    }

    public boolean owns(IForgeRegistryEntry<?> entry) {
        return this.isPresent() && null != entry.getRegistryName() && this.match(entry.getRegistryName().m_135827_());
    }

    public void imc(Mods sender, String method, Supplier<?> thing) {
        if (this.isPresent()) {
            InterModComms.sendTo((String)sender.id(), (String)this.id(), (String)method, thing);
        }
    }

    private Mods(String id) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)id) ? 1 : 0) != 0);
        this._id = id;
        this._present = ModList.get().isLoaded(id);
    }
}

