/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.client.model;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import it.zerono.mods.zerocore.lib.client.render.ModRenderHelper;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ForgeModelBakery;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

public class ModBakedModelSupplier {
    private final List<ResourceLocation> _toBeRegistered = Lists.newArrayList();
    private final Map<ResourceLocation, Wrapper> _wrappers = Maps.newHashMap();

    public ModBakedModelSupplier() {
        ((IEventBus)Mod.EventBusSubscriber.Bus.MOD.bus().get()).register((Object)this);
    }

    public void addModel(ResourceLocation name) {
        if (!this._toBeRegistered.contains(name)) {
            this._toBeRegistered.add(name);
        }
    }

    public Supplier<BakedModel> getOrCreate(ResourceLocation name) {
        return this._wrappers.computeIfAbsent(name, resourceLocation -> new Wrapper());
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onRegisterModels(ModelRegistryEvent event) {
        this._toBeRegistered.forEach(ForgeModelBakery::addSpecialModel);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onModelBake(ModelBakeEvent event) {
        Map modelRegistry = event.getModelRegistry();
        BakedModel missing = ModRenderHelper.getMissingModel();
        this._wrappers.forEach((key, value) -> {
            value._cachedModel = modelRegistry.getOrDefault(key, missing);
        });
    }

    private static class Wrapper
    implements Supplier<BakedModel> {
        private BakedModel _cachedModel = null;

        protected Wrapper() {
        }

        @Override
        public BakedModel get() {
            return this._cachedModel;
        }
    }
}

