/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.base.multiblock.part.io;

import it.zerono.mods.zerocore.base.multiblock.part.GenericDeviceBlock;
import it.zerono.mods.zerocore.lib.block.INeighborChangeListener;
import it.zerono.mods.zerocore.lib.block.multiblock.MultiblockPartBlock;
import it.zerono.mods.zerocore.lib.data.IIoEntity;
import it.zerono.mods.zerocore.lib.multiblock.IMultiblockController;
import it.zerono.mods.zerocore.lib.tag.TagsHelper;
import it.zerono.mods.zerocore.lib.world.WorldHelper;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;

public class IOPortBlock<Controller extends IMultiblockController<Controller>, PartType extends Enum<PartType>>
extends GenericDeviceBlock<Controller, PartType>
implements INeighborChangeListener.Notifier {
    public IOPortBlock(MultiblockPartBlock.MultiblockPartProperties<PartType> properties) {
        super(properties);
    }

    public void m_6810_(BlockState state, Level world, BlockPos position, BlockState newState, boolean isMoving) {
        if (state.m_60734_() != newState.m_60734_()) {
            this.getIIoEntity(world, position).ifPresent(ioe -> ioe.onBlockReplaced(state, world, position, newState, isMoving));
        }
        super.m_6810_(state, world, position, newState, isMoving);
    }

    @Override
    public InteractionResult m_6227_(BlockState state, Level world, BlockPos position, Player player, InteractionHand hand, BlockHitResult hit) {
        if (InteractionHand.MAIN_HAND == hand && player.m_21205_().m_204117_(TagsHelper.TAG_WRENCH)) {
            this.callOnLogicalServer(world, (Level w) -> this.getIIoEntity((Level)w, position).ifPresent(IIoEntity::toggleIoDirection));
            return InteractionResult.SUCCESS;
        }
        return super.m_6227_(state, world, position, player, hand, hit);
    }

    private Optional<IIoEntity> getIIoEntity(Level world, BlockPos position) {
        return WorldHelper.getTile(world, position).filter(te -> te instanceof IIoEntity).map(te -> (IIoEntity)te);
    }
}

