/*
 * Decompiled with CFR 0.152.
 */
package me.hypherionmc.simplerpc;

import me.hypherionmc.simplerpc.ForgeSidedHandler;
import me.hypherionmc.simplerpc.SimpleRPCClient;
import me.hypherionmc.simplerpc.SimpleRPCServer;
import me.hypherionmc.simplerpc.network.NetworkHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.IExtensionPoint;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.util.thread.EffectiveSide;

@Mod(value="simplerpc")
public class SimpleRPCForge {
    private static MinecraftServer server;

    public SimpleRPCForge() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::commonSetup);
        ModLoadingContext.get().registerExtensionPoint(IExtensionPoint.DisplayTest.class, () -> new IExtensionPoint.DisplayTest(() -> "", (a, b) -> true));
    }

    public void commonSetup(FMLCommonSetupEvent event) {
        DistExecutor.unsafeRunForDist(() -> () -> {
            SimpleRPCClient.sidedHandler = new ForgeSidedHandler();
            return null;
        }, () -> () -> {
            SimpleRPCClient.sidedHandler = new ForgeSidedHandler();
            SimpleRPCServer.init();
            return null;
        });
        MinecraftForge.EVENT_BUS.register((Object)this);
        NetworkHandler.registerMessages();
    }

    @SubscribeEvent
    public void clientTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.START && event.player.f_19853_.f_46443_) {
            SimpleRPCClient.clientTick(Minecraft.m_91087_());
        }
    }

    @SubscribeEvent
    public void onJoinEvent(EntityJoinWorldEvent event) {
        if (event.getEntity() instanceof Player && EffectiveSide.get().isClient()) {
            SimpleRPCClient.playerJoinGame((Player)event.getEntity());
        }
        if (event.getEntity() instanceof ServerPlayer && EffectiveSide.get().isServer()) {
            SimpleRPCServer.playerJoinServer((ServerPlayer)event.getEntity());
        }
    }

    @SubscribeEvent
    public void serverStartEvent(ServerStartingEvent event) {
        server = event.getServer();
        SimpleRPCServer.registerListener(server);
    }

    @SubscribeEvent
    public void serverTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END && event.side == LogicalSide.SERVER) {
            DistExecutor.unsafeRunForDist(() -> () -> null, () -> () -> {
                if (server != null) {
                    SimpleRPCServer.serverTick(server);
                }
                return null;
            });
        }
    }
}

