/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.supermartijn642.core.ClientUtils;
import com.supermartijn642.core.render.CustomItemRenderer;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HalfTransparentBlock;
import net.minecraft.world.level.block.StainedGlassPaneBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.client.ForgeHooksClient;

public class BlockEntityCustomItemRenderer<T extends BlockEntity>
implements CustomItemRenderer {
    protected final boolean renderItemModel;
    protected final Supplier<T> initEntity;
    protected final BiConsumer<ItemStack, T> entityUpdater;
    protected T blockEntity;

    public BlockEntityCustomItemRenderer(boolean renderItemModel, Supplier<T> initEntity, BiConsumer<ItemStack, T> entityUpdater) {
        this.renderItemModel = renderItemModel;
        this.initEntity = initEntity;
        this.entityUpdater = entityUpdater;
    }

    @Override
    public void render(ItemStack itemStack, ItemTransforms.TransformType transformType, PoseStack poseStack, MultiBufferSource bufferSource, int combinedLight, int combinedOverlay) {
        if (this.blockEntity == null) {
            this.blockEntity = (BlockEntity)this.initEntity.get();
            if (this.blockEntity == null) {
                throw new RuntimeException("Init entity function must not return a null block entity!");
            }
        }
        this.entityUpdater.accept(itemStack, (ItemStack)this.blockEntity);
        if (this.renderItemModel) {
            this.renderDefaultModel(itemStack, transformType, poseStack, bufferSource, combinedLight, combinedOverlay);
        }
        ClientUtils.getMinecraft().m_167982_().m_112272_(this.blockEntity, poseStack, bufferSource, combinedLight, combinedOverlay);
    }

    protected void renderDefaultModel(ItemStack itemStack, ItemTransforms.TransformType transformType, PoseStack poseStack, MultiBufferSource bufferSource, int combinedLight, int combinedOverlay) {
        Block block;
        if (itemStack.m_41619_()) {
            return;
        }
        ItemRenderer itemRenderer = ClientUtils.getItemRenderer();
        BakedModel model = itemRenderer.m_174264_(itemStack, null, null, 0);
        boolean fabulous = transformType != ItemTransforms.TransformType.GUI && !transformType.m_111841_() && itemStack.m_41720_() instanceof BlockItem ? !((block = ((BlockItem)itemStack.m_41720_()).m_40614_()) instanceof HalfTransparentBlock) && !(block instanceof StainedGlassPaneBlock) : true;
        if (model.isLayered()) {
            ForgeHooksClient.drawItemLayered((ItemRenderer)itemRenderer, (BakedModel)model, (ItemStack)itemStack, (PoseStack)poseStack, (MultiBufferSource)bufferSource, (int)combinedLight, (int)combinedOverlay, (boolean)fabulous);
        } else {
            RenderType renderType = ItemBlockRenderTypes.m_109279_((ItemStack)itemStack, (boolean)fabulous);
            VertexConsumer vertexConsumer = fabulous ? ItemRenderer.m_115222_((MultiBufferSource)bufferSource, (RenderType)renderType, (boolean)true, (boolean)itemStack.m_41790_()) : ItemRenderer.m_115211_((MultiBufferSource)bufferSource, (RenderType)renderType, (boolean)true, (boolean)itemStack.m_41790_());
            itemRenderer.m_115189_(model, itemStack, combinedLight, combinedOverlay, poseStack, vertexConsumer);
        }
    }
}

